/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata.datasource;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.StudioPathManager;
import com.google.common.base.Charsets;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceContent
implements Function<OutputStream, Exception> {
    private static final Logger LOG = Logger.getInstance(ResourceContent.class);
    byte[] myContent;

    private ResourceContent(@NotNull byte[] content2) {
        this.myContent = content2;
    }

    @Nullable
    public static File getSampleDataBaseDir() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        String[] paths = new String[]{FileUtil.join((String[])new String[]{homePath, "plugins/android/lib/sampleData"}), StudioPathManager.isRunningFromSources() ? FileUtil.join((String[])new String[]{StudioPathManager.getSourcesRoot(), "tools/adt/idea/android/lib/sampleData"}) : null, FileUtil.join((String[])new String[]{homePath, "/community/android/android/lib/sampleData"})};
        StringBuilder notFoundPaths = new StringBuilder();
        for (String jarPath : paths) {
            if (jarPath == null) continue;
            File rootFile = new File(jarPath);
            if (rootFile.exists()) {
                LOG.debug("Sample data base dir found at " + jarPath);
                return rootFile;
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.warn("Unable to sampleData in paths:\n" + notFoundPaths.toString());
        return null;
    }

    @Nullable
    public static File getSampleDataUserDir(AndroidFacet facet2) {
        PathString sampleDataDirectory = ProjectSystemUtil.getModuleSystem(facet2.getModule()).getSampleDataDirectory();
        return sampleDataDirectory != null ? sampleDataDirectory.toFile() : null;
    }

    @NotNull
    public static ResourceContent fromDirectory(@NotNull String relativePath) {
        File baseDir = ResourceContent.getSampleDataBaseDir();
        File sampleDataPath = baseDir != null ? new File(baseDir, relativePath) : null;
        File[] files2 = sampleDataPath != null && sampleDataPath.isDirectory() ? sampleDataPath.listFiles() : null;
        StringBuilder content2 = new StringBuilder();
        if (files2 != null) {
            for (File file2 : files2) {
                content2.append(file2.getAbsolutePath()).append('\n');
            }
        }
        return new ResourceContent(content2.toString().getBytes(Charsets.UTF_8));
    }

    @NotNull
    public static ResourceContent fromInputStream(@NotNull InputStream stream) {
        byte[] content2;
        try (ByteArrayOutputStream bytes = new ByteArrayOutputStream();){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = stream.read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }
            content2 = bytes.toByteArray();
        }
        catch (IOException e) {
            content2 = new byte[]{};
        }
        return new ResourceContent(content2);
    }

    @Override
    public Exception apply(OutputStream stream) {
        try {
            stream.write(this.myContent);
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }
}

