/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.ui;

import com.android.tools.idea.run.ui.BaseAction;
import com.android.tools.idea.run.util.SwapInfo;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import icons.StudioIcons;
import javax.swing.KeyStroke;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;

public class ApplyChangesAction
extends BaseAction {
    public static final String ID = "android.deploy.ApplyChanges";
    public static final String DISPLAY_NAME = "Apply Changes and Restart Activity";
    public static final String ACCELERATOR_NAME = "&Apply Changes and Restart Activity";
    private static final Shortcut SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(SystemInfo.isMac ? "control meta E" : "control F10"), null);
    private static final String DESC = "Attempt to apply resource and code changes and restart activity.";

    public ApplyChangesAction() {
        super(ID, DISPLAY_NAME, ACCELERATOR_NAME, SwapInfo.SwapType.APPLY_CHANGES, StudioIcons.Shell.Toolbar.APPLY_ALL_CHANGES, SHORTCUT, DESC);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RunnerAndConfigurationSettings runConfig = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (runConfig != null) {
            ConfigurationType type = runConfig.getType();
            String id = type.getId();
            if (AndroidBuildCommonUtils.isTestConfiguration((String)id) || AndroidBuildCommonUtils.isInstrumentationTestConfiguration((String)id)) {
                this.disableAction(e.getPresentation(), new BaseAction.DisableMessage(BaseAction.DisableMessage.DisableMode.DISABLED, "test project", "the selected configuration is a test configuration"));
                return;
            }
            ProcessHandler handler2 = ApplyChangesAction.findRunningProcessHandler(project, runConfig.getConfiguration());
            if (handler2 != null && ApplyChangesAction.getExecutor(handler2, DefaultRunExecutor.getRunExecutorInstance()) == DefaultDebugExecutor.getDebugExecutorInstance()) {
                this.disableAction(e.getPresentation(), new BaseAction.DisableMessage(BaseAction.DisableMessage.DisableMode.DISABLED, "debug execution", "it is currently not allowed during debugging"));
            }
        }
    }
}

