/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.profiler;

import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CpuProfilerConfigsState", storages={@Storage(value="cpuProfilingConfigs.xml")})
public class CpuProfilerConfigsState
implements PersistentStateComponent<CpuProfilerConfigsState> {
    @NotNull
    private List<CpuProfilerConfig> myUserConfigs = new ArrayList<CpuProfilerConfig>();

    @NotNull
    public static CpuProfilerConfigsState getInstance(Project project) {
        return (CpuProfilerConfigsState)ServiceManager.getService((Project)project, CpuProfilerConfigsState.class);
    }

    @NotNull
    public List<CpuProfilerConfig> getUserConfigs() {
        return this.myUserConfigs;
    }

    public void setUserConfigs(@NotNull List<CpuProfilerConfig> configs) {
        this.myUserConfigs = configs;
    }

    public boolean addUserConfig(@NotNull CpuProfilerConfig config) {
        if (this.getConfigByName(config.getName()) == null) {
            this.myUserConfigs.add(config);
            return true;
        }
        return false;
    }

    @NotNull
    public static List<CpuProfilerConfig> getDefaultConfigs() {
        ImmutableList.Builder configs = new ImmutableList.Builder().add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SAMPLED_JAVA)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.INSTRUMENTED_JAVA)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SAMPLED_NATIVE)).add((Object)new CpuProfilerConfig(CpuProfilerConfig.Technology.SYSTEM_TRACE));
        return configs.build();
    }

    @NotNull
    public List<CpuProfilerConfig> getConfigs() {
        return ImmutableList.builder().addAll(CpuProfilerConfigsState.getDefaultConfigs()).addAll(this.getUserConfigs()).build();
    }

    @Nullable
    public CpuProfilerConfig getConfigByName(@NotNull String name) {
        return this.getConfigs().stream().filter(c -> name.equals(c.getName())).findFirst().orElse(null);
    }

    @Nullable
    public CpuProfilerConfigsState getState() {
        return this;
    }

    public void loadState(CpuProfilerConfigsState state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }
}

