/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevice
extends Device {
    @VisibleForTesting
    static final Icon ourConnectedIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE);
    @Nullable
    private final VirtualDeviceName myNameKey;
    @Nullable
    private final Snapshot mySnapshot;

    @NotNull
    static VirtualDevice newConnectedDevice(@NotNull ConnectedDevice connectedDevice, @NotNull KeyToConnectionTimeMap map2, @Nullable VirtualDevice virtualDevice) {
        VirtualDeviceName nameKey;
        Device device;
        if (virtualDevice == null) {
            device = connectedDevice;
            nameKey = null;
        } else {
            device = virtualDevice;
            nameKey = virtualDevice.myNameKey;
        }
        Key key = device.getKey();
        return new Builder().setName(device.getName()).setValid(connectedDevice.isValid()).setValidityReason(connectedDevice.getValidityReason()).setKey(key).setConnectionTime(map2.get(key)).setAndroidDevice(connectedDevice.getAndroidDevice()).setNameKey(nameKey).setSnapshot(device.getSnapshot()).build();
    }

    private VirtualDevice(@NotNull Builder builder2) {
        super(builder2);
        this.myNameKey = builder2.myNameKey;
        this.mySnapshot = builder2.mySnapshot;
    }

    @Override
    @NotNull
    Icon getIcon() {
        return this.isConnected() ? ourConnectedIcon : StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE;
    }

    @Override
    boolean isConnected() {
        return this.getConnectionTime() != null;
    }

    @Override
    @Nullable
    Snapshot getSnapshot() {
        return this.mySnapshot;
    }

    @Override
    boolean matches(@NotNull Key key) {
        if (this.myNameKey == null) {
            return this.getKey().matches(key);
        }
        return this.getKey().matches(key) || this.myNameKey.matches(key);
    }

    @Override
    boolean hasKeyContainedBy(@NotNull @NotNull Collection<@NotNull Key> keys) {
        if (this.myNameKey == null) {
            return keys.contains(this.getKey()) || keys.contains(this.getKey().asNonprefixedKey());
        }
        return keys.contains(this.getKey()) || keys.contains(this.myNameKey) || keys.contains(this.myNameKey.asNonprefixedKey());
    }

    @Override
    @NotNull
    Future<AndroidVersion> getAndroidVersion() {
        AndroidDevice androidDevice = this.getAndroidDevice();
        if (androidDevice instanceof LaunchableAndroidDevice) {
            return Futures.immediateFuture((Object)((LaunchableAndroidDevice)androidDevice).getAvdInfo().getAndroidVersion());
        }
        IDevice ddmlibDevice = this.getDdmlibDevice();
        assert (ddmlibDevice != null);
        return DeploymentApplicationService.getInstance().getVersion(ddmlibDevice);
    }

    @Override
    void addTo(@NotNull DeviceFutures futures2, @NotNull Project project) {
        AndroidDevice device = this.getAndroidDevice();
        if (!this.isConnected()) {
            device.launch(project, this.getEmulatorCommandArguments());
        }
        futures2.getDevices().add(device);
    }

    @NotNull
    private List<String> getEmulatorCommandArguments() {
        if (this.mySnapshot == null) {
            return Collections.emptyList();
        }
        return Arrays.asList("-snapshot", this.mySnapshot.getDirectory().toString(), "-id", this.getKey().toString());
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof VirtualDevice)) {
            return false;
        }
        VirtualDevice device = (VirtualDevice)object;
        return this.getName().equals(device.getName()) && this.isValid() == device.isValid() && Objects.equals(this.getValidityReason(), device.getValidityReason()) && this.getKey().equals(device.getKey()) && Objects.equals(this.getConnectionTime(), device.getConnectionTime()) && this.getAndroidDevice().equals(device.getAndroidDevice()) && Objects.equals(this.myNameKey, device.myNameKey) && Objects.equals(this.mySnapshot, device.mySnapshot);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.isValid(), this.getValidityReason(), this.getKey(), this.getConnectionTime(), this.getAndroidDevice(), this.myNameKey, this.mySnapshot);
    }

    static final class Builder
    extends Device.Builder {
        @Nullable
        private VirtualDeviceName myNameKey;
        @Nullable
        private Snapshot mySnapshot;

        Builder() {
        }

        @NotNull
        Builder setName(@NotNull String name) {
            this.myName = name;
            return this;
        }

        @NotNull
        Builder setValid(boolean valid2) {
            this.myValid = valid2;
            return this;
        }

        @NotNull
        Builder setValidityReason(@Nullable String validityReason) {
            this.myValidityReason = validityReason;
            return this;
        }

        @NotNull
        Builder setKey(@NotNull Key key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        @VisibleForTesting
        Builder setConnectionTime(@NotNull Instant connectionTime) {
            this.myConnectionTime = connectionTime;
            return this;
        }

        @NotNull
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            this.myAndroidDevice = androidDevice;
            return this;
        }

        @NotNull
        Builder setNameKey(@Nullable VirtualDeviceName nameKey) {
            this.myNameKey = nameKey;
            return this;
        }

        @NotNull
        Builder setSnapshot(@Nullable Snapshot snapshot) {
            this.mySnapshot = snapshot;
            return this;
        }

        @Override
        @NotNull
        VirtualDevice build() {
            return new VirtualDevice(this);
        }
    }
}

