/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceComparator;
import com.android.tools.idea.run.deployment.PhysicalDevice;
import com.android.tools.idea.run.deployment.Snapshot;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

final class SelectMultipleDevicesDialogTableModel
extends AbstractTableModel {
    static final int SELECTED_MODEL_COLUMN_INDEX = 0;
    static final int TYPE_MODEL_COLUMN_INDEX = 1;
    private static final int DEVICE_MODEL_COLUMN_INDEX = 2;
    private static final int SERIAL_NUMBER_MODEL_COLUMN_INDEX = 3;
    private static final int SNAPSHOT_MODEL_COLUMN_INDEX = 4;
    @NotNull
    private final List<Boolean> mySelected;
    @NotNull
    private final List<Device> myDevices;
    @NotNull
    private final Multiset<String> myDeviceNameMultiset;

    SelectMultipleDevicesDialogTableModel(@NotNull List<Device> devices2) {
        int size = devices2.size();
        this.mySelected = new ArrayList<Boolean>(Collections.nCopies(size, false));
        this.myDevices = devices2;
        this.myDevices.sort(new DeviceComparator());
        this.myDeviceNameMultiset = (Multiset)devices2.stream().map(Device::getName).collect(Collectors.toCollection(() -> HashMultiset.create((int)size)));
    }

    @NotNull
    Device getDeviceAt(int modelRowIndex) {
        return this.myDevices.get(modelRowIndex);
    }

    @Override
    public int getRowCount() {
        return this.myDevices.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Device";
            }
            case 3: {
                return "Serial Number";
            }
            case 4: {
                return "Snapshot";
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Icon.class;
            }
            case 2: 
            case 3: 
            case 4: {
                return Object.class;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    public boolean isCellEditable(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Object getValueAt(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return this.mySelected.get(modelRowIndex);
            }
            case 1: {
                return this.myDevices.get(modelRowIndex).getIcon();
            }
            case 2: {
                Device device = this.myDevices.get(modelRowIndex);
                String reason = device.getValidityReason();
                return reason == null ? device.getName() : "<html>" + device.getName() + "<br>" + reason;
            }
            case 3: {
                return this.getSerialNumber(this.myDevices.get(modelRowIndex));
            }
            case 4: {
                Snapshot snapshot = this.myDevices.get(modelRowIndex).getSnapshot();
                return snapshot == null ? "" : ((Object)snapshot).toString();
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @NotNull
    private Object getSerialNumber(@NotNull Device device) {
        if (!(device instanceof PhysicalDevice)) {
            return "";
        }
        if (this.myDeviceNameMultiset.count((Object)device.getName()) != 1) {
            return device.getKey().getDeviceKey();
        }
        return "";
    }

    @Override
    public void setValueAt(@NotNull Object value2, int modelRowIndex, int modelColumnIndex) {
        this.mySelected.set(modelRowIndex, (Boolean)value2);
        this.fireTableCellUpdated(modelRowIndex, modelColumnIndex);
    }
}

