/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxExecutionTarget;
import com.android.tools.idea.run.deployment.DeviceComparator;
import com.android.tools.idea.run.deployment.DevicesSelectedService;
import com.android.tools.idea.run.deployment.ExecutionTargetService;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Popup;
import com.android.tools.idea.run.deployment.PopupActionGroup;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialog;
import com.android.tools.idea.run.deployment.Updater;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.RunManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceAndSnapshotComboBoxAction
extends ComboBoxAction {
    public static final com.intellij.openapi.util.Key<Boolean> DEPLOYS_TO_LOCAL_DEVICE = com.intellij.openapi.util.Key.create((String)"DeviceAndSnapshotComboBoxAction.deploysToLocalDevice");
    @NotNull
    private final Supplier<Boolean> mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    @NotNull
    private final Function<Project, AsyncDevicesGetter> myDevicesGetterGetter;
    @NotNull
    private final Function<Project, DevicesSelectedService> myDevicesSelectedServiceGetInstance;
    @NotNull
    private final Function<Project, ExecutionTargetService> myExecutionTargetServiceGetInstance;
    @NotNull
    private final BiFunction<Project, List<Device>, DialogWrapper> myNewSelectMultipleDevicesDialog;
    @NotNull
    private final Function<Project, RunManager> myGetRunManager;

    private DeviceAndSnapshotComboBoxAction() {
        this(new Builder().setSelectDeviceSnapshotComboBoxSnapshotsEnabled(StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED::get).setDevicesGetterGetter(AsyncDevicesGetter::getInstance).setDevicesSelectedServiceGetInstance(DevicesSelectedService::getInstance).setExecutionTargetServiceGetInstance(ExecutionTargetService::getInstance).setNewSelectMultipleDevicesDialog(SelectMultipleDevicesDialog::new).setGetRunManager(RunManager::getInstance));
    }

    @NonInjectable
    private DeviceAndSnapshotComboBoxAction(@NotNull Builder builder2) {
        assert (builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabled != null);
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
        assert (builder2.myDevicesGetterGetter != null);
        this.myDevicesGetterGetter = builder2.myDevicesGetterGetter;
        assert (builder2.myDevicesSelectedServiceGetInstance != null);
        this.myDevicesSelectedServiceGetInstance = builder2.myDevicesSelectedServiceGetInstance;
        assert (builder2.myExecutionTargetServiceGetInstance != null);
        this.myExecutionTargetServiceGetInstance = builder2.myExecutionTargetServiceGetInstance;
        assert (builder2.myNewSelectMultipleDevicesDialog != null);
        this.myNewSelectMultipleDevicesDialog = builder2.myNewSelectMultipleDevicesDialog;
        assert (builder2.myGetRunManager != null);
        this.myGetRunManager = builder2.myGetRunManager;
    }

    @NotNull
    static DeviceAndSnapshotComboBoxAction getInstance() {
        return (DeviceAndSnapshotComboBoxAction)ActionManager.getInstance().getAction("DeviceAndSnapshotComboBox");
    }

    boolean areSnapshotsEnabled() {
        return this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled.get();
    }

    @NotNull
    Optional<List<Device>> getDevices(@NotNull Project project) {
        Optional<List<Device>> optionalDevices = this.myDevicesGetterGetter.apply(project).get();
        if (optionalDevices.isPresent()) {
            List<Device> devices2 = optionalDevices.get();
            devices2.sort(new DeviceComparator());
            return Optional.of(devices2);
        }
        return optionalDevices;
    }

    public boolean isMultipleTargetsSelectedInComboBox(@NotNull Project project) {
        return this.myDevicesSelectedServiceGetInstance.apply(project).isMultipleDevicesSelectedInComboBox();
    }

    @Nullable
    @VisibleForTesting
    Device getSelectedDevice(@NotNull Project project) {
        List<Device> devices2 = this.getDevices(project).orElse(Collections.emptyList());
        return this.myDevicesSelectedServiceGetInstance.apply(project).getDeviceSelectedWithComboBox(devices2);
    }

    void setSelectedDevice(@NotNull Project project, @NotNull Device selectedDevice) {
        this.myDevicesSelectedServiceGetInstance.apply(project).setDeviceSelectedWithComboBox(selectedDevice);
        this.setActiveTarget(project, Collections.singleton(selectedDevice.getKey()));
    }

    @NotNull
    List<Device> getSelectedDevices(@NotNull Project project) {
        List<Device> devices2 = this.getDevices(project).orElse(Collections.emptyList());
        Set<Key> keys = this.getSelectedDeviceKeys(project, devices2);
        return ContainerUtil.filter(devices2, device -> device.hasKeyContainedBy(keys));
    }

    @NotNull
    @NotNull Set<@NotNull Key> getSelectedDeviceKeys(@NotNull Project project) {
        return this.getSelectedDeviceKeys(project, this.getDevices(project).orElse(Collections.emptyList()));
    }

    @NotNull
    private @NotNull Set<@NotNull Key> getSelectedDeviceKeys(@NotNull Project project, @NotNull @NotNull List<@NotNull Device> devices2) {
        DevicesSelectedService service = this.myDevicesSelectedServiceGetInstance.apply(project);
        if (service.isMultipleDevicesSelectedInComboBox()) {
            return service.getDeviceKeysSelectedWithDialog();
        }
        Device device = service.getDeviceSelectedWithComboBox(devices2);
        if (device == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(device.getKey());
    }

    void selectMultipleDevices(@NotNull Project project) {
        DevicesSelectedService service;
        List<Device> devices2 = this.myDevicesGetterGetter.apply(project).get().orElseThrow(AssertionError::new);
        if (!this.myNewSelectMultipleDevicesDialog.apply(project, devices2).showAndGet()) {
            return;
        }
        service.setMultipleDevicesSelectedInComboBox(!(service = this.myDevicesSelectedServiceGetInstance.apply(project)).isDialogSelectionEmpty());
        this.setActiveTarget(project, this.getSelectedDeviceKeys(project));
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        return this.createCustomComponent(presentation, JBUI::scale);
    }

    @NotNull
    @VisibleForTesting
    JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull IntUnaryOperator scale) {
        JPanel panel2 = new JPanel(null);
        GroupLayout layout2 = new GroupLayout(panel2);
        ComboBoxAction.ComboBoxButton button2 = this.createComboBoxButton(presentation);
        GroupLayout.SequentialGroup horizontalGroup = layout2.createSequentialGroup().addComponent((Component)button2, 0, -1, scale.applyAsInt(250)).addGap(scale.applyAsInt(3));
        GroupLayout.ParallelGroup verticalGroup = layout2.createParallelGroup().addComponent((Component)button2);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout2);
        return panel2;
    }

    @NotNull
    protected ComboBoxAction.ComboBoxButton createComboBoxButton(@NotNull Presentation presentation) {
        ComboBoxAction.ComboBoxButton button2 = new ComboBoxAction.ComboBoxButton(presentation){

            protected JBPopup createPopup(@NotNull Runnable runnable2) {
                DataContext context = this.getDataContext();
                return new Popup((ActionGroup)DeviceAndSnapshotComboBoxAction.this.createPopupActionGroup((JComponent)((Object)this), context), context, runnable2);
            }
        };
        button2.setName("deviceAndSnapshotComboBoxButton");
        return button2;
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext context) {
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        return new PopupActionGroup((Collection<Device>)this.getDevices(project).orElseThrow(AssertionError::new), this);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = event.getProject();
        if (project == null) {
            presentation.setVisible(false);
            return;
        }
        Optional<List<Device>> optionalDevices = this.getDevices(project);
        if (!optionalDevices.isPresent()) {
            presentation.setEnabled(false);
            presentation.setText("Loading Devices...");
            return;
        }
        List<Device> devices2 = optionalDevices.get();
        Updater updater = new Updater.Builder().setProject(project).setPresentation(presentation).setPlace(event.getPlace()).setDevicesSelectedService(this.myDevicesSelectedServiceGetInstance.apply(project)).setDevices(devices2).setConfigurationAndSettings(this.myGetRunManager.apply(project).getSelectedConfiguration()).setSnapshotsEnabled(this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled.get()).build();
        updater.update();
        this.setActiveTarget(project, this.getSelectedDeviceKeys(project, devices2));
    }

    private void setActiveTarget(@NotNull Project project, @NotNull @NotNull Set<@NotNull Key> keys) {
        AsyncDevicesGetter getter = this.myDevicesGetterGetter.apply(project);
        this.myExecutionTargetServiceGetInstance.apply(project).setActiveTarget(new DeviceAndSnapshotComboBoxExecutionTarget(keys, getter));
    }

    @VisibleForTesting
    static final class Builder {
        @Nullable
        private Supplier<Boolean> mySelectDeviceSnapshotComboBoxSnapshotsEnabled = () -> false;
        @Nullable
        private Function<Project, AsyncDevicesGetter> myDevicesGetterGetter = project -> null;
        @Nullable
        private Function<Project, DevicesSelectedService> myDevicesSelectedServiceGetInstance = project -> null;
        @Nullable
        private Function<Project, ExecutionTargetService> myExecutionTargetServiceGetInstance = project -> null;
        @Nullable
        private BiFunction<Project, List<Device>, DialogWrapper> myNewSelectMultipleDevicesDialog = (project, devices2) -> null;
        @Nullable
        private Function<Project, RunManager> myGetRunManager = project -> null;

        Builder() {
        }

        @NotNull
        Builder setSelectDeviceSnapshotComboBoxSnapshotsEnabled(@NotNull Supplier<Boolean> selectDeviceSnapshotComboBoxSnapshotsEnabled) {
            this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
            return this;
        }

        @NotNull
        Builder setDevicesGetterGetter(@NotNull Function<Project, AsyncDevicesGetter> devicesGetterGetter) {
            this.myDevicesGetterGetter = devicesGetterGetter;
            return this;
        }

        @NotNull
        Builder setDevicesSelectedServiceGetInstance(@NotNull Function<Project, DevicesSelectedService> devicesSelectedServiceGetInstance) {
            this.myDevicesSelectedServiceGetInstance = devicesSelectedServiceGetInstance;
            return this;
        }

        @NotNull
        Builder setExecutionTargetServiceGetInstance(@NotNull Function<Project, ExecutionTargetService> executionTargetServiceGetInstance) {
            this.myExecutionTargetServiceGetInstance = executionTargetServiceGetInstance;
            return this;
        }

        @NotNull
        Builder setNewSelectMultipleDevicesDialog(@NotNull BiFunction<Project, List<Device>, DialogWrapper> newSelectMultipleDevicesDialog) {
            this.myNewSelectMultipleDevicesDialog = newSelectMultipleDevicesDialog;
            return this;
        }

        @NotNull
        Builder setGetRunManager(@NotNull Function<Project, RunManager> getRunManager) {
            this.myGetRunManager = getRunManager;
            return this;
        }

        @NotNull
        DeviceAndSnapshotComboBoxAction build() {
            return new DeviceAndSnapshotComboBoxAction(this);
        }
    }
}

