/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.ErrorMatchingReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallResult {
    @NotNull
    public final FailureCode failureCode;
    @Nullable
    public final String failureMessage;
    @Nullable
    public final String installOutput;

    public InstallResult(@NotNull FailureCode failureCode, @Nullable String failureMessage, @Nullable String installOutput) {
        this.failureCode = failureCode;
        this.failureMessage = failureMessage;
        this.installOutput = installOutput;
    }

    public static InstallResult forLaunchOutput(@NotNull ErrorMatchingReceiver receiver) {
        return new InstallResult(InstallResult.getFailureCode(receiver), receiver.getFailureMessage(), receiver.getOutput().toString());
    }

    private static FailureCode getFailureCode(ErrorMatchingReceiver receiver) {
        String failureMessage = receiver.getFailureMessage();
        if (receiver.getErrorType() == -2 && failureMessage == null) {
            return FailureCode.NO_ERROR;
        }
        if (failureMessage != null) {
            for (FailureCode code : FailureCode.values()) {
                if (!failureMessage.equals(code.toString())) continue;
                return code;
            }
        }
        return FailureCode.UNTYPED_ERROR;
    }

    public static enum FailureCode {
        NO_ERROR,
        DEVICE_NOT_RESPONDING,
        INCONSISTENT_CERTIFICATES,
        INSTALL_FAILED_VERSION_DOWNGRADE,
        INSTALL_FAILED_UPDATE_INCOMPATIBLE,
        INSTALL_FAILED_DEXOPT,
        NO_CERTIFICATE,
        INSTALL_FAILED_OLDER_SDK,
        UNTYPED_ERROR,
        DEVICE_NOT_FOUND;

    }
}

