/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.ide.common.gradle.model.IdeTestedTargetVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleApplicationIdProvider
implements ApplicationIdProvider {
    private static final String DEFAULT_TEST_PACKAGE_SUFFIX = ".test";
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final PostBuildModelProvider myOutputModelProvider;

    public GradleApplicationIdProvider(@NotNull AndroidFacet facet2) {
        this(facet2, () -> null);
    }

    public GradleApplicationIdProvider(@NotNull AndroidFacet facet2, @NotNull PostBuildModelProvider outputModelProvider) {
        this.myFacet = facet2;
        this.myOutputModelProvider = outputModelProvider;
    }

    @Override
    @NotNull
    public String getPackageName() throws ApkProvisionException {
        String applicationId2;
        if (((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 1) {
            String testPackageName = this.getTestPackageName();
            if (testPackageName != null) {
                return testPackageName;
            }
            GradleApplicationIdProvider.getLogger().warn("Could not get applicationId for library module.");
        }
        if (((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 2) {
            AndroidFacet targetFacet = this.getTargetFacet();
            if (targetFacet != null) {
                GradleApplicationIdProvider targetApplicationProvider = new GradleApplicationIdProvider(targetFacet, this.myOutputModelProvider);
                return targetApplicationProvider.getPackageName();
            }
            GradleApplicationIdProvider.getLogger().warn("Could not get applicationId for tested module.");
        }
        if (((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 4) {
            applicationId2 = this.tryToGetInstantAppApplicationId();
            if (applicationId2 != null) {
                return applicationId2;
            }
            GradleApplicationIdProvider.getLogger().warn("Could not get instant app applicationId from post build model.");
        }
        if (((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 6 && (applicationId2 = this.tryToGetDynamicFeatureApplicationId()) != null) {
            return applicationId2;
        }
        return ApkProviderUtil.computePackageName(this.myFacet);
    }

    @Nullable
    private String tryToGetDynamicFeatureApplicationId() throws ApkProvisionException {
        Module baseAppModule = DynamicAppUtils.getBaseFeature(this.myFacet.getModule());
        if (baseAppModule == null) {
            GradleApplicationIdProvider.getLogger().warn("[Instrumented test for Dynamic Features] Can't get base-app module");
            return null;
        }
        AndroidFacet baseAppFacet = AndroidFacet.getInstance((Module)baseAppModule);
        if (baseAppFacet == null) {
            GradleApplicationIdProvider.getLogger().warn("[Instrumented test for Dynamic Features] Can't get base-app Android Facet");
            return null;
        }
        return ApkProviderUtil.computePackageName(baseAppFacet);
    }

    @Nullable
    private String tryToGetInstantAppApplicationId() {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel == null || !androidModel.getFeatures().isPostBuildSyncSupported() || androidModel.getAndroidProject().getProjectType() != 4) {
            return null;
        }
        PostBuildModel postBuildModel = this.myOutputModelProvider.getPostBuildModel();
        if (postBuildModel == null) {
            return null;
        }
        InstantAppProjectBuildOutput projectBuildOutput = postBuildModel.findInstantAppProjectBuildOutput(this.myFacet);
        if (projectBuildOutput == null) {
            return null;
        }
        for (InstantAppVariantBuildOutput variantBuildOutput : projectBuildOutput.getInstantAppVariantsBuildOutput()) {
            if (!variantBuildOutput.getName().equals(androidModel.getSelectedVariant().getName())) continue;
            return variantBuildOutput.getApplicationId();
        }
        return null;
    }

    @Override
    public String getTestPackageName() throws ApkProvisionException {
        String testPackageName;
        if (((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 2) {
            return ApkProviderUtil.computePackageName(this.myFacet);
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        String string = testPackageName = androidModel == null ? null : androidModel.getSelectedVariant().getMergedFlavor().getTestApplicationId();
        if (testPackageName != null) {
            return testPackageName;
        }
        if (((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 6 || ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 1) {
            return ApkProviderUtil.computePackageName(this.myFacet) + DEFAULT_TEST_PACKAGE_SUFFIX;
        }
        return this.getPackageName() + DEFAULT_TEST_PACKAGE_SUFFIX;
    }

    @Nullable
    private AndroidFacet getTargetFacet() {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel == null) {
            return null;
        }
        List targetVariants = androidModel.getSelectedVariant().getTestedTargetVariants();
        if (targetVariants.size() != 1) {
            return null;
        }
        IdeTestedTargetVariant targetVariant = (IdeTestedTargetVariant)targetVariants.iterator().next();
        Module targetModule = GradleUtil.findModuleByGradlePath(this.myFacet.getModule().getProject(), targetVariant.getTargetProjectPath());
        if (targetModule == null) {
            return null;
        }
        return AndroidFacet.getInstance((Module)targetModule);
    }

    private static Logger getLogger() {
        return Logger.getInstance(GradleApplicationIdProvider.class);
    }
}

