/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidLaunchTasksProvider;
import com.android.tools.idea.run.AndroidRunState;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.LaunchOptionsProvider;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.ValidationUtil;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.stats.RunStatsService;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.tools.idea.testartifacts.instrumented.configuration.AndroidTestConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.SourceProviderManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>
implements PreferGradleMake,
RunConfigurationWithSuppressedDefaultRunAction,
RunConfigurationWithSuppressedDefaultDebugAction {
    private static final String GRADLE_SYNC_FAILED_ERR_MSG = "Gradle project sync failed. Please fix your project and try again.";
    private static final String PROFILERS_ELEMENT_NAME = "Profilers";
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = false;
    public boolean SKIP_NOOP_APK_INSTALLATIONS = true;
    public boolean FORCE_STOP_RUNNING_APP = true;
    private final ProfilerState myProfilerState;
    private final boolean myAndroidTests;
    private final DeployTargetContext myDeployTargetContext = new DeployTargetContext();
    private final AndroidDebuggerContext myAndroidDebuggerContext = new AndroidDebuggerContext("Java");

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory2, boolean androidTests) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory2);
        this.myProfilerState = new ProfilerState();
        this.myAndroidTests = androidTests;
        if (((Boolean)StudioFlags.MULTIDEVICE_INSTRUMENTATION_TESTS.get()).booleanValue()) {
            this.getOptions().setAllowRunningInParallel(true);
        } else {
            this.getOptions().setAllowRunningInParallel(!androidTests);
        }
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors2 = this.validate(null);
        if (errors2.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors2);
        switch (topError.getSeverity()) {
            case FATAL: {
                throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
            }
            case WARNING: {
                throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
            }
        }
    }

    public List<ValidationError> validate(@Nullable Executor executor) {
        ApkProvider apkProvider;
        AndroidFacet facet2;
        ArrayList errors2 = Lists.newArrayList();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors2.add(ValidationError.fromException(e));
        }
        Module module2 = configurationModule.getModule();
        if (module2 == null) {
            return errors2;
        }
        Project project = module2.getProject();
        if (AndroidProjectInfo.getInstance(project).requiredAndroidModelMissing()) {
            errors2.add(ValidationError.fatal(GRADLE_SYNC_FAILED_ERR_MSG));
        }
        if ((facet2 = AndroidFacet.getInstance((Module)module2)) == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("no.facet.error", module2.getName())));
        }
        switch (((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType()) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                Pair<Boolean, String> result2 = this.supportsRunningLibraryProjects(facet2);
                if (((Boolean)result2.getFirst()).booleanValue()) break;
                errors2.add(ValidationError.fatal((String)result2.getSecond()));
                break;
            }
            default: {
                errors2.add(ValidationError.fatal(AndroidBundle.message("run.error.apk.not.valid", new Object[0])));
                return errors2;
            }
        }
        if (AndroidPlatform.getInstance(facet2.getModule()) == null) {
            errors2.add(ValidationError.fatal(AndroidBundle.message("select.platform.error", new Object[0])));
        }
        if (((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() != 4 && !this.isManifestValid(facet2)) {
            errors2.add(ValidationError.fatal(AndroidBundle.message("android.manifest.not.found.error", new Object[0])));
        }
        errors2.addAll(this.getDeployTargetContext().getCurrentDeployTargetState().validate(facet2));
        if (this.getApplicationIdProvider() == null) {
            errors2.add(ValidationError.fatal(AndroidBundle.message("android.run.configuration.not.supported.applicationid", this.getId())));
        }
        if ((apkProvider = this.getApkProvider()) != null) {
            errors2.addAll(apkProvider.validate());
        } else {
            errors2.add(ValidationError.fatal(AndroidBundle.message("android.run.configuration.not.supported", this.getId())));
        }
        errors2.addAll(this.checkConfiguration(facet2));
        Object androidDebuggerState = this.myAndroidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            errors2.addAll(((AndroidDebuggerState)androidDebuggerState).validate(facet2, executor));
        }
        errors2.addAll(this.myProfilerState.validate());
        return errors2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isManifestValid(@NotNull AndroidFacet facet2) {
        VirtualFile manifestFile = SourceProviderManager.getInstance(facet2).getMainManifestFile();
        if (manifestFile == null) {
            return false;
        }
        ProgressManager.checkCanceled();
        try (InputStream stream = manifestFile.getInputStream();){
            KXmlParser parser = new KXmlParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            parser.nextTag();
            boolean bl = "manifest".equals(parser.getName());
            return bl;
        }
        catch (IOException | XmlPullParserException e) {
            return false;
        }
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet var1);

    @NotNull
    protected abstract List<ValidationError> checkConfiguration(@NotNull AndroidFacet var1);

    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        return LaunchOptions.builder().setClearLogcatBeforeStart(this.CLEAR_LOGCAT).setSkipNoopApkInstallations(this.SKIP_NOOP_APK_INSTALLATIONS).setForceStopRunningApp(this.FORCE_STOP_RUNNING_APP);
    }

    public Collection<Module> getValidModules() {
        Module[] modules;
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (AndroidFacet.getInstance((Module)module2) == null) continue;
            result2.add(module2);
        }
        return result2;
    }

    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        return this.getDeployTargetContext().getApplicableDeployTargetProviders(this.myAndroidTests);
    }

    protected void validateBeforeRun(@NotNull Executor executor) throws ExecutionException {
        List<ValidationError> errors2 = this.validate(executor);
        ValidationUtil.promptAndQuickFixErrors(this.getProject(), errors2);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        RunStats stats = RunStatsService.get(this.getProject()).create();
        try {
            stats.start();
            RunProfileState state = this.doGetState(executor, env, stats);
            stats.markStateCreated();
            return state;
        }
        catch (Throwable t) {
            stats.abort();
            throw t;
        }
    }

    @Nullable
    public RunProfileState doGetState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull RunStats stats) throws ExecutionException {
        ApkProvider apkProvider;
        String error;
        this.validateBeforeRun(executor);
        Module module2 = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module2 != null) : "Enforced by fatal validation check in checkConfiguration.";
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        assert (facet2 != null) : "Enforced by fatal validation check in checkConfiguration.";
        stats.setDebuggable(LaunchUtils.canDebugApp(facet2));
        stats.setExecutor(executor.getId());
        this.updateExtraRunStats(stats);
        boolean isDebugging = executor instanceof DefaultDebugExecutor;
        DeployTargetContext context = this.getDeployTargetContext();
        stats.setUserSelectedTarget(context.getCurrentDeployTargetProvider().requiresRuntimePrompt(facet2.getModule().getProject()));
        DeployTarget deployTarget = this.getDeployTarget(facet2);
        if (deployTarget == null) {
            return null;
        }
        DeployTargetState deployTargetState = context.getCurrentDeployTargetState();
        if (deployTarget.hasCustomRunProfileState(executor)) {
            return deployTarget.getRunProfileState(executor, env, deployTargetState);
        }
        DeviceFutures deviceFutures = deployTarget.getDevices(facet2);
        if (deviceFutures == null) {
            return null;
        }
        if (deviceFutures.getDevices().size() > 1 && this instanceof AndroidTestRunConfiguration && !AndroidTestConfiguration.getInstance().getALWAYS_DISPLAY_RESULTS_IN_THE_TEST_MATRIX()) {
            boolean accepted;
            boolean bl = accepted = Messages.showOkCancelDialog((Project)this.getProject(), (String)"Running tests across multiple devices in parallel requires that you enable an experimental UI to display the results. This UI is also optimized and used for single-device test results. You can revert to the older UI at any time in Settings.", (String)"Running tests across multiple devices in parallel", (String)"Enable and run", (String)"Not now", null) == 0;
            if (!accepted) {
                return null;
            }
            AndroidTestConfiguration.getInstance().setALWAYS_DISPLAY_RESULTS_IN_THE_TEST_MATRIX(true);
        }
        stats.setLaunchedDevices(deviceFutures.getDevices().stream().anyMatch(device -> device instanceof LaunchableAndroidDevice));
        if (deviceFutures.get().isEmpty()) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        if (isDebugging && (error = AndroidRunConfigurationBase.canDebug(deviceFutures, facet2, module2.getName())) != null) {
            throw new ExecutionException(error);
        }
        env.putCopyableUserData(DeviceFutures.KEY, (Object)deviceFutures);
        env.putUserData(RunStats.KEY, (Object)stats);
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider();
        if (applicationIdProvider == null) {
            throw new RuntimeException("Cannot get ApplicationIdProvider");
        }
        LaunchOptions.Builder launchOptions = this.getLaunchOptions().setDebug(isDebugging);
        if (executor instanceof LaunchOptionsProvider) {
            launchOptions.addExtraOptions(((LaunchOptionsProvider)executor).getLaunchOptions());
        }
        if ((apkProvider = this.getApkProvider()) == null) {
            return null;
        }
        AndroidLaunchTasksProvider launchTasksProvider = new AndroidLaunchTasksProvider(this, env, facet2, applicationIdProvider, apkProvider, launchOptions.build());
        return new AndroidRunState(env, this.getName(), module2, applicationIdProvider, this.getConsoleProvider(deviceFutures.getDevices().size() > 1), deviceFutures, launchTasksProvider);
    }

    private static String canDebug(@NotNull DeviceFutures deviceFutures, @NotNull AndroidFacet facet2, @NotNull String moduleName2) {
        for (AndroidDevice androidDevice : deviceFutures.getDevices()) {
            String deviceName;
            if (androidDevice.isDebuggable() || LaunchUtils.canDebugApp(facet2)) continue;
            if (!androidDevice.getLaunchedDevice().isDone()) {
                deviceName = androidDevice.getName();
            } else {
                IDevice device = (IDevice)Futures.getUnchecked(androidDevice.getLaunchedDevice());
                deviceName = device.getName();
            }
            return AndroidBundle.message("android.cannot.debug.noDebugPermissions", moduleName2, deviceName);
        }
        return null;
    }

    @Nullable
    private DeployTarget getDeployTarget(@NotNull AndroidFacet facet2) {
        DeployTarget deployTarget;
        Project project;
        DeployTargetProvider currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider();
        if (currentTargetProvider.requiresRuntimePrompt(project = this.getProject())) {
            deployTarget = currentTargetProvider.showPrompt(facet2);
            if (deployTarget == null) {
                return null;
            }
        } else {
            deployTarget = currentTargetProvider.getDeployTarget(project);
        }
        return deployTarget;
    }

    @Nullable
    public ApplicationIdProvider getApplicationIdProvider() {
        return ProjectSystemUtil.getProjectSystem(this.getProject()).getApplicationIdProvider((RunConfiguration)this);
    }

    @Nullable
    protected ApkProvider getApkProvider() {
        return ProjectSystemUtil.getProjectSystem(this.getProject()).getApkProvider((RunConfiguration)this);
    }

    public abstract boolean isTestConfiguration();

    @NotNull
    protected abstract ConsoleProvider getConsoleProvider(boolean var1);

    @Nullable
    protected abstract AppLaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider var1, @NotNull AndroidFacet var2, @NotNull String var3, boolean var4, @NotNull LaunchStatus var5, @NotNull ApkProvider var6, @NotNull ConsolePrinter var7, @NotNull IDevice var8);

    public final DeviceCount getDeviceCount(boolean debug) {
        return DeviceCount.fromBoolean(this.supportMultipleDevices() && !debug);
    }

    protected abstract boolean supportMultipleDevices();

    public boolean canRunWithoutSync() {
        return false;
    }

    public void updateExtraRunStats(RunStats runStats) {
    }

    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        super.readExternal(element2);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element2);
        this.myDeployTargetContext.readExternal(element2);
        this.myAndroidDebuggerContext.readExternal(element2);
        Element profilersElement = element2.getChild(PROFILERS_ELEMENT_NAME);
        if (profilersElement != null) {
            this.myProfilerState.readExternal(profilersElement);
        }
    }

    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        super.writeExternal(element2);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element2);
        this.myDeployTargetContext.writeExternal(element2);
        this.myAndroidDebuggerContext.writeExternal(element2);
        Element profilersElement = new Element(PROFILERS_ELEMENT_NAME);
        element2.addContent(profilersElement);
        this.myProfilerState.writeExternal(profilersElement);
    }

    public boolean isNativeLaunch() {
        AndroidDebugger androidDebugger = this.myAndroidDebuggerContext.getAndroidDebugger();
        if (androidDebugger == null) {
            return false;
        }
        return !androidDebugger.getId().equals("Java");
    }

    @NotNull
    public DeployTargetContext getDeployTargetContext() {
        return this.myDeployTargetContext;
    }

    @NotNull
    public AndroidDebuggerContext getAndroidDebuggerContext() {
        return this.myAndroidDebuggerContext;
    }

    @NotNull
    public ProfilerState getProfilerState() {
        return this.myProfilerState;
    }

    public boolean isProfilable() {
        return true;
    }
}

