/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.json;

import com.android.tools.idea.room.migrations.json.BundleUtil;
import com.android.tools.idea.room.migrations.json.SchemaEquality;
import com.google.gson.annotations.SerializedName;
import java.util.List;

public class IndexBundle
implements SchemaEquality<IndexBundle> {
    public static final String DEFAULT_PREFIX = "index_";
    @SerializedName(value="name")
    private String mName;
    @SerializedName(value="unique")
    private boolean mUnique;
    @SerializedName(value="columnNames")
    private List<String> mColumnNames;
    @SerializedName(value="createSql")
    private String mCreateSql;

    public IndexBundle(String name, boolean unique, List<String> columnNames, String createSql) {
        this.mName = name;
        this.mUnique = unique;
        this.mColumnNames = columnNames;
        this.mCreateSql = createSql;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isUnique() {
        return this.mUnique;
    }

    public List<String> getColumnNames() {
        return this.mColumnNames;
    }

    public String create(String tableName) {
        return BundleUtil.replaceTableName(this.mCreateSql, tableName);
    }

    @Override
    public boolean isSchemaEqual(IndexBundle other) {
        if (this.mUnique != other.mUnique) {
            return false;
        }
        if (this.mName.startsWith(DEFAULT_PREFIX)) {
            if (!other.mName.startsWith(DEFAULT_PREFIX)) {
                return false;
            }
        } else {
            if (other.mName.startsWith(DEFAULT_PREFIX)) {
                return false;
            }
            if (!this.mName.equals(other.mName)) {
                return false;
            }
        }
        return !(this.mColumnNames != null ? !this.mColumnNames.equals(other.mColumnNames) : other.mColumnNames != null);
    }
}

