/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res.psi;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.sampledata.SampleDataManager;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResolvableResourceItem;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.res.psi.AndroidResourceToPsiResolver;
import com.android.tools.idea.resources.base.BasicResourceItem;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceManagerToPsiResolver
implements AndroidResourceToPsiResolver {
    @NotNull
    public static final ResourceManagerToPsiResolver INSTANCE = new ResourceManagerToPsiResolver();

    private ResourceManagerToPsiResolver() {
    }

    @Override
    @Nullable
    public PsiElement resolveToDeclaration(@NotNull ResourceItem resourceItem, @NotNull Project project) {
        VirtualFile source = IdeResourcesUtil.getSourceAsVirtualFile(resourceItem);
        if (source == null) {
            return null;
        }
        if (resourceItem.isFileBased()) {
            return PsiManager.getInstance((Project)project).findFile(source);
        }
        if (resourceItem.getType() == ResourceType.ID) {
            XmlAttribute xmlAttribute = IdeResourcesUtil.getIdDeclarationAttribute(project, resourceItem);
            return xmlAttribute == null ? null : xmlAttribute.getValueElement();
        }
        return new ValueResourceInfoImpl(resourceItem, source, project).computeXmlElement();
    }

    @Override
    @NotNull
    public ResolveResult[] resolveReference(@NotNull ResourceValue resourceValue2, @NotNull XmlElement context, @NotNull AndroidFacet facet2) {
        return this.resolveReference(resourceValue2, context, facet2, false);
    }

    @Override
    @NotNull
    public ResolveResult[] resolveReferenceWithDynamicFeatureModules(@NotNull ResourceValue resourceValue2, @NotNull XmlElement element2, @NotNull AndroidFacet facet2) {
        return this.resolveReference(resourceValue2, element2, facet2, true);
    }

    @NotNull
    private ResolveResult[] resolveReference(@NotNull ResourceValue resourceValue2, @NotNull XmlElement context, @NotNull AndroidFacet facet2, boolean includeDynamicFeatures) {
        AndroidModuleSystem androidModuleSystem2;
        ResourceManager manager;
        ResourceNamespace resolvedNamespace = IdeResourcesUtil.resolveResourceNamespace(context, resourceValue2.getPackage());
        if (resolvedNamespace == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        boolean attrReference = resourceValue2.getPrefix() == '?';
        ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
        if (resourceValue2.getType() != null && resourceValue2.getResourceName() != null && (manager = ModuleResourceManagers.getInstance(facet2).getResourceManager(resolvedNamespace.getPackageName(), (PsiElement)context)) != null) {
            manager.collectLazyResourceElements(resolvedNamespace, resourceValue2.getType().getName(), resourceValue2.getResourceName(), attrReference, (PsiElement)context, elements);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (elements.isEmpty() && resourceValue2.getResourceName() != null && resolvedNamespace != ResourceNamespace.ANDROID) {
            LocalResourceRepository resources = ResourceRepositoryManager.getAppResources(facet2.getModule());
            ResourceType resourceType = resourceValue2.getType();
            if (resourceType != null && (resourceType != ResourceType.ATTR || attrReference)) {
                XmlAttribute attribute;
                assert (resources != null);
                String resourceName = resourceValue2.getResourceName();
                if (resourceType == ResourceType.SAMPLE_DATA) {
                    resourceName = SampleDataManager.getResourceNameFromSampleReference((String)resourceName);
                }
                List<ResourceItem> items2 = resources.getResources(resolvedNamespace, resourceType, resourceName);
                if (FolderTypeRelationship.getRelatedFolders((ResourceType)resourceType).contains(ResourceFolderType.VALUES)) {
                    for (ResourceItem item : items2) {
                        if (item instanceof ResolvableResourceItem) {
                            result2.add(((ResolvableResourceItem)item).createResolveResult());
                            continue;
                        }
                        if (item instanceof BasicResourceItem && !((BasicResourceItem)item).isUserDefined()) {
                            result2.add(new AarResourceResolveResult((BasicResourceItem)item));
                            continue;
                        }
                        XmlTag tag = IdeResourcesUtil.getItemTag(facet2.getModule().getProject(), item);
                        if (tag == null) continue;
                        elements.add((PsiElement)tag);
                    }
                } else if (resourceType == ResourceType.SAMPLE_DATA && context.getParent() instanceof XmlAttribute && "http://schemas.android.com/tools".equals((attribute = (XmlAttribute)context.getParent()).getNamespace())) {
                    items2.stream().filter(SampleDataResourceItem.class::isInstance).forEach(sampleDataItem -> result2.add(((SampleDataResourceItem)sampleDataItem).createResolveResult()));
                }
            }
        }
        if (includeDynamicFeatures && (androidModuleSystem2 = ProjectSystemUtil.getModuleSystem((PsiElement)context)) != null) {
            List<Module> modules = androidModuleSystem2.getDynamicFeatureModules();
            for (Module module2 : modules) {
                LocalResourceRepository moduleResources = ResourceRepositoryManager.getModuleResources(module2);
                if (moduleResources == null) continue;
                List<ResourceItem> resources = moduleResources.getResources(resolvedNamespace, resourceValue2.getType(), resourceValue2.getResourceName());
                for (ResourceItem item : resources) {
                    PsiElement declaration = this.resolveToDeclaration(item, context.getProject());
                    if (declaration == null) continue;
                    result2.add(new PsiElementResolveResult(declaration));
                }
            }
        }
        if (elements.size() > 1) {
            elements.sort(IdeResourcesUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        for (PsiElement target : elements) {
            result2.add(new PsiElementResolveResult(target));
        }
        return result2.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public PsiElement[] getXmlAttributeNameGotoDeclarationTargets(@NotNull String attributeName, @NotNull ResourceNamespace namespace, @NotNull PsiElement context) {
        LocalResourceRepository repository;
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)context);
        if (facet2 == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet2);
        LocalResourceRepository localResourceRepository = repository = namespace.equals((Object)ResourceNamespace.ANDROID) ? repositoryManager.getFrameworkResources((Set<String>)ImmutableSet.of()) : repositoryManager.getAppResources();
        if (repository == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<LazyValueResourceElementWrapper> elementList = new ArrayList<LazyValueResourceElementWrapper>();
        for (ResourceItem resourceItem : repository.getResources(namespace, ResourceType.ATTR, attributeName)) {
            VirtualFile file2 = FileExtensions.toVirtualFile(resourceItem.getSource());
            if (file2 == null) continue;
            elementList.add(new LazyValueResourceElementWrapper(new ValueResourceInfoImpl(resourceItem, file2, facet2.getModule().getProject()), context));
        }
        return elementList.toArray(PsiElement.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public PsiFile[] getGotoDeclarationFileBasedTargets(@NotNull ResourceReference resourceReference, @NotNull PsiElement context) {
        PsiElement[] targets = this.getGotoDeclarationTargets(resourceReference, context);
        return (PsiFile[])Arrays.stream(targets).filter(element2 -> element2 instanceof PsiFile).map(PsiFile.class::cast).toArray(PsiFile[]::new);
    }

    @Override
    @NotNull
    public PsiElement[] getGotoDeclarationTargets(@NotNull ResourceReference resourceReference, @NotNull PsiElement context) {
        List<PsiElement> resourceList = ResourceManagerToPsiResolver.getGotoDeclarationElements(resourceReference, context);
        if (resourceList.size() > 1) {
            resourceList.sort(IdeResourcesUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        return resourceList.toArray(PsiElement.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public PsiElement[] getGotoDeclarationTargetsWithDynamicFeatureModules(@NotNull ResourceReference resourceReference, @NotNull PsiElement context) {
        List<PsiElement> resourceList = ResourceManagerToPsiResolver.getGotoDeclarationElements(resourceReference, context);
        List<PsiElement> dynamicFeatureGotoDeclarationElements = this.getDynamicFeatureGotoDeclarationElements(resourceReference, context);
        resourceList.addAll(dynamicFeatureGotoDeclarationElements);
        if (resourceList.size() > 1) {
            resourceList.sort(IdeResourcesUtil.RESOURCE_ELEMENT_COMPARATOR);
        }
        return resourceList.toArray(PsiElement.EMPTY_ARRAY);
    }

    @NotNull
    private static List<PsiElement> getGotoDeclarationElements(@NotNull ResourceReference resourceReference, @NotNull PsiElement context) {
        ResourceManager manager;
        ArrayList<PsiElement> resourceList = new ArrayList<PsiElement>();
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)context);
        if (facet2 == null) {
            return resourceList;
        }
        ResourceType resourceType = resourceReference.getResourceType();
        ResourceNamespace namespace = resourceReference.getNamespace();
        String resourceName = resourceReference.getName();
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance(facet2);
        ResourceManager resourceManager = manager = namespace == ResourceNamespace.ANDROID ? resourceManagers.getFrameworkResourceManager(false) : resourceManagers.getLocalResourceManager();
        if (manager == null) {
            return resourceList;
        }
        manager.collectLazyResourceElements(namespace, resourceType.getName(), resourceName, true, context, resourceList);
        if (manager instanceof LocalResourceManager) {
            LocalResourceManager localManager = (LocalResourceManager)manager;
            if (resourceType.equals((Object)ResourceType.STYLEABLE)) {
                for (DeclareStyleable declareStyleable : localManager.findStyleables(namespace, resourceName)) {
                    resourceList.add((PsiElement)declareStyleable.getName().getXmlAttributeValue());
                }
                for (Attr attr : localManager.findStyleableAttributesByFieldName(namespace, resourceName)) {
                    resourceList.add((PsiElement)attr.getName().getXmlAttributeValue());
                }
            }
        }
        return resourceList;
    }

    private List<PsiElement> getDynamicFeatureGotoDeclarationElements(ResourceReference reference2, PsiElement context) {
        ArrayList<PsiElement> resourceList = new ArrayList<PsiElement>();
        AndroidModuleSystem androidModuleSystem2 = ProjectSystemUtil.getModuleSystem(context);
        if (androidModuleSystem2 != null) {
            List<Module> modules = androidModuleSystem2.getDynamicFeatureModules();
            for (Module module2 : modules) {
                LocalResourceRepository moduleResources = ResourceRepositoryManager.getModuleResources(module2);
                if (moduleResources == null) continue;
                List<ResourceItem> resources = moduleResources.getResources(reference2.getNamespace(), reference2.getResourceType(), reference2.getName());
                for (ResourceItem item : resources) {
                    PsiElement declaration = this.resolveToDeclaration(item, context.getProject());
                    if (declaration == null) continue;
                    resourceList.add(declaration);
                }
            }
        }
        return resourceList;
    }

    private static class AarResourceResolveResult
    implements ResolveResult {
        @Nullable
        private final PsiElement myElement = null;

        AarResourceResolveResult(@NotNull BasicResourceItem resourceItem) {
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        public boolean isValidResult() {
            return false;
        }
    }
}

