/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.res.AndroidPluginVersion;
import com.android.tools.idea.resources.aar.CachingData;
import com.android.tools.idea.resources.aar.FrameworkResourceRepository;
import com.google.common.hash.Hashing;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager$CacheKey;", "Lcom/android/tools/idea/resources/aar/FrameworkResourceRepository;", "clearCache", "", "createCachingData", "Lcom/android/tools/idea/resources/aar/CachingData;", "resFolderOrJar", "Ljava/nio/file/Path;", "getFrameworkResources", "resourceDirectoryOrFile", "Ljava/io/File;", "useCompiled9Patches", "", "languages", "", "", "CacheKey", "Companion", "intellij.android.core"})
public final class FrameworkResourceRepositoryManager {
    private final ConcurrentHashMap<CacheKey, FrameworkResourceRepository> cache = new ConcurrentHashMap();
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final FrameworkResourceRepository getFrameworkResources(@NotNull File resourceDirectoryOrFile, boolean useCompiled9Patches, @NotNull Set<String> languages2) {
        Path path2 = resourceDirectoryOrFile.toPath();
        CacheKey cacheKey = new CacheKey(path2, useCompiled9Patches);
        CachingData cachingData = this.createCachingData(path2);
        FrameworkResourceRepository cached2 = this.cache.computeIfAbsent(cacheKey, new Function<CacheKey, FrameworkResourceRepository>(path2, languages2, cachingData, useCompiled9Patches){
            final /* synthetic */ Path $path;
            final /* synthetic */ Set $languages;
            final /* synthetic */ CachingData $cachingData;
            final /* synthetic */ boolean $useCompiled9Patches;

            @NotNull
            public final FrameworkResourceRepository apply(@NotNull CacheKey it) {
                return FrameworkResourceRepository.create(this.$path, this.$languages, this.$cachingData, this.$useCompiled9Patches);
            }
            {
                this.$path = path2;
                this.$languages = set;
                this.$cachingData = cachingData;
                this.$useCompiled9Patches = bl;
            }
        });
        if (languages2.isEmpty()) {
            return cached2;
        }
        FrameworkResourceRepository repository = cached2.loadMissingLanguages(languages2, cachingData);
        if (repository != cached2) {
            ((Map)this.cache).put(cacheKey, repository);
        }
        return repository;
    }

    private final CachingData createCachingData(Path resFolderOrJar) {
        String string;
        if (StringsKt.endsWith((String)((Object)resFolderOrJar.getFileName()).toString(), (String)".jar", (boolean)true)) {
            return null;
        }
        String string2 = AndroidPluginVersion.getAndroidPluginVersion();
        if (string2 == null) {
            return null;
        }
        String codeVersion = string2;
        try {
            string = Files.getLastModifiedTime(resFolderOrJar.resolve("../../package.xml"), new LinkOption[0]).toString();
        }
        catch (NoSuchFileException e) {
            string = "";
        }
        String contentVersion = string;
        String pathHash = Hashing.farmHashFingerprint64().hashUnencodedChars((CharSequence)((Object)resFolderOrJar).toString()).toString();
        Path path2 = resFolderOrJar.getParent();
        String string3 = String.valueOf(path2 != null && (path2 = path2.getParent()) != null ? path2.getFileName() : null);
        if (string3 == null) {
            string3 = "framework";
        }
        String prefix = string3;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string4 = "%s_%s.dat";
        Object[] objectArray = new Object[]{prefix, pathHash};
        boolean bl = false;
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        String filename = string5;
        Path cacheFile = Paths.get(PathManager.getSystemPath(), "caches/resources", filename);
        return new CachingData(cacheFile, contentVersion, codeVersion, AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor());
    }

    public final void clearCache() {
        this.cache.clear();
    }

    @JvmStatic
    @NotNull
    public static final FrameworkResourceRepositoryManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager$CacheKey;", "", "path", "Ljava/nio/file/Path;", "useCompiled9Patches", "", "(Ljava/nio/file/Path;Z)V", "getPath", "()Ljava/nio/file/Path;", "getUseCompiled9Patches", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    private static final class CacheKey {
        @NotNull
        private final Path path;
        private final boolean useCompiled9Patches;

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        public final boolean getUseCompiled9Patches() {
            return this.useCompiled9Patches;
        }

        public CacheKey(@NotNull Path path2, boolean useCompiled9Patches) {
            this.path = path2;
            this.useCompiled9Patches = useCompiled9Patches;
        }

        @NotNull
        public final Path component1() {
            return this.path;
        }

        public final boolean component2() {
            return this.useCompiled9Patches;
        }

        @NotNull
        public final CacheKey copy(@NotNull Path path2, boolean useCompiled9Patches) {
            return new CacheKey(path2, useCompiled9Patches);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, Path path2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = cacheKey.path;
            }
            if ((n & 2) != 0) {
                bl = cacheKey.useCompiled9Patches;
            }
            return cacheKey.copy(path2, bl);
        }

        @NotNull
        public String toString() {
            return "CacheKey(path=" + this.path + ", useCompiled9Patches=" + this.useCompiled9Patches + ")";
        }

        public int hashCode() {
            Path path2 = this.path;
            int n = (path2 != null ? ((Object)path2).hashCode() : 0) * 31;
            int n2 = this.useCompiled9Patches ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CacheKey)) break block3;
                    CacheKey cacheKey = (CacheKey)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)cacheKey.path) || this.useCompiled9Patches != cacheKey.useCompiled9Patches) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/res/FrameworkResourceRepositoryManager;", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final FrameworkResourceRepositoryManager getInstance() {
            Object object = ServiceManager.getService(FrameworkResourceRepositoryManager.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (FrameworkResourceRepositoryManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

