/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.google.common.collect.Lists;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeSnapshot {
    @Nullable
    public String namespace;
    @Nullable
    public String prefix;
    @NotNull
    public String name;
    @Nullable
    public String value;

    AttributeSnapshot(@Nullable String namespace, @Nullable String prefix, @NotNull String name, @Nullable String value2) {
        this.namespace = namespace;
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.name = name;
        this.value = value2;
    }

    @Nullable
    public static AttributeSnapshot createAttributeSnapshot(@NotNull XmlAttribute psiAttribute) {
        String localName = psiAttribute.getLocalName();
        String namespace = psiAttribute.getNamespace();
        String prefix = psiAttribute.getNamespacePrefix();
        String value2 = psiAttribute.getValue();
        if (value2 != null && DataBindingUtil.isBindingExpression(value2) && (value2 = DataBindingUtil.getBindingExprDefault(psiAttribute)) == null) {
            return null;
        }
        return new AttributeSnapshot(namespace, prefix, localName, value2);
    }

    @NotNull
    public static List<AttributeSnapshot> createAttributesForTag(@NotNull XmlTag tag) {
        XmlAttribute[] psiAttributes = tag.getAttributes();
        ArrayList attributes = Lists.newArrayListWithExpectedSize((int)psiAttributes.length);
        for (XmlAttribute psiAttribute : psiAttributes) {
            AttributeSnapshot attribute;
            if (psiAttribute.isNamespaceDeclaration() || (attribute = AttributeSnapshot.createAttributeSnapshot(psiAttribute)) == null) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    public String toString() {
        return "AttributeSnapshot{" + this.name + "=\"" + this.value + "\"}";
    }
}

