/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.RenderProblem;
import com.intellij.openapi.project.Project;
import java.lang.ref.WeakReference;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowExceptionFix
implements Runnable {
    @Nullable
    private final Project myProject;
    @NotNull
    private final WeakReference<RenderProblem> myRenderProblemWeakReference;
    @Nullable
    private final Throwable myThrowable;

    public ShowExceptionFix(@Nullable Project project, @NotNull Throwable throwable) {
        this.myProject = project;
        this.myThrowable = throwable;
        this.myRenderProblemWeakReference = new WeakReference<Object>(null);
    }

    public ShowExceptionFix(@Nullable Project project, @NotNull RenderProblem problem) {
        this.myProject = project;
        this.myThrowable = null;
        this.myRenderProblemWeakReference = new WeakReference<RenderProblem>(problem);
    }

    @Override
    public void run() {
        Throwable t = this.myThrowable;
        if (t == null) {
            RenderProblem problem = (RenderProblem)this.myRenderProblemWeakReference.get();
            Throwable throwable = t = problem != null ? problem.getThrowable() : null;
        }
        if (t == null) {
            return;
        }
        while (t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
        }
        AndroidUtils.showStackStace(this.myProject, new Throwable[]{t});
    }
}

