/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableCollection;
import com.intellij.openapi.module.Module;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.ModuleClassLoaderManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class RenderUtils {
    public static void clearCache(@NotNull ImmutableCollection<Configuration> configurations) {
        ModuleClassLoaderManager.get().clearCache();
        configurations.stream().forEach(configuration -> {
            IAndroidTarget target = configuration.getTarget();
            Module module2 = configuration.getModule();
            if (module2 != null) {
                AndroidTargetData targetData;
                ResourceIdManager.get(module2).resetDynamicIds();
                ResourceClassRegistry.get(module2.getProject()).clearCache();
                if (target != null && (targetData = AndroidTargetData.getTargetData(target, module2)) != null) {
                    targetData.clearAllCaches(module2);
                }
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                Stream.concat(AndroidUtils.getAllAndroidDependencies(module2, true).stream(), Stream.of(facet2)).filter(Objects::nonNull).forEach(f -> ResourceRepositoryManager.getInstance(f).resetAllCaches());
            }
        });
    }
}

