/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.intellij.openapi.application.ApplicationManager;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public interface RenderAsyncActionExecutor {
    public static final long DEFAULT_RENDER_THREAD_TIMEOUT_MS = Long.getLong("layoutlib.thread.timeout", TimeUnit.SECONDS.toMillis(10L));
    public static final long DEFAULT_RENDER_THREAD_QUEUE_TIMEOUT_MS = Long.getLong("layoutlib.thread.queue.timeout", TimeUnit.SECONDS.toMillis(ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode() ? 50L : 60L));

    @NotNull
    public <T> CompletableFuture<T> runAsyncActionWithTimeout(long var1, @NotNull TimeUnit var3, long var4, @NotNull TimeUnit var6, @NotNull Callable<T> var7);

    @NotNull
    default public <T> CompletableFuture<T> runAsyncActionWithTimeout(long actionTimeout, @NotNull TimeUnit actionTimeoutUnit, @NotNull Callable<T> callable) {
        return this.runAsyncActionWithTimeout(DEFAULT_RENDER_THREAD_QUEUE_TIMEOUT_MS, TimeUnit.MILLISECONDS, actionTimeout, actionTimeoutUnit, callable);
    }

    @NotNull
    default public <T> CompletableFuture<T> runAsyncAction(@NotNull Callable<T> callable) {
        return this.runAsyncActionWithTimeout(DEFAULT_RENDER_THREAD_QUEUE_TIMEOUT_MS, TimeUnit.MILLISECONDS, DEFAULT_RENDER_THREAD_TIMEOUT_MS, TimeUnit.MILLISECONDS, callable);
    }

    @NotNull
    default public CompletableFuture<Void> runAsyncAction(@NotNull Runnable runnable2) {
        return this.runAsyncAction(() -> {
            runnable2.run();
            return null;
        });
    }
}

