/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.tools.idea.rendering.FlagManager;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Locale {
    private static final LocaleQualifier ANY_QUALIFIER = new LocaleQualifier("__");
    public static final Locale ANY = new Locale(ANY_QUALIFIER);
    @NotNull
    public final LocaleQualifier qualifier;
    public static final Comparator<Locale> LANGUAGE_NAME_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String name2;
            String language1 = locale1.qualifier.getLanguage();
            String language2 = locale2.qualifier.getLanguage();
            if (!locale1.qualifier.hasLanguage()) {
                return !locale2.qualifier.hasLanguage() ? 0 : -1;
            }
            if (locale2.qualifier.hasFakeValue()) {
                return 1;
            }
            assert (language1 != null && language2 != null);
            String name1 = LocaleManager.getLanguageName((String)language1);
            int compare2 = StringUtil.compare((String)name1, (String)(name2 = LocaleManager.getLanguageName((String)language2)), (boolean)false);
            if (compare2 == 0) {
                return REGION_NAME_COMPARATOR.compare(locale1, locale2);
            }
            return compare2;
        }
    };
    public static final Comparator<Locale> LANGUAGE_CODE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String language1 = locale1.qualifier.getLanguage();
            String language2 = locale2.qualifier.getLanguage();
            if (locale1.qualifier.hasFakeValue()) {
                return locale2.qualifier.hasFakeValue() ? 0 : -1;
            }
            if (locale2.qualifier.hasFakeValue()) {
                return 1;
            }
            int compare2 = StringUtil.compare((String)language1, (String)language2, (boolean)false);
            if (compare2 == 0) {
                return REGION_CODE_COMPARATOR.compare(locale1, locale2);
            }
            return compare2;
        }
    };
    public static final Comparator<Locale> REGION_NAME_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String region1 = locale1.qualifier.getRegion();
            String region2 = locale2.qualifier.getRegion();
            if (region1 == null) {
                return region2 == null ? 0 : -1;
            }
            if (region2 == null) {
                return 1;
            }
            String regionName1 = LocaleManager.getRegionName((String)region1);
            String regionName2 = LocaleManager.getRegionName((String)region2);
            return StringUtil.compare((String)regionName1, (String)regionName2, (boolean)false);
        }
    };
    public static final Comparator<Locale> REGION_CODE_COMPARATOR = new Comparator<Locale>(){

        @Override
        public int compare(Locale locale1, Locale locale2) {
            String region1 = locale1.qualifier.getRegion();
            String region2 = locale2.qualifier.getRegion();
            if (region1 == null) {
                return region2 == null ? 0 : -1;
            }
            if (region2 == null) {
                return 1;
            }
            return StringUtil.compare((String)region1, (String)region2, (boolean)false);
        }
    };

    private Locale(@NotNull LocaleQualifier locale) {
        this.qualifier = locale;
    }

    @NotNull
    public static Locale create(@NotNull LocaleQualifier locale) {
        return new Locale(locale);
    }

    public static Locale create(FolderConfiguration folder) {
        LocaleQualifier locale = folder.getLocaleQualifier();
        if (locale == null) {
            return ANY;
        }
        return new Locale(locale);
    }

    @NotNull
    public static Locale create(@NotNull String localeString) {
        LocaleQualifier qualifier = LocaleQualifier.getQualifier((String)localeString);
        if (qualifier != null) {
            return new Locale(qualifier);
        }
        return ANY;
    }

    @NotNull
    public Icon getFlagImage() {
        String languageCode;
        String string = languageCode = this.qualifier.hasLanguage() ? this.qualifier.getLanguage() : null;
        if (languageCode == null) {
            return AndroidIcons.EmptyFlag;
        }
        String regionCode = this.hasRegion() ? this.qualifier.getRegion() : null;
        FlagManager icons = FlagManager.get();
        Icon image = icons.getFlag(languageCode, regionCode);
        if (image == null) {
            image = AndroidIcons.EmptyFlag;
        }
        return image;
    }

    public boolean hasLanguage() {
        return !this.qualifier.hasFakeValue() && this.qualifier.hasLanguage();
    }

    public boolean hasRegion() {
        return this.qualifier.getRegion() != null && !"__".equals(this.qualifier.getRegion());
    }

    public String toLocaleId() {
        return this.qualifier == ANY_QUALIFIER ? "" : this.qualifier.getTag();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + this.qualifier.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Locale other = (Locale)obj;
        return this.qualifier.equals((Object)other.qualifier);
    }

    public String toString() {
        return this.qualifier.getTag();
    }
}

