/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.refactoring.modularize;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.refactoring.modularize.AndroidModularizeHandler;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseJavaRefactoringAction;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModularizeAction
extends BaseJavaRefactoringAction {
    protected boolean isAvailableInEditorOnly() {
        return false;
    }

    protected boolean isAvailableForFile(PsiFile file2) {
        return file2 != null && file2.getFileType() == JavaFileType.INSTANCE && AndroidUtils.hasAndroidFacets(file2.getProject());
    }

    protected boolean isEnabledOnDataContext(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && !ProjectSystemUtil.getSyncManager(project).getLastSyncResult().isSuccessful()) {
            return false;
        }
        for (PsiElement element2 : AndroidModularizeAction.getPsiElementArray((DataContext)dataContext)) {
            if (this.isAvailableForFile(element2.getContainingFile())) continue;
            return false;
        }
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        return file2 == null || this.isAvailableForFile(file2);
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext context) {
        Project project = file2.getProject();
        return ProjectSystemUtil.getSyncManager(project).getLastSyncResult().isSuccessful();
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        return false;
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        return new AndroidModularizeHandler();
    }
}

