/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project.hyperlink;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public abstract class NotificationHyperlink {
    @NotNull
    private final String myUrl;
    @NotNull
    private final String myValue;
    private boolean myCloseOnClick;

    protected NotificationHyperlink(@NotNull String url, @NotNull String text2) {
        this.myUrl = url;
        this.myValue = String.format("<a href=\"%1$s\">%2$s</a>", StringUtil.escapeXml((String)url), text2);
    }

    protected abstract void execute(@NotNull Project var1);

    public boolean executeIfClicked(@NotNull Project project, @NotNull HyperlinkEvent event) {
        if (this.myUrl.equals(event.getDescription())) {
            this.execute(project);
            return true;
        }
        return false;
    }

    public boolean isCloseOnClick() {
        return this.myCloseOnClick;
    }

    @NotNull
    public NotificationHyperlink setCloseOnClick(boolean closeOnClick) {
        this.myCloseOnClick = closeOnClick;
        return this;
    }

    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    public String toString() {
        return this.toHtml();
    }

    @NotNull
    public String toHtml() {
        return this.myValue;
    }
}

