/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.view;

import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.view.nodes.CaptureNode;
import com.android.tools.idea.profiling.view.nodes.CaptureRootNode;
import com.android.tools.idea.profiling.view.nodes.CaptureTypeNode;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CapturesTreeStructure
extends SimpleTreeStructure {
    @NotNull
    private final Project myProject;
    @NotNull
    CaptureRootNode myRoot;
    @NotNull
    Map<Capture, CaptureNode> myCaptureNodes = Maps.newHashMap();
    @NotNull
    Map<CaptureType, CaptureTypeNode> myTypeNodes = Maps.newHashMap();

    public CapturesTreeStructure(@NotNull Project project) {
        this.myProject = project;
        this.myRoot = new CaptureRootNode();
    }

    public void update() {
        CaptureService service = CaptureService.getInstance(this.myProject);
        this.myRoot.clear();
        HashMap types2 = Maps.newHashMap();
        for (CaptureType type : service.getTypes()) {
            CaptureTypeNode typeNode = this.myTypeNodes.get(type);
            if (typeNode == null) {
                typeNode = new CaptureTypeNode(type);
            }
            types2.put(type, typeNode);
            this.myRoot.addType(typeNode);
        }
        this.myTypeNodes = types2;
        HashMap captures = Maps.newHashMap();
        for (Map.Entry entry : service.getCapturesByType().asMap().entrySet()) {
            CaptureTypeNode typeNode = this.myTypeNodes.get(entry.getKey());
            typeNode.clear();
            for (Capture capture2 : (Collection)entry.getValue()) {
                CaptureNode captureNode = this.myCaptureNodes.get(capture2);
                if (captureNode == null) {
                    captureNode = new CaptureNode(this.myProject, capture2);
                } else {
                    captureNode.update();
                }
                captures.put(capture2, captureNode);
                typeNode.addCapture(captureNode);
            }
        }
        this.myCaptureNodes = captures;
    }

    public CaptureNode getNode(Capture capture2) {
        return this.myCaptureNodes.get(capture2);
    }

    @NotNull
    public Object getRootElement() {
        return this.myRoot;
    }
}

