/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfd;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.LegacyAllocationTracker;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.ServiceProxy;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.intellij.openapi.diagnostic.Logger;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public class MemoryServiceProxy
extends ServiceProxy {
    @NotNull
    private Executor myFetchExecutor;
    @NotNull
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myServiceStub;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private BiFunction<IDevice, Integer, LegacyAllocationTracker> myTrackerSupplier;
    @NotNull
    private final Map<String, ByteString> myProxyBytesCache;
    private boolean myUseLegacyTracking;
    private final Object myUpdatingDataLock;
    private Long2ObjectMap<LegacyAllocationTracker> myLegacyTrackers;
    private Long2ObjectMap<Long2ObjectMap<Memory.AllocationsInfo>> myTrackingInfos;
    private Long2ObjectMap<Memory.AllocationsInfo> myInProgressTrackingInfo;
    private Long2ObjectMap<Long2ObjectMap<Memory.AllocatedClass>> myAllocatedClasses;
    private Long2ObjectMap<Long2ObjectMap<Memory.AllocationStack>> myAllocationStacks;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryServiceProxy.class);
    }

    public MemoryServiceProxy(@NotNull IDevice device, @NotNull ManagedChannel channel, @NotNull Executor fetchExecutor, @NotNull BiFunction<IDevice, Integer, LegacyAllocationTracker> legacyTrackerSupplier, Map<String, ByteString> proxyBytesCache) {
        super(MemoryServiceGrpc.getServiceDescriptor());
        this.myServiceStub = MemoryServiceGrpc.newBlockingStub((Channel)channel);
        this.myDevice = device;
        this.myFetchExecutor = fetchExecutor;
        this.myTrackerSupplier = legacyTrackerSupplier;
        this.myProxyBytesCache = proxyBytesCache;
        this.myUpdatingDataLock = new Object();
        if (!((Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get()).booleanValue() || this.myDevice.getVersion().getFeatureLevel() < 26) {
            this.myUseLegacyTracking = true;
            this.myLegacyTrackers = new Long2ObjectOpenHashMap();
            this.myTrackingInfos = new Long2ObjectOpenHashMap();
            this.myInProgressTrackingInfo = new Long2ObjectOpenHashMap();
            this.myAllocatedClasses = new Long2ObjectOpenHashMap();
            this.myAllocationStacks = new Long2ObjectOpenHashMap();
        }
    }

    public void startMonitoringApp(MemoryProfiler.MemoryStartRequest request, StreamObserver<MemoryProfiler.MemoryStartResponse> responseObserver2) {
        if (this.myUseLegacyTracking && !this.myLegacyTrackers.containsKey(request.getSession().getSessionId())) {
            this.myLegacyTrackers.put(request.getSession().getSessionId(), (Object)this.myTrackerSupplier.apply(this.myDevice, request.getSession().getPid()));
            this.myTrackingInfos.put(request.getSession().getSessionId(), (Object)new Long2ObjectOpenHashMap());
            this.myAllocatedClasses.put(request.getSession().getSessionId(), (Object)new Long2ObjectOpenHashMap());
            this.myAllocationStacks.put(request.getSession().getSessionId(), (Object)new Long2ObjectOpenHashMap());
        }
        responseObserver2.onNext((Object)this.myServiceStub.startMonitoringApp(request));
        responseObserver2.onCompleted();
    }

    public void stopMonitoringApp(MemoryProfiler.MemoryStopRequest request, StreamObserver<MemoryProfiler.MemoryStopResponse> responseObserver2) {
        if (this.myUseLegacyTracking) {
            this.myLegacyTrackers.remove(request.getSession().getSessionId());
            this.myTrackingInfos.remove(request.getSession().getSessionId());
            this.myInProgressTrackingInfo.remove(request.getSession().getSessionId());
            this.myAllocatedClasses.remove(request.getSession().getSessionId());
            this.myAllocationStacks.remove(request.getSession().getSessionId());
        }
        responseObserver2.onNext((Object)this.myServiceStub.stopMonitoringApp(request));
        responseObserver2.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData(MemoryProfiler.MemoryRequest request, StreamObserver<MemoryProfiler.MemoryData> responseObserver2) {
        try {
            MemoryProfiler.MemoryData data = this.myServiceStub.getData(request);
            if (this.myUseLegacyTracking) {
                Object object = this.myUpdatingDataLock;
                synchronized (object) {
                    Long2ObjectMap infos = (Long2ObjectMap)this.myTrackingInfos.get(request.getSession().getSessionId());
                    MemoryProfiler.MemoryData.Builder rebuilder = data.toBuilder();
                    long requestStartTime = request.getStartTime();
                    long requestEndTime = request.getEndTime();
                    ArrayList<Memory.AllocationsInfo> infosToReturn = new ArrayList<Memory.AllocationsInfo>();
                    for (Memory.AllocationsInfo info2 : infos.values()) {
                        if (info2.getStartTime() > requestEndTime || info2.getEndTime() <= requestStartTime) continue;
                        infosToReturn.add(info2);
                    }
                    infosToReturn.sort(Comparator.comparingLong(Memory.AllocationsInfo::getStartTime));
                    for (int i2 = 0; i2 < infosToReturn.size(); ++i2) {
                        Memory.AllocationsInfo info2;
                        info2 = (Memory.AllocationsInfo)infosToReturn.get(i2);
                        rebuilder.addAllocationsInfo(info2);
                        long infoMax = info2.getEndTime() == Long.MAX_VALUE ? info2.getStartTime() : info2.getEndTime();
                        rebuilder.setEndTimestamp(Math.max(rebuilder.getEndTimestamp(), infoMax));
                    }
                    data = rebuilder.build();
                }
            }
            responseObserver2.onNext((Object)data);
            responseObserver2.onCompleted();
        }
        catch (RuntimeException e) {
            responseObserver2.onError((Throwable)e);
        }
    }

    public void trackAllocations(MemoryProfiler.TrackAllocationsRequest request, StreamObserver<MemoryProfiler.TrackAllocationsResponse> responseObserver2) {
        long sessionId = request.getSession().getSessionId();
        long timestamp = request.getRequestTime();
        MemoryProfiler.TrackAllocationsResponse response = this.myUseLegacyTracking ? (request.getEnabled() ? this.enableAllocations(timestamp, sessionId) : this.disableAllocations(timestamp, sessionId)) : this.myServiceStub.trackAllocations(request);
        responseObserver2.onNext((Object)response);
        responseObserver2.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemoryProfiler.TrackAllocationsResponse enableAllocations(long startTimeNs, long sessionId) {
        Object object = this.myUpdatingDataLock;
        synchronized (object) {
            if (this.myInProgressTrackingInfo.get(sessionId) != null) {
                return MemoryProfiler.TrackAllocationsResponse.newBuilder().setStatus(Memory.TrackStatus.newBuilder().setStatus(Memory.TrackStatus.Status.IN_PROGRESS)).build();
            }
            Long2ObjectMap infos = (Long2ObjectMap)this.myTrackingInfos.get(sessionId);
            MemoryProfiler.TrackAllocationsResponse.Builder responseBuilder = MemoryProfiler.TrackAllocationsResponse.newBuilder();
            LegacyAllocationTracker tracker = (LegacyAllocationTracker)this.myLegacyTrackers.get(sessionId);
            boolean success2 = tracker.trackAllocations(true, null, null);
            if (success2) {
                Memory.AllocationsInfo newInfo = Memory.AllocationsInfo.newBuilder().setStartTime(startTimeNs).setEndTime(Long.MAX_VALUE).setLegacy(true).build();
                responseBuilder.setInfo(newInfo);
                responseBuilder.setStatus(Memory.TrackStatus.newBuilder().setStatus(Memory.TrackStatus.Status.SUCCESS).setStartTime(startTimeNs));
                infos.put(startTimeNs, (Object)newInfo);
                this.myInProgressTrackingInfo.put(sessionId, (Object)newInfo);
            } else {
                responseBuilder.setStatus(Memory.TrackStatus.newBuilder().setStatus(Memory.TrackStatus.Status.FAILURE_UNKNOWN));
            }
            return responseBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemoryProfiler.TrackAllocationsResponse disableAllocations(long endtimeNs, long sessionId) {
        Object object = this.myUpdatingDataLock;
        synchronized (object) {
            Memory.AllocationsInfo lastInfo = (Memory.AllocationsInfo)this.myInProgressTrackingInfo.get(sessionId);
            if (lastInfo == null) {
                return MemoryProfiler.TrackAllocationsResponse.newBuilder().setStatus(Memory.TrackStatus.newBuilder().setStatus(Memory.TrackStatus.Status.NOT_ENABLED)).build();
            }
            LegacyAllocationTracker tracker = (LegacyAllocationTracker)this.myLegacyTrackers.get(sessionId);
            Long2ObjectMap infos = (Long2ObjectMap)this.myTrackingInfos.get(sessionId);
            MemoryProfiler.TrackAllocationsResponse.Builder responseBuilder = MemoryProfiler.TrackAllocationsResponse.newBuilder();
            boolean success2 = tracker.trackAllocations(false, this.myFetchExecutor, bytes -> this.saveAllocationData(sessionId, lastInfo.getStartTime(), (byte[])bytes));
            Memory.AllocationsInfo.Builder lastInfoBuilder = lastInfo.toBuilder();
            lastInfoBuilder.setEndTime(endtimeNs);
            lastInfoBuilder.setSuccess(success2);
            if (success2) {
                responseBuilder.setStatus(Memory.TrackStatus.newBuilder().setStatus(Memory.TrackStatus.Status.SUCCESS).setStartTime(lastInfo.getStartTime()));
            } else {
                responseBuilder.setStatus(Memory.TrackStatus.newBuilder().setStatus(Memory.TrackStatus.Status.FAILURE_UNKNOWN));
            }
            Memory.AllocationsInfo updatedInfo = lastInfoBuilder.build();
            responseBuilder.setInfo(updatedInfo);
            infos.put(lastInfo.getStartTime(), (Object)updatedInfo);
            return responseBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllocationData(long sessionId, long infoId, byte[] rawBytes) {
        Object object = this.myUpdatingDataLock;
        synchronized (object) {
            this.myProxyBytesCache.put(String.valueOf(infoId), rawBytes == null ? ByteString.EMPTY : ByteString.copyFrom((byte[])rawBytes));
            this.myInProgressTrackingInfo.remove(sessionId);
        }
    }

    public void forceGarbageCollection(MemoryProfiler.ForceGarbageCollectionRequest request, StreamObserver<MemoryProfiler.ForceGarbageCollectionResponse> observer2) {
        if (this.myDevice.isOnline()) {
            int processId = request.getSession().getPid();
            for (Client client : this.myDevice.getClients()) {
                if (processId != client.getClientData().getPid()) continue;
                client.executeGarbageCollector();
                break;
            }
        }
        observer2.onNext((Object)MemoryProfiler.ForceGarbageCollectionResponse.newBuilder().build());
        observer2.onCompleted();
    }

    @Override
    public ServerServiceDefinition getServiceDefinition() {
        HashMap<MethodDescriptor, ServerCallHandler> overrides = new HashMap<MethodDescriptor, ServerCallHandler>();
        overrides.put(MemoryServiceGrpc.getStartMonitoringAppMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.startMonitoringApp((MemoryProfiler.MemoryStartRequest)request, (StreamObserver<MemoryProfiler.MemoryStartResponse>)observer2)));
        overrides.put(MemoryServiceGrpc.getStopMonitoringAppMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.stopMonitoringApp((MemoryProfiler.MemoryStopRequest)request, (StreamObserver<MemoryProfiler.MemoryStopResponse>)observer2)));
        overrides.put(MemoryServiceGrpc.getGetDataMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.getData((MemoryProfiler.MemoryRequest)request, (StreamObserver<MemoryProfiler.MemoryData>)observer2)));
        overrides.put(MemoryServiceGrpc.getTrackAllocationsMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.trackAllocations((MemoryProfiler.TrackAllocationsRequest)request, (StreamObserver<MemoryProfiler.TrackAllocationsResponse>)observer2)));
        overrides.put(MemoryServiceGrpc.getForceGarbageCollectionMethod(), ServerCalls.asyncUnaryCall((request, observer2) -> this.forceGarbageCollection((MemoryProfiler.ForceGarbageCollectionRequest)request, (StreamObserver<MemoryProfiler.ForceGarbageCollectionResponse>)observer2)));
        return this.generatePassThroughDefinitions(overrides, (AbstractStub)this.myServiceStub);
    }
}

