/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.eventpreprocessor;

import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.TransportBytesPreprocessor;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.cpu.TracePreProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleperfPipelinePreprocessor
implements TransportEventPreprocessor,
TransportBytesPreprocessor {
    private final Map<String, List<String>> myTraceIdsToSymbols = new HashMap<String, List<String>>();
    private final TracePreProcessor myPreProcessor;

    public SimpleperfPipelinePreprocessor(@NotNull TracePreProcessor preProcessor) {
        this.myPreProcessor = preProcessor;
    }

    @Override
    public boolean shouldPreprocess(Common.Event event) {
        return event.hasCpuTrace() && event.getCpuTrace().hasTraceStarted() && event.getCpuTrace().getTraceStarted().getTraceInfo().getConfiguration().getUserOptions().getTraceType() == Cpu.CpuTraceType.SIMPLEPERF;
    }

    @Override
    @NotNull
    public Iterable<Common.Event> preprocessEvent(Common.Event event) {
        this.myTraceIdsToSymbols.putIfAbsent(String.valueOf(event.getCpuTrace().getTraceStarted().getTraceInfo().getTraceId()), (List<String>)event.getCpuTrace().getTraceStarted().getTraceInfo().getConfiguration().getSymbolDirsList());
        return Collections.emptyList();
    }

    @Override
    public boolean shouldPreprocess(Transport.BytesRequest request) {
        return this.myTraceIdsToSymbols.containsKey(request.getId());
    }

    @Override
    @NotNull
    public ByteString preprocessBytes(String id, ByteString data) {
        assert (this.myTraceIdsToSymbols.containsKey(id));
        return this.myPreProcessor.preProcessTrace(data, this.myTraceIdsToSymbols.remove(id));
    }
}

