/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.BuiltInImages;
import com.android.tools.idea.rendering.DrawableRenderer;
import com.android.utils.Pair;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphicGeneratorContext {
    private final Cache<Object, Future<BufferedImage>> myImageCache;
    private final DrawableRenderer myDrawableRenderer;

    public GraphicGeneratorContext(int maxCacheSize) {
        this(maxCacheSize, null);
    }

    public GraphicGeneratorContext(int maxCacheSize, @Nullable DrawableRenderer drawableRenderer) {
        this.myImageCache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).build();
        this.myDrawableRenderer = drawableRenderer;
    }

    @NotNull
    public final Future<BufferedImage> getFromCacheOrCreate(@NotNull Object key, @NotNull Callable<? extends Future<BufferedImage>> creator) {
        try {
            return (Future)this.myImageCache.get(key, creator);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.getLog().error(cause);
            return Futures.immediateFailedFuture((Throwable)cause);
        }
    }

    @Nullable
    public BufferedImage loadImageResource(@NotNull String path2) {
        try {
            Future<BufferedImage> imageFuture = this.getFromCacheOrCreate(path2, () -> GraphicGeneratorContext.getStencilImage(path2));
            return imageFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.getLog().error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public Future<BufferedImage> renderDrawable(@NotNull String xmlDrawableText, @NotNull Dimension size) {
        Pair key = Pair.of((Object)xmlDrawableText, (Object)size);
        Callable<Future> renderer2 = this.myDrawableRenderer == null ? () -> GraphicGeneratorContext.renderVectorDrawable(xmlDrawableText, size) : () -> this.myDrawableRenderer.renderDrawable(xmlDrawableText, size);
        return this.getFromCacheOrCreate(key, renderer2);
    }

    @NotNull
    private static Future<BufferedImage> renderVectorDrawable(@NotNull String vectorDrawableText, @NotNull Dimension size) {
        VdPreview.TargetSize targetSize = VdPreview.TargetSize.createFromMaxDimension((int)Math.max(size.width, size.height));
        BufferedImage image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)targetSize, (String)vectorDrawableText, null);
        if (image == null) {
            image = AssetStudioUtils.createPlaceholderImage();
        }
        return Futures.immediateFuture((Object)image);
    }

    @NotNull
    private static Future<BufferedImage> getStencilImage(@NotNull String path2) throws IOException {
        BufferedImage image = BuiltInImages.getStencilImage(path2);
        return Futures.immediateFuture((Object)image);
    }

    @NotNull
    private Logger getLog() {
        return Logger.getInstance(this.getClass());
    }
}

