/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.util.AssetUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.projectsystem.AndroidModulePaths;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterables;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0002\b\u0004\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u001a\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e\u001a\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t\u001a\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\t\u001a\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0016\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0012\u0010\"\u001a\u00020\t2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$\u001a\u0012\u0010%\u001a\u00020\t2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$\u001a\u000e\u0010&\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005\u001a\n\u0010'\u001a\u00020\u000e*\u00020\u001d\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006("}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "createPlaceholderImage", "Ljava/awt/image/BufferedImage;", "getBundledImage", "Ljava/io/File;", "dir", "", "fileName", "pad", "image", "paddingPercent", "", "resourceExists", "", "paths", "Lcom/android/tools/idea/projectsystem/AndroidModulePaths;", "resourceType", "Lcom/android/resources/ResourceFolderType;", "name", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "Lcom/android/resources/ResourceType;", "scaleDimension", "Ljava/awt/Dimension;", "dim", "scaleFactor", "", "scaleRectangle", "Ljava/awt/Rectangle;", "rect", "scaleRectangleAroundCenter", "toLowerCamelCase", "enumValue", "", "toUpperCamelCase", "trim", "roundToInt", "intellij.android.core"})
@JvmName(name="AssetStudioUtils")
public final class AssetStudioUtils {
    private static final Logger getLOG() {
        return LoggerKt.logger((String)"#com.android.tools.idea.npw.assetstudio.AssetStudioUtils");
    }

    @NotNull
    public static final Rectangle scaleRectangle(@NotNull Rectangle rect, double scaleFactor) {
        return new Rectangle(MathKt.roundToInt((double)((double)rect.x * scaleFactor)), MathKt.roundToInt((double)((double)rect.y * scaleFactor)), MathKt.roundToInt((double)((double)rect.width * scaleFactor)), MathKt.roundToInt((double)((double)rect.height * scaleFactor)));
    }

    @NotNull
    public static final Rectangle scaleRectangleAroundCenter(@NotNull Rectangle rect, double scaleFactor) {
        int width = MathKt.roundToInt((double)((double)rect.width * scaleFactor));
        int height = MathKt.roundToInt((double)((double)rect.height * scaleFactor));
        return new Rectangle(MathKt.roundToInt((double)((double)rect.x * scaleFactor - (double)(width - rect.width) / 2.0)), MathKt.roundToInt((double)((double)rect.y * scaleFactor - (double)(height - rect.height) / 2.0)), width, height);
    }

    @NotNull
    public static final Dimension scaleDimension(@NotNull Dimension dim, double scaleFactor) {
        return new Dimension(MathKt.roundToInt((double)((double)dim.width * scaleFactor)), MathKt.roundToInt((double)((double)dim.height * scaleFactor)));
    }

    public static final int roundToInt(double $this$roundToInt) {
        return MathKt.roundToInt((double)$this$roundToInt);
    }

    @NotNull
    public static final BufferedImage createPlaceholderImage() {
        return new BufferedImage(1, 1, 2);
    }

    @NotNull
    public static final BufferedImage trim(@NotNull BufferedImage image) {
        BufferedImage bufferedImage = ImageUtils.cropBlank((BufferedImage)image, null, (int)2);
        if (bufferedImage == null) {
            bufferedImage = image;
        }
        return bufferedImage;
    }

    @NotNull
    public static final BufferedImage pad(@NotNull BufferedImage image, int paddingPercent) {
        if (image.getWidth() <= 1 || image.getHeight() <= 1) {
            return image;
        }
        int n = image.getWidth();
        int n2 = image.getHeight();
        int n3 = 0;
        int largerSide = Math.max(n, n2);
        n2 = image.getWidth();
        n3 = image.getHeight();
        boolean bl = false;
        int smallerSide = Math.min(n2, n3);
        int padding = RangesKt.coerceAtLeast((int)(largerSide * RangesKt.coerceAtMost((int)paddingPercent, (int)100) / 100), (int)(-(smallerSide / 2 - 1)));
        return AssetUtil.paddedImage((BufferedImage)image, (int)padding);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean resourceExists(@NotNull AndroidModulePaths paths, @NotNull ResourceFolderType resourceType, @NotNull String name) {
        boolean bl;
        block8: {
            void $this$flatMapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            File[] resTypes;
            File file2 = (File)Iterables.getFirst((Iterable)paths.getResDirectories(), null);
            if (file2 == null) {
                return false;
            }
            File resDir = file2;
            File[] fileArray = resDir.listFiles();
            if (fileArray == null) {
                return false;
            }
            File[] $this$filter$iv = resTypes = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv;
            int n = ((void)iterator).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = iterator[j];
                boolean bl2 = false;
                if (!(it.isDirectory() && resourceType == ResourceFolderType.getFolderType((String)it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl3 = false;
                Object[] $this$orEmpty$iv = it.listFiles();
                boolean $i$f$orEmpty = false;
                Object[] objectArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    objectArray = new File[]{};
                }
                Iterable list$iv$iv = ArraysKt.toList((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    File it = (File)element$iv;
                    boolean bl4 = false;
                    if (!StringsKt.equals((String)FileUtil.getNameWithoutExtension((File)it), (String)name, (boolean)true)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean resourceExists(@NotNull AndroidFacet facet2, @NotNull ResourceType resourceType, @NotNull String name) {
        LocalResourceRepository repository = ResourceRepositoryManager.getAppResources(facet2);
        return repository.hasResources(ResourceNamespace.TODO(), resourceType, name);
    }

    @NotNull
    public static final String toLowerCamelCase(@NotNull Enum<?> enumValue) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, enumValue.name());
    }

    @NotNull
    public static final String toUpperCamelCase(@NotNull Enum<?> enumValue) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, enumValue.name());
    }

    @NotNull
    public static final File getBundledImage(@NotNull String dir, @NotNull String fileName) {
        Comparable<Path> comparable;
        Object v0;
        Path devImagesDir;
        Path releaseImagesDir;
        Path homePath;
        block3: {
            homePath = Paths.get(PathManager.getHomePath(), new String[0]);
            releaseImagesDir = homePath.resolve("plugins/android/resources/images/" + dir);
            devImagesDir = homePath.resolve("../../tools/adt/idea/android/resources/images/" + dir);
            Path releaseImage = releaseImagesDir.resolve(fileName);
            Path devImage = devImagesDir.resolve(fileName);
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])new Path[]{releaseImage, devImage, releaseImagesDir, devImagesDir, homePath});
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!PathKt.exists((Path)it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((comparable = (Path)v0) == null || (comparable = comparable.toFile()) == null) {
            throw (Throwable)new IOException("Studio root dir '" + homePath + "' is not readable");
        }
        Comparable<Path> root2 = comparable;
        if (((File)root2).isDirectory()) {
            AssetStudioUtils.getLOG().error("Bundled image file " + fileName + " is not found neither in " + releaseImagesDir + " not " + devImagesDir);
        }
        return root2;
    }
}

