/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.resolver;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.PlainFolderIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.RegularExpressionIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import java.io.File;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PlainFolderRegularExpressionIncludeResolver
extends RegularExpressionIncludeResolver {
    @NotNull
    private final String myPattern;

    private PlainFolderRegularExpressionIncludeResolver(@NotNull String pattern) {
        this.myPattern = pattern;
    }

    @NotNull
    static IncludeResolver include(@NotNull String pattern) {
        return new PlainFolderRegularExpressionIncludeResolver(pattern);
    }

    @Override
    @NotNull
    String getMatchRegexTemplate() {
        return this.myPattern;
    }

    @Override
    @Nullable
    public SimpleIncludeValue resolve(@NotNull File includeFolder) {
        Matcher match2 = LexicalIncludePaths.matchFolderToRegex(this.getCompiledMatchPattern(), includeFolder);
        if (!match2.find()) {
            return null;
        }
        return new PlainFolderIncludeResolver().resolve(includeFolder);
    }
}

