/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.apk;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.LibraryFolder;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.apk.SourceFolders;
import com.android.tools.idea.navigator.nodes.apk.java.DexGroupNode;
import com.android.tools.idea.navigator.nodes.apk.ndk.LibFolderNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkModuleNode
extends ProjectViewModuleNode {
    @NotNull
    private final String myModuleName;
    @NotNull
    private final AndroidFacet myAndroidFacet;
    @NotNull
    private final ApkFacet myApkFacet;
    @Nullable
    private final PsiFile myApkPsiFile;
    @Nullable
    private final VirtualFile myApkFile;
    @Nullable
    private final VirtualFile myManifestFile;
    @NotNull
    private final List<VirtualFile> myDexFiles;
    @NotNull
    private final List<DexGroupNode> myDexGroupNodes;

    public ApkModuleNode(@NotNull Project project, @NotNull Module module2, @NotNull AndroidFacet androidFacet, @NotNull ApkFacet apkFacet, @NotNull ViewSettings settings) {
        super(project, module2, settings);
        this.myModuleName = module2.getName();
        this.myAndroidFacet = androidFacet;
        this.myApkFacet = apkFacet;
        this.myApkPsiFile = this.findApkPsiFile();
        this.myApkFile = this.myApkPsiFile != null ? this.myApkPsiFile.getVirtualFile() : null;
        VirtualFile apkRootFile = this.myApkFile != null ? ApkFileSystem.getInstance().getRootByLocal(this.myApkFile) : null;
        VirtualFile rootFolder = this.findModuleRootFolder();
        this.myManifestFile = rootFolder != null ? rootFolder.findChild("AndroidManifest.xml") : null;
        this.myDexGroupNodes = new ArrayList<DexGroupNode>();
        this.myDexFiles = new ArrayList<VirtualFile>();
        if (apkRootFile != null) {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> apkRootFile.refresh(false, true)));
            Pattern dexFilePattern = Pattern.compile("classes\\d*\\.dex");
            for (VirtualFile child : apkRootFile.getChildren()) {
                if (!dexFilePattern.matcher(child.getName()).matches()) continue;
                ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> child.refresh(false, false)));
                this.myDexFiles.add(child);
            }
        }
    }

    @Nullable
    private VirtualFile findModuleRootFolder() {
        File moduleRootFolderPath = AndroidRootUtil.findModuleRootFolderPath(this.getModule());
        if (moduleRootFolderPath == null) {
            return null;
        }
        return VfsUtil.findFileByIoFile((File)moduleRootFolderPath, (boolean)false);
    }

    @Nullable
    private PsiFile findApkPsiFile() {
        VirtualFile apkFile;
        File apkFilePath;
        String apkPath = ((ApkFacetConfiguration)this.myApkFacet.getConfiguration()).APK_PATH;
        if (StringUtil.isNotEmpty((String)apkPath) && (apkFilePath = new File(FileUtil.toSystemDependentName((String)apkPath))).isFile() && (apkFile = VfsUtil.findFileByIoFile((File)apkFilePath, (boolean)true)) != null) {
            assert (this.myProject != null);
            return PsiManager.getInstance((Project)this.myProject).findFile(apkFile);
        }
        return null;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        assert (this.myProject != null);
        ViewSettings settings = this.getSettings();
        ArrayList children = new ArrayList();
        if (this.myApkPsiFile != null) {
            children.add((AbstractTreeNode<?>)new PsiFileNode(this.myProject, this.myApkPsiFile, settings));
        }
        children.add((AbstractTreeNode<?>)this.createManifestGroupNode());
        if (this.myDexGroupNodes.isEmpty()) {
            for (VirtualFile dexFile : this.myDexFiles) {
                DexGroupNode node2 = new DexGroupNode(this.myProject, settings, dexFile);
                this.myDexGroupNodes.add(node2);
            }
        }
        children.addAll(this.myDexGroupNodes);
        VirtualFile found = LibraryFolder.findIn(this.myProject);
        if (found != null) {
            children.add((AbstractTreeNode<?>)new LibFolderNode(this.myProject, found, settings));
        }
        return children;
    }

    @NotNull
    private AndroidManifestsGroupNode createManifestGroupNode() {
        assert (this.myProject != null);
        Set<VirtualFile> manifestFiles = this.myManifestFile != null ? Collections.singleton(this.myManifestFile) : Collections.emptySet();
        return new AndroidManifestsGroupNode(this.myProject, this.myAndroidFacet, this.getSettings(), manifestFiles);
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "APK Module";
    }

    @NotNull
    private Module getModule() {
        Module module2 = (Module)this.getValue();
        assert (module2 != null);
        return module2;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        String path2 = file2.getPath();
        if (this.myApkFile != null && Objects.equals(path2, this.myApkFile.getPath())) {
            return true;
        }
        if (Objects.equals(path2, this.getManifestPath())) {
            return true;
        }
        if (!this.myDexGroupNodes.isEmpty() && this.myDexGroupNodes.stream().anyMatch(node2 -> node2.contains(file2))) {
            return true;
        }
        VirtualFile found = LibraryFolder.findIn(this.myProject);
        if (found != null && VfsUtilCore.isAncestor((VirtualFile)found, (VirtualFile)file2, (boolean)false)) {
            return true;
        }
        return SourceFolders.isInSourceFolder(file2, this.myProject);
    }

    @Nullable
    private String getManifestPath() {
        return this.myManifestFile != null ? this.myManifestFile.getPath() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApkModuleNode)) {
            return false;
        }
        ApkModuleNode node2 = (ApkModuleNode)((Object)o);
        return Objects.equals(this.myModuleName, node2.myModuleName);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myModuleName);
    }
}

