/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPsiDirectoryNode
extends PsiDirectoryNode {
    private final NamedIdeaSourceProvider mySourceProvider;

    AndroidPsiDirectoryNode(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull ViewSettings settings, @Nullable NamedIdeaSourceProvider sourceProvider) {
        super(project, directory, settings);
        this.mySourceProvider = sourceProvider;
    }

    protected void updateImpl(@NotNull PresentationData data) {
        super.updateImpl(data);
        if (this.mySourceProvider != null && !"main".equals(this.mySourceProvider.getName())) {
            data.addText(data.getPresentableText(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            data.addText(" (" + this.mySourceProvider.getName() + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public Comparable getSortKey() {
        VirtualFile virtualFile = this.getValue() != null ? ((PsiDirectory)this.getValue()).getVirtualFile() : null;
        String path2 = virtualFile != null ? virtualFile.getPath() : "";
        String sourceProviderName = this.mySourceProvider == null ? "" : this.mySourceProvider.getName();
        return this.getQualifiedNameSortKey() + "-" + ("main".equals(sourceProviderName) ? "" : sourceProviderName) + "-" + path2;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiDirectory value2 = (PsiDirectory)this.getValue();
        assert (value2 != null);
        return AndroidPsiDirectoryNode.toTestString(value2.getName(), this.mySourceProvider);
    }

    @NotNull
    static String toTestString(@NotNull String element2, @Nullable NamedIdeaSourceProvider provider2) {
        StringBuilder buffer = new StringBuilder(element2);
        if (provider2 != null) {
            buffer.append(" (");
            buffer.append(provider2.getName());
            buffer.append(")");
        }
        return buffer.toString();
    }
}

