/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.surface;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.AndroidStudioKotlinPluginUtils;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.LerpDouble;
import com.android.tools.idea.common.scene.LerpPoint;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SinglePositionableContentLayoutManager;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.editor.NavActionManager;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelper;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.scene.NavSceneManagerKt;
import com.android.tools.idea.naveditor.surface.NavDesignSurfaceActionHandler;
import com.android.tools.idea.naveditor.surface.NavInteractionHandler;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.utils.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavDesignSurface
extends DesignSurface {
    private static final int SCROLL_DURATION_MS = 300;
    private static final Object CONNECTION_CLIENT_PROPERTY_KEY = new Object();
    private static final String FAILED_DEPENDENCY = "Failed to add navigation dependency";
    private static final String FAILED_DEPENDENCY_TITLE = "Failed to Add Dependency";
    private NlComponent myCurrentNavigation;
    @VisibleForTesting
    AtomicReference<Future<?>> myScheduleRef = new AtomicReference();
    private DesignerEditorPanel myEditorPanel;
    private static final WeakHashMap<AndroidFacet, SoftReference<ConfigurationManager>> ourConfigurationManagers = new WeakHashMap();
    private static final List<GradleCoordinate> NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT.getCoordinate("+"), (Object)GoogleMavenArtifactId.NAVIGATION_UI.getCoordinate("+"));
    private static final List<GradleCoordinate> NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT_KTX.getCoordinate("+"), (Object)GoogleMavenArtifactId.NAVIGATION_UI_KTX.getCoordinate("+"));
    private static final List<GradleCoordinate> ANDROIDX_NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT.getCoordinate("+"), (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI.getCoordinate("+"));
    private static final List<GradleCoordinate> ANDROIDX_NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT_KTX.getCoordinate("+"), (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI_KTX.getCoordinate("+"));

    public NavDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable) {
        this(project, null, parentDisposable);
    }

    public NavDesignSurface(@NotNull Project project, @Nullable DesignerEditorPanel editorPanel2, @NotNull Disposable parentDisposable) {
        super(project, parentDisposable, surface2 -> new NavActionManager((NavDesignSurface)((Object)surface2)), NavInteractionHandler::new, true, surface2 -> new SinglePositionableContentLayoutManager(), surface2 -> new NavDesignSurfaceActionHandler((NavDesignSurface)((Object)surface2)));
        this.myEditorPanel = editorPanel2;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NavDesignSurface.this.removeComponentListener(this);
                NavDesignSurface.this.requestRender();
            }
        });
        this.getSelectionModel().addListener((SelectionModel unused, List<NlComponent> selection) -> this.updateCurrentNavigation(selection));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestRender() {
        SceneManager manager = (SceneManager)Iterables.getFirst(this.getSceneManagers(), null);
        return manager != null ? manager.requestRender() : CompletableFuture.completedFuture(null);
    }

    @Override
    public void dispose() {
        Future<?> future2 = this.getScheduleRef().get();
        if (future2 != null) {
            future2.cancel(false);
        }
        this.getScheduleRef().set(null);
        super.dispose();
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        Point2D.Float p2d;
        SceneComponent sceneComponent;
        Scene scene;
        NlComponent selection;
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId) && (selection = this.getSelectionModel().getPrimary()) != null && NavComponentHelperKt.isAction(selection) && (scene = this.getScene()) != null && (sceneComponent = scene.getSceneComponent(selection)) != null && (p2d = NavActionHelperKt.getAnyPoint(sceneComponent, SceneContext.get(this.getFocusedSceneView()))) != null) {
            return new Point((int)p2d.x, (int)p2d.y);
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> forceUserRequestedRefresh() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model2) {
        return new NavSceneManager(model2, this);
    }

    @Override
    @Nullable
    public NavSceneManager getSceneManager() {
        return (NavSceneManager)super.getSceneManager();
    }

    @Override
    public CompletableFuture<?> goingToSetModel(final NlModel model2) {
        model2.getConfiguration().getResourceResolver();
        final AndroidFacet facet2 = model2.getFacet();
        final CompletableFuture result2 = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (NavDesignSurface.tryToCreateSchema(facet2)) {
                result2.complete(null);
            } else if (this.requestAddDependency(facet2)) {
                ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getSyncManager(this.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
                Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(@Nullable Object unused) {
                        application.executeOnPooledThread(() -> {
                            if (!NavDesignSurface.tryToCreateSchema(facet2)) {
                                NavDesignSurface.this.showFailToAddMessage(result2, model2);
                            } else {
                                result2.complete(null);
                            }
                        });
                    }

                    public void onFailure(@Nullable Throwable t) {
                        NavDesignSurface.this.showFailToAddMessage(result2, model2);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            } else {
                this.showFailToAddMessage(result2, model2);
            }
        });
        return result2;
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        CompletableFuture<Void> future2 = super.setModel(model2);
        NavUsageTracker.Companion.getInstance(model2).createEvent(NavEditorEvent.NavEditorEventType.OPEN_FILE).withNavigationContents().log();
        return future2;
    }

    private void showFailToAddMessage(@NotNull CompletableFuture<?> result2, final @NotNull NlModel model2) {
        if (this.myEditorPanel != null) {
            ProjectSystemSyncManager.SyncResultListener syncFailedListener = new ProjectSystemSyncManager.SyncResultListener(){

                @Override
                public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result2) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (NavDesignSurface.tryToCreateSchema(model2.getFacet())) {
                            NavDesignSurface.this.myEditorPanel.initNeleModel();
                            ((MessageBusConnection)NavDesignSurface.this.myEditorPanel.getClientProperty(CONNECTION_CLIENT_PROPERTY_KEY)).disconnect();
                            NavDesignSurface.this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, null);
                        }
                    });
                }
            };
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, connection);
            connection.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)syncFailedListener);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.onFailedToAddDependency());
        result2.completeExceptionally(new Exception(FAILED_DEPENDENCY));
    }

    private void onFailedToAddDependency() {
        Messages.showErrorDialog((Project)this.getProject(), (String)FAILED_DEPENDENCY, (String)FAILED_DEPENDENCY_TITLE);
        if (this.myEditorPanel != null) {
            this.myEditorPanel.getWorkBench().loadingStopped(FAILED_DEPENDENCY);
        }
    }

    private boolean requestAddDependency(@NotNull AndroidFacet facet2) {
        List<GradleCoordinate> dependencies2 = NavDesignSurface.getDependencies(facet2.getModule());
        AtomicBoolean didAdd = new AtomicBoolean(false);
        ApplicationManager.getApplication().invokeAndWait(() -> didAdd.set(DependencyManagementUtil.addDependencies(facet2.getModule(), dependencies2, true, false).isEmpty()));
        return didAdd.get();
    }

    @NotNull
    public static List<GradleCoordinate> getDependencies(@NotNull Module module2) {
        boolean isKotlin = AndroidStudioKotlinPluginUtils.hasKotlinFacet(module2);
        if (MigrateToAndroidxUtil.isAndroidx(module2.getProject())) {
            return isKotlin ? ANDROIDX_NAVIGATION_DEPENDENCIES_KTX : ANDROIDX_NAVIGATION_DEPENDENCIES;
        }
        return isKotlin ? NAVIGATION_DEPENDENCIES_KTX : NAVIGATION_DEPENDENCIES;
    }

    private static boolean tryToCreateSchema(@NotNull AndroidFacet facet2) {
        Module module2 = facet2.getModule();
        return (Boolean)DumbService.getInstance((Project)module2.getProject()).runReadActionInSmartMode(() -> {
            try {
                NavigationSchema.createIfNecessary(module2);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        });
    }

    @Override
    public void activate() {
        super.activate();
        NlModel model2 = this.getModel();
        if (model2 != null) {
            Module module2 = model2.getModule();
            try {
                NavigationSchema.createIfNecessary(module2);
            }
            catch (ClassNotFoundException e) {
                return;
            }
            NavigationSchema schema = NavigationSchema.get(module2);
            if (!schema.quickValidate()) {
                if (this.myEditorPanel == null) {
                    return;
                }
                this.myEditorPanel.getWorkBench().showLoading("Refreshing Navigators...");
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        schema.rebuildSchema().get();
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().hideLoading());
                    }
                    catch (Exception e) {
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().loadingStopped("Error refreshing Navigators"));
                    }
                });
            } else {
                schema.rebuildSchema();
            }
        }
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component -> new DnDTransferComponent(component.getTagName(), component.getTagDeprecated().getText(), 0, 0)).collect(ImmutableCollectors.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @NotNull
    public NlComponent getCurrentNavigation() {
        if (!this.validateCurrentNavigation().booleanValue()) {
            this.refreshRoot();
        }
        return this.myCurrentNavigation;
    }

    private Boolean validateCurrentNavigation() {
        NlComponent current = this.myCurrentNavigation;
        if (current == null || current.getModel() != this.getModel()) {
            return false;
        }
        while (current.getParent() != null) {
            NlComponent parent = current.getParent();
            if (!parent.getChildren().contains(current)) {
                return false;
            }
            current = parent;
        }
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        assert (components.size() == 1);
        return current == components.get(0);
    }

    public void setCurrentNavigation(@NotNull NlComponent currentNavigation) {
        this.myCurrentNavigation = currentNavigation;
        this.getSceneManager().update();
        this.getSceneManager().layout(false);
        this.zoomToFit();
        currentNavigation.getModel().notifyModified(NlModel.ChangeType.UPDATE_HIERARCHY);
        this.repaint();
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(0, 0);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        SceneView view = this.getFocusedSceneView();
        if (view == null) {
            return new Dimension(0, 0);
        }
        SceneComponent root2 = view.getScene().getRoot();
        if (root2 == null) {
            return new Dimension(0, 0);
        }
        Rectangle boundingBox = NavSceneManagerKt.getBoundingBox(root2);
        return boundingBox.getSize();
    }

    @Override
    public boolean isLayoutDisabled() {
        return false;
    }

    @Override
    protected boolean isKeepingScaleWhenReopen() {
        return false;
    }

    @Override
    protected double getMinScale() {
        return this.isEmpty() ? 1.0 : 0.1;
    }

    @Override
    protected double getMaxScale() {
        return this.isEmpty() ? 1.0 : 3.0;
    }

    @Override
    public boolean canZoomToFit() {
        return !this.isEmpty();
    }

    @Override
    protected double getFitScale(boolean fitInto) {
        return Math.min(super.getFitScale(fitInto), 1.0);
    }

    private boolean isEmpty() {
        NavSceneManager sceneManager = this.getSceneManager();
        return sceneManager == null || sceneManager.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyComponentActivate(@NotNull NlComponent component) {
        VirtualFile virtualFile;
        PsiFile file2;
        PsiClass psiClass;
        String className2;
        NavEditorEvent.NavEditorEventType metricsEventType;
        String id;
        if (this.myCurrentNavigation == component) {
            return;
        }
        if (NavComponentHelperKt.isNavigation(component)) {
            if (!NavComponentHelperKt.isInclude(component)) {
                this.setCurrentNavigation(component);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_NESTED).log();
                return;
            }
            id = component.getAttribute("http://schemas.android.com/apk/res-auto", "graph");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_INCLUDE;
            if (id == null) {
                return;
            }
        } else {
            id = component.getAttribute("http://schemas.android.com/tools", "layout");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_LAYOUT;
        }
        if (id != null) {
            VirtualFile virtualFile2;
            File file3;
            String fileName;
            Configuration configuration = (Configuration)Iterables.getOnlyElement(this.getConfigurations(), null);
            ResourceResolver resolver = configuration != null ? configuration.getResourceResolver() : null;
            ResourceValue value2 = resolver != null ? resolver.findResValue(id, false) : null;
            String string = fileName = value2 != null ? value2.getValue() : null;
            if (fileName != null && (file3 = new File(fileName)).exists() && (virtualFile2 = VfsUtil.findFileByIoFile((File)file3, (boolean)false)) != null) {
                FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile2, true);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(metricsEventType).log();
                return;
            }
        }
        if ((className2 = component.getAttribute("http://schemas.android.com/apk/res/android", "name")) != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className2, GlobalSearchScope.allScope((Project)this.getProject()))) != null && (file2 = psiClass.getContainingFile()) != null && (virtualFile = file2.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile, true);
            NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_CLASS).log();
            return;
        }
        super.notifyComponentActivate(component);
    }

    @Override
    @NotNull
    public Consumer<NlComponent> getComponentRegistrar() {
        return component -> NavComponentHelper.INSTANCE.registerComponent((NlComponent)component);
    }

    @Override
    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        NavSceneManager sceneManager;
        boolean isFitZoom;
        boolean scaled = super.zoom(type, x, y);
        boolean bl = isFitZoom = type == ZoomType.FIT || type == ZoomType.FIT_INTO;
        if ((scaled || isFitZoom) && (sceneManager = this.getSceneManager()) != null) {
            sceneManager.layout(false);
            this.validateScrollArea();
        }
        if (isFitZoom) {
            Dimension visibleSize = this.getExtentSize();
            Dimension size = this.getViewSize();
            this.setScrollPosition((size.width - visibleSize.width) / 2, (size.height - visibleSize.height) / 2);
        }
        return scaled;
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        Scene scene = this.getScene();
        SceneView view = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view == null) {
            return;
        }
        Rectangle selectionBounds = NavSceneManagerKt.getBoundingBox(list.stream().map(nlComponent -> scene.getSceneComponent((NlComponent)nlComponent)).filter(sceneComponent -> sceneComponent != null).collect(Collectors.toList()));
        Dimension swingViewportSize = this.getExtentSize();
        int swingStartCenterXInViewport = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX()) - this.getScrollPosition().x;
        int swingStartCenterYInViewport = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY()) - this.getScrollPosition().y;
        Point start2 = new Point(swingStartCenterXInViewport, swingStartCenterYInViewport);
        Point end = new Point(swingViewportSize.width / 2, swingViewportSize.height / 2);
        LerpPoint lerpPoint = new LerpPoint(start2, end, this.getScrollDurationMs());
        LerpDouble zoomLerp = new LerpDouble(view.getScale(), this.getFitScale(selectionBounds.getSize(), true), this.getScrollDurationMs());
        if (this.getScheduleRef().get() != null) {
            this.getScheduleRef().get().cancel(false);
        }
        Runnable action2 = () -> UIUtil.invokeAndWaitIfNeeded(() -> {
            long time2 = System.currentTimeMillis();
            Point pointSwingValue = (Point)lerpPoint.getValue(time2);
            int targetSwingX = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX());
            int targetSwingY = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY());
            this.setScrollPosition(targetSwingX - pointSwingValue.x, targetSwingY - pointSwingValue.y);
            this.setScale((Double)zoomLerp.getValue(time2), targetSwingX, targetSwingY);
            if (lerpPoint.isComplete(time2)) {
                this.getScheduleRef().get().cancel(false);
                this.getScheduleRef().set(null);
            }
        });
        this.getScheduleRef().set(AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(action2, 0L, 10L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    @NotNull
    AtomicReference<Future<?>> getScheduleRef() {
        return this.myScheduleRef;
    }

    @VisibleForTesting
    int getScrollDurationMs() {
        return 300;
    }

    public void refreshRoot() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            return;
        }
        NlComponent match2 = (NlComponent)model2.getComponents().get(0);
        if (this.myCurrentNavigation != null) {
            boolean includingParent = false;
            TagSnapshot currentSnapshot = this.myCurrentNavigation.getSnapshot();
            NlComponent currentParent = this.myCurrentNavigation.getParent();
            for (NlComponent component : model2.flattenComponents()::iterator) {
                if (!NavComponentHelperKt.isNavigation(component)) continue;
                if (component == this.myCurrentNavigation) {
                    return;
                }
                TagSnapshot componentSnapshot = component.getSnapshot();
                if (currentSnapshot != null && currentSnapshot == componentSnapshot) {
                    match2 = component;
                    break;
                }
                if (includingParent || !Objects.equals(component.getId(), this.myCurrentNavigation.getId())) continue;
                match2 = component;
                NlComponent componentParent = component.getParent();
                if (componentParent == null != (currentParent == null) || componentParent != null && !Objects.equals(componentParent.getId(), currentParent.getId())) continue;
                includingParent = true;
            }
        }
        if (this.myCurrentNavigation != match2) {
            this.myCurrentNavigation = match2;
            this.getSelectionModel().setSelection((List<? extends NlComponent>)ImmutableList.of((Object)this.myCurrentNavigation));
        }
    }

    @Override
    @NotNull
    public ConfigurationManager getConfigurationManager(@NotNull AndroidFacet facet2) {
        SoftReference<ConfigurationManager> ref = ourConfigurationManagers.get(facet2);
        ConfigurationManager result2 = null;
        if (ref != null) {
            result2 = (ConfigurationManager)ref.get();
        }
        if (result2 == null) {
            result2 = new MyConfigurationManager(facet2.getModule());
            ourConfigurationManagers.put(facet2, (SoftReference<ConfigurationManager>)new SoftReference((Object)result2));
        }
        return result2;
    }

    @Override
    protected boolean getSupportPinchAndZoom() {
        return false;
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlComponent root2 = this.getCurrentNavigation();
        return root2.flatten().filter(component -> component == root2 || NavComponentHelperKt.isDestination(component) && component.getParent() == root2 || NavComponentHelperKt.isAction(component) && (component.getParent() == root2 || component.getParent() != null && component.getParent().getParent() == root2 || NavComponentHelperKt.getActionType(component, root2) == ActionType.EXIT_DESTINATION)).collect(Collectors.toList());
    }

    private void updateCurrentNavigation(@NotNull List<NlComponent> selection) {
        if (selection.isEmpty()) {
            return;
        }
        if (this.getSelectableComponents().stream().anyMatch(selection::contains)) {
            return;
        }
        NlComponent selected = selection.get(0);
        NlComponent next = selected.getParent();
        if (next == null) {
            next = selected;
        }
        while (next != null && !NavComponentHelperKt.isNavigation(next)) {
            next = next.getParent();
        }
        if (next != null) {
            this.setCurrentNavigation(next);
        }
    }

    private static class MyConfigurationManager
    extends ConfigurationManager {
        MyConfigurationManager(@NotNull Module module2) {
            super(module2);
        }

        @Override
        public ConfigurationStateManager getStateManager() {
            return new ConfigurationStateManager();
        }
    }
}

