/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit.viewer;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class HtmlUtils {
    private static final List<String> CHARACTERS_PLAIN = Arrays.asList("<", ">", "&", "'", "\"", "\r\n", "\n");
    private static final List<String> CHARACTERS_HTML = Arrays.asList("&lt;", "&gt;", "&amp;", "&#39;", "&quot;", "<br>", "<br>");

    @NotNull
    public static String plainTextToHtml(@NotNull String text2) {
        text2 = StringUtil.replace((String)text2, CHARACTERS_PLAIN, CHARACTERS_HTML);
        StringBuffer sb = new StringBuffer("<html><body>");
        Matcher matcher = URLUtil.URL_PATTERN.matcher(text2);
        while (matcher.find()) {
            if (matcher.groupCount() <= 0) continue;
            String url = matcher.group(0);
            matcher.appendReplacement(sb, "<a href='" + url + "'>" + url + "</a>");
        }
        matcher.appendTail(sb);
        sb.append("</body></html>");
        return sb.toString();
    }
}

