/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.checks.ByteOrderMarkDetector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintByteOrderMarkInspection
extends AndroidLintInspectionBase {
    public AndroidLintByteOrderMarkInspection() {
        super(AndroidBundle.message("android.lint.inspections.byte.order.mark", new Object[0]), ByteOrderMarkDetector.BOM);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2) {
        return new LintIdeQuickFix[]{new DefaultLintQuickFix("Remove byte order marks", true){

            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
                Document document = FileDocumentManager.getInstance().getDocument(startElement.getContainingFile().getVirtualFile());
                if (document != null) {
                    String text2 = document.getText();
                    for (int i2 = text2.length() - 1; i2 >= 0; --i2) {
                        char c = text2.charAt(i2);
                        if (c != '\ufeff') continue;
                        document.deleteString(i2, i2 + 1);
                    }
                }
            }
        }};
    }
}

