/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleProjects {
    private static final Key<Boolean> SYNC_REQUESTED_DURING_BUILD = Key.create((String)"project.sync.requested.during.build");

    private GradleProjects() {
    }

    public static void executeProjectChanges(@NotNull Project project, @NotNull Runnable changes) {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            if (!project.isDisposed()) {
                changes.run();
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (!project.isDisposed()) {
                ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
            }
        }));
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    public static boolean isGradleProjectModule(@NotNull Module module2) {
        return ":".equals(GradleProjects.getGradleModulePath(module2));
    }

    @Nullable
    public static String getGradleModulePath(@NotNull Module module2) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module2)) {
            return null;
        }
        String linkedProjectId = ExternalSystemModulePropertyManager.getInstance((Module)module2).getLinkedProjectId();
        if (linkedProjectId == null) {
            return null;
        }
        return linkedProjectId.contains(":") ? linkedProjectId : ":";
    }

    public static boolean canImportAsGradleProject(@NotNull VirtualFile importSource) {
        VirtualFile target = ProjectImportUtil.findGradleTarget(importSource);
        return target != null && ("gradle".equals(target.getExtension()) || target.getName().endsWith("gradle.kts"));
    }

    public static void setSyncRequestedDuringBuild(@NotNull Project project, @Nullable Boolean value2) {
        project.putUserData(SYNC_REQUESTED_DURING_BUILD, (Object)value2);
    }

    public static boolean isSyncRequestedDuringBuild(@NotNull Project project) {
        return (Boolean)SYNC_REQUESTED_DURING_BUILD.get((UserDataHolder)project, (Object)false);
    }

    public static boolean isIdeaAndroidModule(@NotNull Module module2) {
        if (GradleFacet.getInstance(module2) != null || JavaFacet.getInstance(module2) != null) {
            return true;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module2);
        return androidFacet != null && AndroidModel.isRequired(androidFacet);
    }

    public static boolean containsExternalCppProjects(@NotNull Project project) {
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(module2);
            if (ndkModuleModel == null) continue;
            return true;
        }
        return false;
    }
}

