/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.util.StudioPathManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    @NotNull
    public static EmbeddedDistributionPaths getInstance() {
        return (EmbeddedDistributionPaths)ServiceManager.getService(EmbeddedDistributionPaths.class);
    }

    @NotNull
    public List<File> findAndroidStudioLocalMavenRepoPaths() {
        if (!((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() && !CommandLineArgs.isInTestingMode()) {
            return ImmutableList.of();
        }
        return EmbeddedDistributionPaths.doFindAndroidStudioLocalMavenRepoPaths();
    }

    @VisibleForTesting
    @NotNull
    static List<File> doFindAndroidStudioLocalMavenRepoPaths() {
        ArrayList<File> repoPaths = new ArrayList<File>();
        String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
        if (studioCustomRepo != null) {
            File customRepoPath = new File(FileUtil.toCanonicalPath((String)FileUtil.toSystemDependentName((String)studioCustomRepo)));
            if (!customRepoPath.isDirectory()) {
                throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable");
            }
            repoPaths.add(customRepoPath);
        }
        if (StudioPathManager.isRunningFromSources()) {
            ArrayList<String> repoCandidates = new ArrayList<String>();
            if (studioCustomRepo == null) {
                repoCandidates.add("out/repo");
            }
            repoCandidates.add("out/studio/repo");
            repoCandidates.add("prebuilts/tools/common/m2/repository");
            String sourcesRoot = StudioPathManager.getSourcesRoot();
            for (String candidate : repoCandidates) {
                File offlineRepo = new File(FileUtil.toCanonicalPath((String)Paths.get(sourcesRoot, candidate).toString()));
                if (!offlineRepo.isDirectory()) continue;
                repoPaths.add(offlineRepo);
            }
        }
        return ImmutableList.copyOf(repoPaths);
    }

    @NotNull
    public File findEmbeddedProfilerTransform() {
        if (StudioPathManager.isRunningFromSources()) {
            return new File(StudioPathManager.getSourcesRoot(), "bazel-bin/tools/base/profiler/transform/profilers-transform.jar");
        }
        return new File(PathManager.getHomePath(), "plugins/android/resources/profilers-transform.jar");
    }

    @Nullable
    public File findEmbeddedGradleDistributionPath() {
        if (StudioPathManager.isRunningFromSources()) {
            String relativePath;
            String sourcesRoot = StudioPathManager.getSourcesRoot();
            File distributionPath = new File(FileUtil.toCanonicalPath((String)Paths.get(sourcesRoot, relativePath = FileUtil.toSystemDependentName((String)"tools/external/gradle")).toString()));
            if (distributionPath.isDirectory()) {
                return distributionPath;
            }
            String localDistributionPath = System.getProperty("local.gradle.distribution.path");
            if (localDistributionPath != null && (distributionPath = new File(FileUtil.toCanonicalPath((String)localDistributionPath))).isDirectory()) {
                return distributionPath;
            }
            return null;
        }
        Logger log = EmbeddedDistributionPaths.getLog();
        File distributionPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (distributionPath == null) {
            File embeddedPath = new File(distributionPath, "gradle-6.7.1");
            log.info("Looking for embedded Gradle distribution at '" + embeddedPath.getPath() + "'");
            if (embeddedPath.isDirectory()) {
                log.info("Found embedded Gradle 6.7.1");
                return embeddedPath;
            }
        }
        log.info("Unable to find embedded Gradle 6.7.1");
        return null;
    }

    @Nullable
    public File findEmbeddedGradleDistributionFile(@NotNull String gradleVersion2) {
        File distributionPath = this.findEmbeddedGradleDistributionPath();
        if (distributionPath != null) {
            File allDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-all.zip");
            if (allDistributionFile.isFile() && allDistributionFile.exists()) {
                return allDistributionFile;
            }
            File binDistributionFile = new File(distributionPath, "gradle-" + gradleVersion2 + "-bin.zip");
            if (binDistributionFile.isFile() && binDistributionFile.exists()) {
                return binDistributionFile;
            }
        }
        return null;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(EmbeddedDistributionPaths.class);
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }

    @Nullable
    public File tryToGetEmbeddedJdkPath() {
        try {
            return this.getEmbeddedJdkPath();
        }
        catch (Throwable t) {
            Logger.getInstance(EmbeddedDistributionPaths.class).warn("Failed to find a valid embedded JDK", t);
            return null;
        }
    }

    @NotNull
    public File getEmbeddedJdkPath() {
        if (StudioPathManager.isRunningFromSources()) {
            if (System.getProperty("android.test.embedded.jdk") != null) {
                File jdkDir = new File(System.getProperty("android.test.embedded.jdk"));
                assert (jdkDir.exists());
                return jdkDir;
            }
            String sourcesRoot = StudioPathManager.getSourcesRoot();
            String jdkDevPath = System.getProperty("studio.dev.jdk", Paths.get(sourcesRoot, "prebuilts/studio/jdk").toString());
            String relativePath = FileUtil.toSystemDependentName((String)jdkDevPath);
            File jdkRootPath = new File(FileUtil.toCanonicalPath((String)relativePath));
            if (SystemInfo.isJavaVersionAtLeast((int)11, (int)0, (int)0)) {
                jdkRootPath = new File(jdkRootPath, "jdk11");
            }
            if (SystemInfo.isWindows) {
                jdkRootPath = new File(jdkRootPath, "win");
            } else if (SystemInfo.isLinux) {
                jdkRootPath = new File(jdkRootPath, "linux");
            } else if (SystemInfo.isMac) {
                jdkRootPath = new File(jdkRootPath, "mac");
            }
            return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
        }
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File jdkRootPath = new File(ideHomePath, SystemInfo.isMac ? FileUtil.join((String[])new String[]{"jre", "jdk"}) : "jre");
        return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
    }

    @NotNull
    private static File getSystemSpecificJdkPath(File jdkRootPath) {
        if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "/Contents/Home");
        }
        if (!jdkRootPath.isDirectory()) {
            throw new Error(String.format("Incomplete or corrupted installation - \"%s\" directory does not exist", jdkRootPath.toString()));
        }
        return jdkRootPath;
    }

    @NotNull
    private static String getIdeHomePath() {
        return FileUtil.toSystemDependentName((String)PathManager.getHomePath());
    }
}

