/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.treeview;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesByTypeAndTextComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueCollectionKt;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeHyperlinkSupport<T extends SimpleNode>
implements Disposable {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final Class<T> mySupportedNodeType;
    @NotNull
    private final PsContext myContext;
    private final boolean myShowIssues;
    private T myHoveredNode;
    private KeyEventDispatcher myKeyEventDispatcher;

    public NodeHyperlinkSupport(@NotNull Tree tree, @NotNull Class<T> supportedNodeType, @NotNull PsContext context, boolean showIssues) {
        this.myTree = tree;
        this.mySupportedNodeType = supportedNodeType;
        this.myContext = context;
        this.myShowIssues = showIssues;
        this.addHyperlinkBehaviorToSupportedNodes();
        this.myTree.repaint();
    }

    private void addHyperlinkBehaviorToSupportedNodes() {
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer(){

            @NotNull
            protected SimpleTextAttributes getSimpleTextAttributes(@NotNull PresentationData presentation, Color color, @NotNull Object node2) {
                List issues = Collections.emptyList();
                if (NodeHyperlinkSupport.this.myShowIssues && node2 instanceof AbstractPsModelNode) {
                    AbstractPsModelNode modelNode = (AbstractPsModelNode)node2;
                    issues = NodeHyperlinkSupport.this.findIssues(modelNode, IssuesByTypeAndTextComparator.INSTANCE);
                    presentation.setTooltip(PsIssueCollectionKt.getTooltipText(issues, false));
                }
                if (NodeHyperlinkSupport.this.myHoveredNode != null && NodeHyperlinkSupport.this.myHoveredNode == node2) {
                    return SimpleTextAttributes.LINK_ATTRIBUTES;
                }
                SimpleTextAttributes textAttributes = super.getSimpleTextAttributes(presentation, color, node2);
                if (!issues.isEmpty()) {
                    PsIssue issue2 = (PsIssue)issues.get(0);
                    Color waveColor = issue2.getSeverity().getColor();
                    textAttributes = textAttributes.derive(8, null, null, waveColor);
                }
                return textAttributes;
            }

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                List issues;
                AbstractPsModelNode<? extends PsModel> modelNode;
                if (NodeHyperlinkSupport.this.myShowIssues && (modelNode = this.findModelNode(value2)) != null && !(issues = NodeHyperlinkSupport.this.findIssues(modelNode, null)).isEmpty()) {
                    modelNode.getPresentation().clearText();
                }
                super.customizeCellRenderer(tree, value2, selected, expanded, leaf, row, hasFocus);
                Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
                if (userObject instanceof CellAppearanceEx) {
                    ((CellAppearanceEx)userObject).customize((SimpleColoredComponent)this);
                }
            }

            @Nullable
            private AbstractPsModelNode<? extends PsModel> findModelNode(@Nullable Object value2) {
                DefaultMutableTreeNode node2;
                Object userObject;
                if (value2 instanceof DefaultMutableTreeNode && (userObject = (node2 = (DefaultMutableTreeNode)value2).getUserObject()) instanceof AbstractPsModelNode) {
                    return (AbstractPsModelNode)userObject;
                }
                return null;
            }
        });
        MouseAdapter mouseListener2 = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Cursor cursor = null;
                Object node2 = NodeHyperlinkSupport.this.getIfHyperlink(e);
                if (node2 != null) {
                    cursor = Cursor.getPredefinedCursor(12);
                }
                NodeHyperlinkSupport.this.setHoveredNode(node2);
                NodeHyperlinkSupport.this.myTree.setCursor(cursor);
            }
        };
        this.myTree.addMouseMotionListener((MouseMotionListener)mouseListener2);
        this.myKeyEventDispatcher = e -> {
            T node2 = null;
            if (e.getID() == 401) {
                Cursor cursor = null;
                if (UiUtil.isMetaOrCtrlKeyPressed(e) && (node2 = (T)this.getNodeUnderMousePointer()) != null) {
                    cursor = Cursor.getPredefinedCursor(12);
                }
                this.setHoveredNode(node2);
                this.myTree.setCursor(cursor);
            } else if (e.getID() == 402) {
                if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
                    this.setHoveredNode(null);
                }
                this.myTree.setCursor(null);
            }
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.myKeyEventDispatcher);
    }

    @NotNull
    private List<PsIssue> findIssues(@NotNull AbstractPsModelNode<? extends PsModel> modelNode, @Nullable Comparator<PsIssue> comparator2) {
        ArrayList issues = Lists.newArrayList();
        PsIssueCollection issueCollection = this.myContext.getAnalyzerDaemon().getIssues();
        for (PsModel model2 : modelNode.getModels()) {
            if (!(model2 instanceof PsChildModel)) continue;
            issues.addAll(issueCollection.findIssues(model2.getPath(), null));
        }
        if (comparator2 != null && issues.size() > 1) {
            Collections.sort(issues, comparator2);
        }
        return issues;
    }

    private void setHoveredNode(@Nullable T node2) {
        this.myHoveredNode = node2;
        if (this.myHoveredNode != null) {
            this.myHoveredNode.getPresentation().clearText();
        }
        this.myTree.repaint();
    }

    @Nullable
    public T getIfHyperlink(@NotNull MouseEvent e) {
        if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
            return this.getNodeForLocation(e.getX(), e.getY());
        }
        return null;
    }

    private T getNodeUnderMousePointer() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point location = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(location, (Component)this.myTree);
            return this.getNodeForLocation(location.x, location.y);
        }
        return null;
    }

    @Nullable
    public T getNodeForLocation(int x, int y) {
        DefaultMutableTreeNode node2;
        Object userObject = null;
        TreePath path2 = this.myTree.getPathForLocation(x, y);
        if (path2 != null && (node2 = (DefaultMutableTreeNode)path2.getLastPathComponent()) != null) {
            userObject = node2.getUserObject();
        }
        return (T)(this.mySupportedNodeType.isInstance(userObject) ? (SimpleNode)this.mySupportedNodeType.cast(userObject) : null);
    }

    public void dispose() {
        if (this.myKeyEventDispatcher != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.myKeyEventDispatcher);
        }
    }
}

