/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.ide.common.gradle.model.IdeLibrary;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.google.common.base.Strings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class ModuleFinder {
    @NotNull
    public static final ModuleFinder EMPTY = new ModuleFinder();
    @NotNull
    private final Map<String, Module> myModulesByGradlePath = new HashMap<String, Module>();
    @NotNull
    private final Map<String, Module> myModulesByModuleId = new HashMap<String, Module>();
    @NotNull
    private final Map<String, File> myIncludedProjectFolderByModuleFolder = new HashMap<String, File>();
    @NotNull
    public static final Key<BuildParticipant> EXTRA_BUILD_PARTICIPANT_FROM_BUILD_SRC = new Key("extra.build.participant.from.build.src");

    private ModuleFinder() {
    }

    public ModuleFinder(@NotNull Project project) {
        this.populateIncludedProjectFolderByModuleFolder(project);
    }

    private void populateIncludedProjectFolderByModuleFolder(@NotNull Project project) {
        this.populateExtraBuildParticipants(project);
        String projectPath = project.getBasePath();
        if (projectPath == null) {
            return;
        }
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)project).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            return;
        }
        for (BuildParticipant participant : compositeBuild.getCompositeParticipants()) {
            this.addBuildParticipant(participant);
        }
    }

    private void populateExtraBuildParticipants(@NotNull Project project) {
        BuildParticipant buildParticipant = (BuildParticipant)project.getUserData(EXTRA_BUILD_PARTICIPANT_FROM_BUILD_SRC);
        if (buildParticipant != null) {
            this.addBuildParticipant(buildParticipant);
        }
    }

    private void addBuildParticipant(BuildParticipant participant) {
        for (String modulePath : participant.getProjects()) {
            String path2 = Strings.nullToEmpty((String)participant.getRootPath());
            this.myIncludedProjectFolderByModuleFolder.put(modulePath, new File(path2));
        }
    }

    public void addModule(@NotNull Module module2, @NotNull String gradlePath) {
        this.myModulesByGradlePath.put(gradlePath, module2);
        File folderPath = this.getProjectRootFolder(module2);
        if (folderPath != null) {
            this.myModulesByModuleId.put(Modules.createUniqueModuleId(folderPath, gradlePath), module2);
        }
    }

    @Nullable
    private File getProjectRootFolder(@NotNull Module module2) {
        String modulePath;
        File moduleFolder = AndroidRootUtil.findModuleRootFolderPath(module2);
        if (moduleFolder != null && this.myIncludedProjectFolderByModuleFolder.containsKey(modulePath = ExternalSystemApiUtil.toCanonicalPath((String)moduleFolder.getPath()))) {
            return this.myIncludedProjectFolderByModuleFolder.get(modulePath);
        }
        return Projects.getBaseDirPath((Project)module2.getProject());
    }

    @Nullable
    public Module findModuleFromLibrary(@NotNull IdeLibrary library) {
        if (library.getType() != IdeLibrary.LibraryType.LIBRARY_MODULE) {
            return null;
        }
        String gradlePath = library.getProjectPath();
        if (StringUtil.isNotEmpty((String)gradlePath)) {
            Module module2 = null;
            String projectFolderPath = library.getBuildId();
            if (StringUtil.isNotEmpty((String)projectFolderPath)) {
                String moduleId = Modules.createUniqueModuleId(projectFolderPath, gradlePath);
                module2 = this.myModulesByModuleId.get(moduleId);
            }
            return module2 != null ? module2 : this.myModulesByGradlePath.get(gradlePath);
        }
        return null;
    }

    @NotNull
    public Path getRootProjectPath(@NotNull Module module2) {
        String canonicalPath;
        File moduleFolder = AndroidRootUtil.findModuleRootFolderPath(module2);
        if (moduleFolder != null && this.myIncludedProjectFolderByModuleFolder.containsKey(canonicalPath = ExternalSystemApiUtil.toCanonicalPath((String)moduleFolder.getPath()))) {
            return this.myIncludedProjectFolderByModuleFolder.get(canonicalPath).toPath();
        }
        String rootPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2);
        if (rootPath != null) {
            return Paths.get(rootPath, new String[0]);
        }
        return Projects.getBaseDirPath((Project)module2.getProject()).toPath();
    }

    public String toString() {
        return "ModuleFinder{myModulesByGradlePath=" + this.myModulesByGradlePath + ", myModulesByModuleId=" + this.myModulesByModuleId + ", myIncludedProjectFolderByModuleFolder=" + this.myIncludedProjectFolderByModuleFolder + '}';
    }

    public static class Factory {
        @NotNull
        public ModuleFinder create(@NotNull Project project) {
            return new ModuleFinder(project);
        }
    }
}

