/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.ide.common.gradle.model.IdeSyncIssue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DisableOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowDependencyInProjectStructureHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowSyncIssuesDetailsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.project.messages.MessageType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class UnresolvedDependenciesReporter
extends SimpleDeduplicatingSyncIssueReporter {
    private static final String UNRESOLVED_DEPENDENCIES_GROUP = "Unresolved dependencies";
    private boolean myAssumeProjectNotInitialized = false;

    @Override
    int getSupportedIssueType() {
        return 2;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        assert (!syncIssues2.isEmpty() && !affectedModules.isEmpty());
        IdeSyncIssue issue2 = syncIssues2.get(0);
        String dependency = issue2.getData();
        ArrayList quickFixes = Lists.newArrayList();
        if (dependency == null) {
            ArrayList<String> extraInfo = new ArrayList<String>();
            try {
                List multiLineMessage = issue2.getMultiLineMessage();
                if (multiLineMessage != null) {
                    extraInfo.addAll(multiLineMessage);
                }
            }
            catch (UnsupportedOperationException multiLineMessage) {
                // empty catch block
            }
            if (!extraInfo.isEmpty()) {
                quickFixes.add(new ShowSyncIssuesDetailsHyperlink(issue2.getMessage(), extraInfo));
            }
            if (GradleProjects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(0, new DisableOfflineModeHyperlink());
            }
        } else {
            GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)dependency);
            List buildFiles = ContainerUtil.map(affectedModules, m -> (VirtualFile)buildFileMap.get(m));
            Module module2 = affectedModules.get(0);
            if (dependency.startsWith("com.android.support") || dependency.startsWith("androidx.") || dependency.startsWith("com.google.android")) {
                this.addGoogleMavenRepositoryHyperlink(project, buildFiles, quickFixes);
            } else if (GradleProjects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(new DisableOfflineModeHyperlink());
            }
            if (IdeInfo.getInstance().isAndroidStudio() && coordinate != null) {
                quickFixes.add(new ShowDependencyInProjectStructureHyperlink(module2, coordinate));
            }
        }
        return quickFixes;
    }

    @Override
    @NotNull
    protected NotificationData setupNotificationData(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues2, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        NotificationData notificationData = super.setupNotificationData(project, syncIssues2, affectedModules, buildFileMap, type);
        notificationData.setTitle(UNRESOLVED_DEPENDENCIES_GROUP);
        String dependency = syncIssues2.get(0).getData();
        if (dependency == null) {
            return notificationData;
        }
        String message2 = "Failed to resolve: " + dependency;
        notificationData.setMessage(message2);
        return notificationData;
    }

    private void addGoogleMavenRepositoryHyperlink(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull List<NotificationHyperlink> fixes) {
        if (!project.isInitialized() || this.myAssumeProjectNotInitialized) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink(project));
            return;
        }
        ProjectBuildModel projectBuildModel2 = ProjectBuildModel.getOrLog(project);
        if (projectBuildModel2 == null) {
            return;
        }
        ArrayList<VirtualFile> filesToFix = new ArrayList<VirtualFile>();
        for (VirtualFile file2 : buildFiles) {
            GradleBuildModel moduleModel;
            if (file2 == null || !file2.isValid() || (moduleModel = projectBuildModel2.getModuleBuildModel(file2)).repositories().hasGoogleMavenRepository()) continue;
            filesToFix.add(file2);
        }
        if (filesToFix.isEmpty()) {
            return;
        }
        GradleBuildModel buildModel = projectBuildModel2.getProjectBuildModel();
        if (buildModel != null && !buildModel.repositories().hasGoogleMavenRepository()) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink((List<VirtualFile>)ImmutableList.of((Object)buildModel.getVirtualFile())));
            return;
        }
        fixes.add(new AddGoogleMavenRepositoryHyperlink(filesToFix));
    }

    @VisibleForTesting
    void assumeProjectNotInitialized(boolean assumeNotInitialized) {
        this.myAssumeProjectNotInitialized = assumeNotInitialized;
    }
}

