/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea.data.service;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.project.sync.idea.data.service.ModuleModelDataService;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.GradleModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;

public class GradleModuleModelDataService
extends ModuleModelDataService<GradleModuleModel> {
    @NotNull
    private final GradleModuleSetup myModuleSetup;

    public GradleModuleModelDataService() {
        this(new GradleModuleSetup());
    }

    @VisibleForTesting
    GradleModuleModelDataService(@NotNull GradleModuleSetup moduleSetup) {
        this.myModuleSetup = moduleSetup;
    }

    @NotNull
    public Key<GradleModuleModel> getTargetDataKey() {
        return AndroidProjectKeys.GRADLE_MODULE_MODEL;
    }

    @Override
    protected void importData(@NotNull Collection<DataNode<GradleModuleModel>> toImport, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Map<String, GradleModuleModel> modelsByModuleName) {
        for (Module module2 : modelsProvider.getModules()) {
            GradleModuleModel gradleModuleModel = modelsByModuleName.get(module2.getName());
            if (gradleModuleModel == null) {
                Facets.removeAllFacets(modelsProvider.getModifiableFacetModel(module2), GradleFacet.getFacetTypeId());
                continue;
            }
            this.myModuleSetup.setUpModule(module2, modelsProvider, gradleModuleModel);
        }
        GradleModuleModelDataService.populateExtraBuildParticipantFromBuildSrc(toImport, project);
    }

    private static void populateExtraBuildParticipantFromBuildSrc(@NotNull Collection<DataNode<GradleModuleModel>> toImport, @NotNull Project project) {
        BuildParticipant participant;
        if (toImport.isEmpty()) {
            return;
        }
        DataNode<ProjectData> projectDataDataNode = GradleModuleModelDataService.findProjectDataNode(toImport.iterator().next());
        if (projectDataDataNode != null && !(participant = GradleModuleModelDataService.getParticipant(projectDataDataNode)).getProjects().isEmpty()) {
            project.putUserData(ModuleFinder.EXTRA_BUILD_PARTICIPANT_FROM_BUILD_SRC, (Object)participant);
        }
    }

    @NotNull
    private static BuildParticipant getParticipant(@NotNull DataNode<ProjectData> projectDataDataNode) {
        BuildParticipant participant = new BuildParticipant();
        participant.setRootProjectName(((ProjectData)projectDataDataNode.getData()).getExternalName());
        for (DataNode moduleNode : ExternalSystemApiUtil.getChildren(projectDataDataNode, (Key)ProjectKeys.MODULE)) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)"true", (CharSequence)((ModuleData)moduleNode.getData()).getProperty("buildSrcModule"))) continue;
            String moduleFolder = ((ModuleData)moduleNode.getData()).getLinkedExternalProjectPath();
            participant.getProjects().add(moduleFolder);
            if (!"buildSrc".equals(((ModuleData)moduleNode.getData()).getExternalName())) continue;
            participant.setRootPath(moduleFolder);
        }
        return participant;
    }

    @Nullable
    private static DataNode<ProjectData> findProjectDataNode(@NotNull DataNode<GradleModuleModel> gradleModuleDataNode) {
        DataNode projectDataNode;
        DataNode moduleDataNode2 = gradleModuleDataNode.getParent();
        if (moduleDataNode2 != null && (projectDataNode = moduleDataNode2.getParent()) != null) {
            return projectDataNode.getDataNode(ProjectKeys.PROJECT);
        }
        return null;
    }
}

