/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.util.PropertiesFiles;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class RemoveSHA256FromGradleWrapperHyperlink
extends NotificationHyperlink {
    public RemoveSHA256FromGradleWrapperHyperlink() {
        super("remove.SHA256.from.gradle.wrapper", "Remove distributionSha256Sum and sync project");
    }

    @Override
    protected void execute(@NotNull Project project) {
        GradleWrapper gradleWrapper = GradleWrapper.find(project);
        if (gradleWrapper != null) {
            File propertiesFilePath = gradleWrapper.getPropertiesFilePath();
            try {
                Properties properties2 = gradleWrapper.getProperties();
                if (properties2.getProperty("distributionSha256Sum") != null) {
                    properties2.remove("distributionSha256Sum");
                    PropertiesFiles.savePropertiesToFile(properties2, propertiesFilePath, null);
                }
            }
            catch (IOException e) {
                Logger.getInstance(this.getClass()).warn("Failed to read file " + propertiesFilePath.getPath());
            }
        }
        GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_DISTRIBUTIONSHA256SUM_REMOVED_FROM_WRAPPER);
    }
}

