/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.facet.gradle;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetType;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleFacet
extends Facet<GradleFacetConfiguration> {
    @NotNull
    private static final FacetTypeId<GradleFacet> TYPE_ID = new FacetTypeId("android-gradle");
    @Nullable
    private GradleModuleModel myGradleModuleModel;

    @Nullable
    public static GradleFacet getInstance(@NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        return (GradleFacet)modelsProvider.getModifiableFacetModel(module2).getFacetByType(TYPE_ID);
    }

    public static boolean isAppliedTo(@NotNull Module module2) {
        return GradleFacet.getInstance(module2) != null;
    }

    @Nullable
    public static GradleFacet getInstance(@NotNull Module module2) {
        return (GradleFacet)FacetManager.getInstance((Module)module2).getFacetByType(GradleFacet.getFacetTypeId());
    }

    public GradleFacet(@NotNull Module module2, @NotNull String name, @NotNull GradleFacetConfiguration configuration) {
        super((FacetType)GradleFacet.getFacetType(), module2, name, (FacetConfiguration)configuration, null);
    }

    @NotNull
    public static GradleFacetType getFacetType() {
        FacetType facetType = FacetTypeRegistry.getInstance().findFacetType(GradleFacet.getFacetId());
        assert (facetType instanceof GradleFacetType);
        return (GradleFacetType)facetType;
    }

    @NotNull
    public static FacetTypeId<GradleFacet> getFacetTypeId() {
        return TYPE_ID;
    }

    @NotNull
    public static String getFacetId() {
        return "android-gradle";
    }

    @NotNull
    public static String getFacetName() {
        return "Android-Gradle";
    }

    public void initFacet() {
        MessageBusConnection connection = this.getModule().getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!GradleFacet.this.isDisposed()) {
                        Project project = GradleFacet.this.getModule().getProject();
                        WriteCommandAction.runWriteCommandAction((Project)project, () -> GradleFacet.this.updateConfiguration());
                    }
                });
            }
        });
        this.updateConfiguration();
    }

    private void updateConfiguration() {
        GradleFacetConfiguration config = (GradleFacetConfiguration)this.getConfiguration();
        try {
            FacetUtil.saveFacetConfiguration((FacetConfiguration)config);
        }
        catch (WriteExternalException e) {
            Logger.getInstance(GradleFacet.class).error("Unable to save contents of 'Android-Gradle' facet", (Throwable)e);
        }
    }

    @Nullable
    public GradleModuleModel getGradleModuleModel() {
        return this.myGradleModuleModel;
    }

    public void setGradleModuleModel(@NotNull GradleModuleModel gradleModuleModel) {
        this.myGradleModuleModel = gradleModuleModel;
        ((GradleFacetConfiguration)this.getConfiguration()).GRADLE_PROJECT_PATH = this.myGradleModuleModel.getGradlePath();
        ((GradleFacetConfiguration)this.getConfiguration()).LAST_KNOWN_AGP_VERSION = this.myGradleModuleModel.getAgpVersion();
    }
}

