/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.output;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmakeOutputParser
implements BuildOutputParser {
    static final String CMAKE = "CMake";
    private static final String ERROR = "Error";
    private static final String CMAKE_ERROR = "CMake Error";
    private final Pattern cmakeErrorOrWarning = Pattern.compile("^\\s*CMake (Error|Warning).+");
    static final Pattern fileAndLineNumber = Pattern.compile("^(([A-Za-z]:)?.*):([0-9]+)? *:([0-9]+)?(.+)?");
    static final Pattern errorFileAndLineNumber = Pattern.compile("CMake (Error|Warning).*at (([A-Za-z]:)?[^:]+):([0-9]+)?.*(\\([^:]*\\))?:([0-9]+)?(.+)?");
    private static final int SOURCE_POSITION_OFFSET = -1;

    public boolean parse(String line2, BuildOutputInstantReader reader, Consumer<? super BuildEvent> messageConsumer) {
        if (this.cmakeErrorOrWarning.matcher(line2).matches()) {
            String nextLine;
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(line2.trim());
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.isEmpty() || this.cmakeErrorOrWarning.matcher(nextLine).matches()) {
                    reader.pushBack();
                    break;
                }
                if ((nextLine = nextLine.trim()).isEmpty()) continue;
                messages.add(nextLine);
            }
            if (CmakeOutputParser.matchesErrorFileAndLineNumberError(messages, reader.getParentEventId(), messageConsumer) || CmakeOutputParser.matchesFileAndLineNumberError(messages, reader.getParentEventId(), messageConsumer)) {
                return true;
            }
            if (((String)messages.get(0)).startsWith(CMAKE_ERROR)) {
                messageConsumer.accept((BuildEvent)new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.ERROR, "CMake errors", String.join((CharSequence)" ", messages), String.join((CharSequence)"\n", messages)));
            } else {
                messageConsumer.accept((BuildEvent)new MessageEventImpl(reader.getParentEventId(), MessageEvent.Kind.WARNING, "CMake warnings", String.join((CharSequence)" ", messages), String.join((CharSequence)"\n", messages)));
            }
            return true;
        }
        return false;
    }

    private static boolean matchesFileAndLineNumberError(List<String> messages, Object buildId, Consumer<? super BuildEvent> messageConsumer) {
        String fullMessage = String.join((CharSequence)" ", messages);
        Matcher matcher = fileAndLineNumber.matcher(fullMessage);
        if (matcher.matches()) {
            File file2 = new File(matcher.group(1));
            ErrorFields fields = CmakeOutputParser.matchFileAndLineNumberErrorParts(matcher, fullMessage);
            fields.kind = fullMessage.contains(CMAKE_ERROR) ? MessageEvent.Kind.ERROR : MessageEvent.Kind.WARNING;
            FilePosition position = new FilePosition(file2, fields.lineNumber + -1, fields.columnNumber + -1);
            messageConsumer.accept((BuildEvent)new FileMessageEventImpl(buildId, fields.kind, CMAKE + (fields.kind == MessageEvent.Kind.ERROR ? " errors" : " warnings"), fields.errorMessage, String.join((CharSequence)"\n", messages), position));
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static ErrorFields matchFileAndLineNumberErrorParts(Matcher matcher, String line2) {
        ErrorFields fields = new ErrorFields();
        fields.lineNumber = -1;
        if (matcher.group(3) != null) {
            fields.lineNumber = Integer.valueOf(matcher.group(3));
        }
        fields.columnNumber = -1;
        if (matcher.group(4) != null) {
            fields.columnNumber = Integer.valueOf(matcher.group(4));
        }
        fields.errorMessage = line2;
        if (matcher.group(5) != null) {
            fields.errorMessage = matcher.group(5);
        }
        return fields;
    }

    private static boolean matchesErrorFileAndLineNumberError(List<String> messages, Object buildId, Consumer<? super BuildEvent> messageConsumer) {
        String fullMessage = String.join((CharSequence)" ", messages);
        Matcher matcher = errorFileAndLineNumber.matcher(fullMessage);
        if (matcher.matches()) {
            File file2 = new File(matcher.group(2));
            ErrorFields fields = CmakeOutputParser.matchErrorFileAndLineNumberErrorParts(matcher, fullMessage);
            FilePosition position = new FilePosition(file2, fields.lineNumber + -1, fields.columnNumber + -1);
            messageConsumer.accept((BuildEvent)new FileMessageEventImpl(buildId, fields.kind, CMAKE + (fields.kind == MessageEvent.Kind.ERROR ? " errors" : " warnings"), fields.errorMessage, String.join((CharSequence)"\n", messages), position));
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static ErrorFields matchErrorFileAndLineNumberErrorParts(Matcher matcher, String line2) {
        ErrorFields fields = new ErrorFields();
        fields.kind = MessageEvent.Kind.WARNING;
        if (matcher.group(1).equals(ERROR)) {
            fields.kind = MessageEvent.Kind.ERROR;
        }
        fields.lineNumber = 0;
        if (matcher.group(4) != null) {
            fields.lineNumber = Integer.valueOf(matcher.group(4));
        }
        fields.columnNumber = 0;
        if (matcher.group(6) != null) {
            fields.columnNumber = Integer.valueOf(matcher.group(6));
        }
        fields.errorMessage = line2;
        if (matcher.group(7) != null) {
            fields.errorMessage = matcher.group(7).trim();
        }
        return fields;
    }

    static class ErrorFields {
        MessageEvent.Kind kind;
        int lineNumber;
        int columnNumber;
        String errorMessage;

        ErrorFields() {
        }
    }
}

