/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionManager;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionUtil;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleToolingApiMemoryUsageFixingProgressListener;
import com.android.tools.idea.gradle.project.build.invoker.NoopExternalSystemTaskNotificationListener;
import com.android.tools.idea.gradle.project.build.invoker.TaskExecutionProgressIndicator;
import com.android.tools.idea.gradle.project.common.AndroidSupportVersionUtilKt;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.project.sync.common.CommandLineArgs;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.android.tools.idea.ui.GuiTestingService;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.VetoableProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import net.jcip.annotations.GuardedBy;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

class GradleTasksExecutorImpl
extends GradleTasksExecutor {
    private static final long ONE_MINUTE_MS = 60000L;
    @NonNls
    private static final String APP_ICON_ID = "compiler";
    private static final String GRADLE_RUNNING_MSG_TITLE = "Gradle Running";
    private static final String PASSWORD_KEY_SUFFIX = ".password=";
    @NotNull
    private final Object myCompletionLock = new Object();
    @NotNull
    private final GradleBuildInvoker.Request myRequest;
    @NotNull
    private final BuildStopper myBuildStopper;
    @GuardedBy(value="myCompletionLock")
    private int myCompletionCounter;
    @NotNull
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private volatile int myErrorCount;
    @NotNull
    private volatile ProgressIndicator myProgressIndicator = new EmptyProgressIndicator();

    GradleTasksExecutorImpl(@NotNull GradleBuildInvoker.Request request, @NotNull BuildStopper buildStopper) {
        super(request.getProject());
        this.myRequest = request;
        this.myBuildStopper = buildStopper;
    }

    @Nullable
    public Task.NotificationInfo getNotificationInfo() {
        return new Task.NotificationInfo(this.myErrorCount > 0 ? "Gradle Invocation (errors)" : "Gradle Invocation (success)", "Gradle Invocation Finished", this.myErrorCount + " Errors", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        this.myProgressIndicator = indicator;
        ProjectManager projectManager = ProjectManager.getInstance();
        Project project = this.myRequest.getProject();
        CloseListener closeListener = new CloseListener();
        projectManager.addProjectManagerListener(project, (ProjectManagerListener)closeListener);
        Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)project)).getCompilationSemaphore();
        boolean acquired = false;
        try {
            try {
                while (!acquired) {
                    acquired = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                    if (!this.myProgressIndicator.isCanceled()) continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.addIndicatorDelegate();
            this.invokeGradleTasks();
        }
        finally {
            try {
                this.myProgressIndicator.stop();
                projectManager.removeProjectManagerListener(project, (ProjectManagerListener)closeListener);
            }
            finally {
                if (acquired) {
                    semaphore.release();
                }
            }
        }
    }

    private void addIndicatorDelegate() {
        if (this.myProgressIndicator instanceof ProgressIndicatorEx) {
            ProgressIndicatorEx indicator = (ProgressIndicatorEx)this.myProgressIndicator;
            indicator.addStateDelegate((ProgressIndicatorEx)new ProgressIndicatorStateDelegate(this.myRequest.getTaskId(), this.myBuildStopper));
        }
    }

    private static void setUpBuildAttributionManager(LongRunningOperation operation, BuildAttributionManager buildAttributionManager, boolean skipIfNull) {
        if (skipIfNull && buildAttributionManager == null) {
            return;
        }
        operation.addProgressListener((ProgressListener)buildAttributionManager, new OperationType[]{OperationType.PROJECT_CONFIGURATION, OperationType.TASK, OperationType.TEST});
        buildAttributionManager.onBuildStart();
    }

    private void invokeGradleTasks() {
        Application application;
        Runnable task2;
        Project project = this.myRequest.getProject();
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(project);
        AtomicReference<Object> model2 = new AtomicReference<Object>(null);
        Function executeTasksFunction = connection -> {
            block56: {
                String testOutput;
                Application application;
                GradleBuildState buildState;
                ExternalSystemTaskNotificationListener taskListener;
                ExternalSystemTaskId id;
                Throwable buildError;
                Stopwatch stopwatch;
                block54: {
                    block55: {
                        BuildAttributionManager finalBuildAttributionManager;
                        File finalAttributionFileDir;
                        stopwatch = Stopwatch.createStarted();
                        BuildAction buildAction = this.myRequest.getBuildAction();
                        boolean isRunBuildAction = buildAction != null;
                        List<String> gradleTasks = this.myRequest.getGradleTasks();
                        String executingTasksText = "Executing tasks: " + gradleTasks + " in project " + this.myRequest.getBuildFilePath().getPath();
                        this.addToEventLog(executingTasksText, MessageType.INFO);
                        final StringBuilder output = new StringBuilder();
                        buildError = null;
                        id = this.myRequest.getTaskId();
                        taskListener = this.getTaskListener();
                        CancellationTokenSource cancellationTokenSource = GradleConnector.newCancellationTokenSource();
                        this.myBuildStopper.register(id, cancellationTokenSource);
                        taskListener.onStart(id, this.myRequest.getBuildFilePath().getPath());
                        taskListener.onTaskOutput(id, executingTasksText + SystemProperties.getLineSeparator() + SystemProperties.getLineSeparator(), true);
                        BuildMode buildMode = BuildSettings.getInstance(this.myProject).getBuildMode();
                        buildState = GradleBuildState.getInstance(this.myProject);
                        buildState.buildStarted(new BuildContext(project, gradleTasks, buildMode));
                        BuildAttributionManager buildAttributionManager = null;
                        boolean enableBuildAttribution = BuildAttributionUtil.isBuildAttributionEnabledForProject(this.myProject);
                        File attributionFileDir = null;
                        try {
                            String logMessage;
                            AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
                            ArrayList commandLineArguments = Lists.newArrayList((Object[])buildConfiguration.getCommandLineOptions());
                            if (!commandLineArguments.contains("--parallel") && CompilerWorkspaceConfiguration.getInstance((Project)project).PARALLEL_COMPILATION) {
                                commandLineArguments.add("--parallel");
                            }
                            commandLineArguments.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
                            AndroidSupportVersionUtilKt.addAndroidSupportVersionArg(commandLineArguments);
                            if (enableBuildAttribution) {
                                attributionFileDir = BuildAttributionUtil.getAgpAttributionFileDir(this.myRequest.getBuildFilePath());
                                commandLineArguments.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.attribution.file.location", (String)attributionFileDir.getAbsolutePath()));
                            }
                            commandLineArguments.addAll(this.myRequest.getCommandLineArguments());
                            if (((Boolean)StudioFlags.USE_DEVELOPMENT_OFFLINE_REPOS.get()).booleanValue() || CommandLineArgs.isInTestingMode()) {
                                GradleInitScripts.getInstance().addLocalMavenRepoInitScriptCommandLineArg(commandLineArguments);
                                GradleUtil.attemptToUseEmbeddedGradle(project);
                            }
                            if ((logMessage = "Build command line options: " + commandLineArguments).contains(PASSWORD_KEY_SUFFIX)) {
                                ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
                                for (String option : commandLineArguments) {
                                    int index2 = option.indexOf(PASSWORD_KEY_SUFFIX);
                                    if (index2 == -1) {
                                        replaced.add(option);
                                        continue;
                                    }
                                    replaced.add(option.substring(0, index2 + PASSWORD_KEY_SUFFIX.length()) + "*********");
                                }
                                logMessage = ((Object)replaced).toString();
                            }
                            GradleTasksExecutorImpl.getLogger().info(logMessage);
                            executionSettings.withVmOptions(this.myRequest.getJvmArguments()).withArguments((Collection)commandLineArguments).withEnvironmentVariables(this.myRequest.getEnv()).passParentEnvs(this.myRequest.isPassParentEnvs());
                            BuildLauncher operation = isRunBuildAction ? connection.action(buildAction) : connection.newBuild();
                            operation.addProgressListener((ProgressListener)new GradleToolingApiMemoryUsageFixingProgressListener(), new OperationType[]{OperationType.TASK});
                            GradleExecutionHelper.prepare((LongRunningOperation)operation, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)new ExternalSystemTaskNotificationListenerAdapter(){

                                public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                                    if (GradleTasksExecutorImpl.this.myBuildStopper.contains(id)) {
                                        taskListener.onStatusChange(event);
                                    }
                                }

                                public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text2, boolean stdOut) {
                                    output.append(text2);
                                    if (GradleTasksExecutorImpl.this.myBuildStopper.contains(id2)) {
                                        taskListener.onTaskOutput(id2, text2, stdOut);
                                    }
                                }
                            }, (ProjectConnection)connection);
                            if (enableBuildAttribution) {
                                buildAttributionManager = (BuildAttributionManager)ServiceManager.getService((Project)this.myProject, BuildAttributionManager.class);
                                GradleTasksExecutorImpl.setUpBuildAttributionManager((LongRunningOperation)operation, buildAttributionManager, ApplicationManager.getApplication().isUnitTestMode());
                            }
                            if (isRunBuildAction) {
                                ((BuildActionExecuter)operation).forTasks(ArrayUtil.toStringArray(gradleTasks));
                            } else {
                                operation.forTasks(ArrayUtil.toStringArray(gradleTasks));
                            }
                            operation.withCancellationToken(cancellationTokenSource.token());
                            if (isRunBuildAction) {
                                model2.set(((BuildActionExecuter)operation).run());
                            } else {
                                operation.run();
                            }
                            buildState.buildFinished(BuildStatus.SUCCESS);
                            taskListener.onSuccess(id);
                            if (buildAttributionManager != null) {
                                buildAttributionManager.onBuildSuccess(attributionFileDir);
                            }
                            application = ApplicationManager.getApplication();
                            if (buildError == null) break block54;
                            if (buildAttributionManager == null) break block55;
                            finalAttributionFileDir = attributionFileDir;
                            finalBuildAttributionManager = buildAttributionManager;
                        }
                        catch (BuildException e) {
                            buildError = e;
                            return buildError;
                        }
                        catch (Throwable e) {
                            String testOutput2;
                            buildError = e;
                            this.handleTaskExecutionError(e);
                            Application application2 = ApplicationManager.getApplication();
                            if (buildError != null) {
                                if (buildAttributionManager != null) {
                                    File finalAttributionFileDir2 = attributionFileDir;
                                    BuildAttributionManager finalBuildAttributionManager2 = buildAttributionManager;
                                    application2.invokeLater(() -> {
                                        if (!project.isDisposed()) {
                                            finalBuildAttributionManager2.onBuildFailure(finalAttributionFileDir2);
                                        }
                                    });
                                }
                                if (GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                                    buildState.buildFinished(BuildStatus.CANCELED);
                                    taskListener.onCancel(id);
                                } else {
                                    buildState.buildFinished(BuildStatus.FAILED);
                                    GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
                                    ExternalSystemException userFriendlyError = projectResolverChain.getUserFriendlyError(null, buildError, this.myRequest.getBuildFilePath().getPath(), null);
                                    taskListener.onFailure(id, (Exception)((Object)userFriendlyError));
                                }
                            }
                            taskListener.onEnd(id);
                            this.myBuildStopper.remove(id);
                            if (GuiTestingService.getInstance().isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput2 = (String)application2.getUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                                application2.putUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                            }
                            application2.invokeLater(() -> this.notifyGradleInvocationCompleted(buildState, stopwatch.elapsed(TimeUnit.MILLISECONDS)));
                            if (!this.getProject().isDisposed()) {
                                ArrayList<Message> buildMessages = new ArrayList<Message>();
                                if (buildError instanceof BuildException) {
                                    String message2 = ExternalSystemApiUtil.buildErrorMessage((Throwable)buildError);
                                    Message msg = new Message(Message.Kind.ERROR, message2, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                                    buildMessages.add(msg);
                                }
                                GradleInvocationResult result2 = new GradleInvocationResult(this.myRequest.getGradleTasks(), buildMessages, buildError, model2.get());
                                RuntimeException error = null;
                                for (GradleBuildInvoker.AfterGradleInvocationTask task2 : GradleBuildInvoker.getInstance(this.getProject()).getAfterInvocationTasks()) {
                                    try {
                                        task2.execute(result2);
                                    }
                                    catch (ProcessCanceledException e2) {
                                    }
                                    catch (RuntimeException e3) {
                                        if (error != null) continue;
                                        error = e3;
                                    }
                                }
                                if (error != null) {
                                    throw error;
                                }
                            }
                            break block56;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            String testOutput3;
                            Application application3 = ApplicationManager.getApplication();
                            if (buildError != null) {
                                if (buildAttributionManager != null) {
                                    File finalAttributionFileDir3 = attributionFileDir;
                                    BuildAttributionManager finalBuildAttributionManager3 = buildAttributionManager;
                                    application3.invokeLater(() -> {
                                        if (!project.isDisposed()) {
                                            finalBuildAttributionManager2.onBuildFailure(finalAttributionFileDir2);
                                        }
                                    });
                                }
                                if (GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                                    buildState.buildFinished(BuildStatus.CANCELED);
                                    taskListener.onCancel(id);
                                } else {
                                    buildState.buildFinished(BuildStatus.FAILED);
                                    GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
                                    ExternalSystemException userFriendlyError = projectResolverChain.getUserFriendlyError(null, buildError, this.myRequest.getBuildFilePath().getPath(), null);
                                    taskListener.onFailure(id, (Exception)((Object)userFriendlyError));
                                }
                            }
                            taskListener.onEnd(id);
                            this.myBuildStopper.remove(id);
                            if (GuiTestingService.getInstance().isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput3 = (String)application3.getUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                                application3.putUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                            }
                            application3.invokeLater(() -> this.notifyGradleInvocationCompleted(buildState, stopwatch.elapsed(TimeUnit.MILLISECONDS)));
                            if (this.getProject().isDisposed()) break block56;
                            ArrayList<Message> buildMessages = new ArrayList<Message>();
                            if (buildError instanceof BuildException) {
                                String message3 = ExternalSystemApiUtil.buildErrorMessage((Throwable)buildError);
                                Message msg = new Message(Message.Kind.ERROR, message3, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                                buildMessages.add(msg);
                            }
                            GradleInvocationResult result3 = new GradleInvocationResult(this.myRequest.getGradleTasks(), buildMessages, buildError, model2.get());
                            RuntimeException error = null;
                            for (GradleBuildInvoker.AfterGradleInvocationTask task3 : GradleBuildInvoker.getInstance(this.getProject()).getAfterInvocationTasks()) {
                                try {
                                    task3.execute(result3);
                                }
                                catch (ProcessCanceledException e) {
                                }
                                catch (RuntimeException e2) {
                                    if (error != null) continue;
                                    error = e2;
                                }
                            }
                            if (error == null) break block56;
                            throw error;
                        }
                        application.invokeLater(() -> {
                            if (!project.isDisposed()) {
                                finalBuildAttributionManager2.onBuildFailure(finalAttributionFileDir2);
                            }
                        });
                    }
                    if (GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                        buildState.buildFinished(BuildStatus.CANCELED);
                        taskListener.onCancel(id);
                    } else {
                        buildState.buildFinished(BuildStatus.FAILED);
                        GradleProjectResolverExtension projectResolverChain = GradleProjectResolver.createProjectResolverChain();
                        ExternalSystemException userFriendlyError = projectResolverChain.getUserFriendlyError(null, buildError, this.myRequest.getBuildFilePath().getPath(), null);
                        taskListener.onFailure(id, (Exception)((Object)userFriendlyError));
                    }
                }
                taskListener.onEnd(id);
                this.myBuildStopper.remove(id);
                if (GuiTestingService.getInstance().isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput = (String)application.getUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                    application.putUserData(GuiTestingService.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                }
                application.invokeLater(() -> this.notifyGradleInvocationCompleted(buildState, stopwatch.elapsed(TimeUnit.MILLISECONDS)));
                if (!this.getProject().isDisposed()) {
                    ArrayList<Message> buildMessages = new ArrayList<Message>();
                    if (buildError instanceof BuildException) {
                        String message4 = ExternalSystemApiUtil.buildErrorMessage((Throwable)buildError);
                        Message msg = new Message(Message.Kind.ERROR, message4, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                        buildMessages.add(msg);
                    }
                    GradleInvocationResult result4 = new GradleInvocationResult(this.myRequest.getGradleTasks(), buildMessages, buildError, model2.get());
                    RuntimeException error = null;
                    for (GradleBuildInvoker.AfterGradleInvocationTask task4 : GradleBuildInvoker.getInstance(this.getProject()).getAfterInvocationTasks()) {
                        try {
                            task4.execute(result4);
                        }
                        catch (ProcessCanceledException processCanceledException) {
                        }
                        catch (RuntimeException e) {
                            if (error != null) continue;
                            error = e;
                        }
                    }
                    if (error != null) {
                        throw error;
                    }
                }
            }
            return null;
        };
        if (GuiTestingService.getInstance().isGuiTestingMode() && (task2 = (Runnable)(application = ApplicationManager.getApplication()).getUserData(GuiTestingService.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY)) != null) {
            application.putUserData(GuiTestingService.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY, null);
            task2.run();
        }
        try {
            this.myHelper.execute(this.myRequest.getBuildFilePath().getPath(), executionSettings, this.myRequest.getTaskId(), this.myRequest.getTaskListener(), null, executeTasksFunction);
        }
        catch (ExternalSystemException e) {
            if (e.getOriginalReason().startsWith("com.intellij.openapi.progress.ProcessCanceledException")) {
                GradleTasksExecutorImpl.getLogger().info("Gradle execution cancelled.", (Throwable)e);
            }
            throw e;
        }
    }

    @NotNull
    private ExternalSystemTaskNotificationListener getTaskListener() {
        ExternalSystemTaskNotificationListener result2 = this.myRequest.getTaskListener();
        if (result2 == null) {
            result2 = new NoopExternalSystemTaskNotificationListener();
        }
        return result2;
    }

    private static boolean wasBuildCanceled(@NotNull Throwable buildError) {
        return GradleUtil.hasCause(buildError, BuildCancelledException.class) || GradleUtil.hasCause(buildError, ProcessCanceledException.class);
    }

    private void handleTaskExecutionError(@NotNull Throwable e) {
        if (this.myProgressIndicator.isCanceled()) {
            GradleTasksExecutorImpl.getLogger().info("Failed to complete Gradle execution. Project may be closing or already closed.", e);
            return;
        }
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
        String error = Strings.nullToEmpty((String)rootCause.getMessage());
        if (error.contains("Build cancelled")) {
            return;
        }
        Runnable showErrorTask = () -> {
            ++this.myErrorCount;
            if (IdeInfo.getInstance().isAndroidStudio() && error.startsWith("Supplied javaHome is not a valid folder")) {
                IdeSdks ideSdks = IdeSdks.getInstance();
                File androidHome = ideSdks.getAndroidSdkPath();
                String androidSdkPath = androidHome != null ? androidHome.getPath() : null;
                SelectSdkDialog selectSdkDialog = new SelectSdkDialog(null, androidSdkPath);
                selectSdkDialog.setModal(true);
                if (selectSdkDialog.showAndGet()) {
                    String jdkHome = selectSdkDialog.getJdkHome();
                    UIUtil.invokeLaterIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> ideSdks.setJdkPath(new File(jdkHome))));
                }
            }
        };
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myRequest.getProject(), (Runnable)showErrorTask);
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleBuildInvoker.class);
    }

    private void notifyGradleInvocationCompleted(@NotNull GradleBuildState buildState, long durationMillis) {
        Project project = this.myRequest.getProject();
        if (!project.isDisposed()) {
            MessageType messageType;
            String statusMsg = this.createStatusMessage(buildState, durationMillis);
            MessageType messageType2 = messageType = this.myErrorCount > 0 ? MessageType.ERROR : MessageType.INFO;
            if (durationMillis > 60000L) {
                BALLOON_NOTIFICATION.createNotification(statusMsg, messageType).notify(project);
            } else {
                this.addToEventLog(statusMsg, messageType);
            }
            GradleTasksExecutorImpl.getLogger().info(statusMsg);
        }
    }

    @NotNull
    private String createStatusMessage(@NotNull GradleBuildState buildState, long durationMillis) {
        String message2 = "Gradle build " + GradleTasksExecutorImpl.formatBuildStatusFromState(buildState);
        if (this.myErrorCount > 0) {
            message2 = message2 + String.format(Locale.US, " with %d error(s)", this.myErrorCount);
        }
        message2 = message2 + " in " + StringUtil.formatDuration((long)durationMillis);
        return message2;
    }

    @NotNull
    private static String formatBuildStatusFromState(@NotNull GradleBuildState state) {
        BuildSummary summary = state.getSummary();
        if (summary != null) {
            switch (summary.getStatus()) {
                case SUCCESS: {
                    return "finished";
                }
                case FAILED: {
                    return "failed";
                }
                case CANCELED: {
                    return "cancelled";
                }
            }
        }
        return "finished";
    }

    private void addToEventLog(@NotNull String message2, @NotNull MessageType type) {
        LOGGING_NOTIFICATION.createNotification(message2, type).notify(this.myProject);
    }

    private void attemptToStopBuild() {
        this.myBuildStopper.attemptToStopBuild(this.myRequest.getTaskId(), this.myProgressIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueAndWaitForCompletion() {
        int counterBefore;
        Object object = this.myCompletionLock;
        synchronized (object) {
            counterBefore = this.myCompletionCounter;
        }
        this.queue();
        object = this.myCompletionLock;
        synchronized (object) {
            while (this.myCompletionCounter <= counterBefore) {
                try {
                    this.myCompletionLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    public void onSuccess() {
        super.onSuccess();
        this.onCompletion();
    }

    public void onCancel() {
        super.onCancel();
        this.onCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompletion() {
        Object object = this.myCompletionLock;
        synchronized (object) {
            ++this.myCompletionCounter;
            this.myCompletionLock.notifyAll();
        }
    }

    private class ProgressIndicatorStateDelegate
    extends TaskExecutionProgressIndicator {
        ProgressIndicatorStateDelegate(@NotNull ExternalSystemTaskId taskId, BuildStopper buildStopper) {
            super(taskId, buildStopper);
        }

        @Override
        void onCancel() {
            this.stopAppIconProgress();
        }

        public void stop() {
            super.stop();
            this.stopAppIconProgress();
        }

        private void stopAppIconProgress() {
            UIUtil.invokeLaterIfNeeded(() -> {
                Project project;
                AppIcon appIcon = AppIcon.getInstance();
                if (appIcon.hideProgress(project = GradleTasksExecutorImpl.this.myRequest.getProject(), (Object)GradleTasksExecutorImpl.APP_ICON_ID)) {
                    if (GradleTasksExecutorImpl.this.myErrorCount > 0) {
                        appIcon.setErrorBadge(project, String.valueOf(GradleTasksExecutorImpl.this.myErrorCount));
                        appIcon.requestAttention(project, true);
                    } else {
                        appIcon.setOkBadge(project, true);
                        appIcon.requestAttention(project, false);
                    }
                }
            });
        }
    }

    private class CloseListener
    implements ContentManagerListener,
    VetoableProjectManagerListener {
        private boolean myIsApplicationExitingOrProjectClosing;
        private boolean myUserAcceptedCancel;

        private CloseListener() {
        }

        public void projectOpened(@NotNull Project project) {
        }

        public boolean canClose(@NotNull Project project) {
            if (!project.equals(GradleTasksExecutorImpl.this.myProject)) {
                return true;
            }
            if (this.shouldPromptUser()) {
                this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                if (!this.myUserAcceptedCancel) {
                    return false;
                }
                GradleTasksExecutorImpl.this.attemptToStopBuild();
                return true;
            }
            return !GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
        }

        public void projectClosing(@NotNull Project project) {
            if (project.equals(GradleTasksExecutorImpl.this.myProject)) {
                this.myIsApplicationExitingOrProjectClosing = true;
            }
        }

        private boolean shouldPromptUser() {
            return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
        }

        private boolean askUserToCancelGradleExecution() {
            String msg = "Gradle is running. Proceed with Project closing?";
            int result2 = Messages.showYesNoDialog((Project)GradleTasksExecutorImpl.this.myProject, (String)msg, (String)GradleTasksExecutorImpl.GRADLE_RUNNING_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            return result2 == 0;
        }
    }
}

