/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.compiler;

import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.util.BuildMode;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;

public class AndroidGradleBuildTargetScopeProvider
extends BuildTargetScopeProvider {
    @NotNull
    public List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> getBuildTargetScopes(@NotNull CompileScope baseScope, @NotNull Project project, boolean forceBuild) {
        GradleProjectInfo gradleProjectInfo = GradleProjectInfo.getInstance(project);
        if (!gradleProjectInfo.isBuildWithGradle()) {
            return Collections.emptyList();
        }
        BuildSettings buildSettings = BuildSettings.getInstance(project);
        String runConfigurationTypeId = (String)baseScope.getUserData(CompilerManager.RUN_CONFIGURATION_TYPE_ID_KEY);
        buildSettings.setRunConfigurationTypeId(runConfigurationTypeId);
        if (baseScope instanceof ProjectCompileScope) {
            BuildMode buildMode;
            BuildMode buildMode2 = buildMode = forceBuild ? BuildMode.REBUILD : BuildMode.ASSEMBLE;
            if (buildSettings.getBuildMode() == null) {
                buildSettings.setBuildMode(buildMode);
            }
            Module[] modulesToBuild = ModuleManager.getInstance((Project)project).getModules();
            buildSettings.setModulesToBuild(modulesToBuild);
        } else if (baseScope instanceof ModuleCompileScope) {
            String userDataString = ((ModuleCompileScope)baseScope).getUserDataString();
            Module[] modulesToBuild = userDataString.contains("RUN_CONFIGURATION") ? baseScope.getAffectedModules() : gradleProjectInfo.getModulesToBuildFromSelection(null);
            buildSettings.setModulesToBuild(modulesToBuild);
            buildSettings.setBuildMode(BuildMode.ASSEMBLE);
        } else if (baseScope instanceof CompositeScope) {
            buildSettings.setModulesToBuild(gradleProjectInfo.getModulesToBuildFromSelection(null));
            buildSettings.setBuildMode(BuildMode.COMPILE_JAVA);
        }
        CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope scope2 = CmdlineProtoUtil.createTargetsScope((String)"android_gradle_build_target_type", Collections.singletonList("android_gradle_build_target"), (boolean)forceBuild);
        return Collections.singletonList(scope2);
    }
}

