/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslExpressionList
extends GradlePropertiesDslElement
implements GradleDslExpression {
    private final boolean myAppendToArgumentListWithOneElement;
    private boolean myShouldBeDeleted;
    private boolean myIsLiteralList;

    public GradleDslExpressionList(@Nullable GradleDslElement parent, @NotNull GradleNameElement name, boolean isLiteralList) {
        super(parent, null, name);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, boolean isLiteralList, @NotNull GradleNameElement name) {
        super(parent, psiElement, name);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, @NotNull GradleNameElement name, boolean appendToArgumentListWithOneElement) {
        super(parent, psiElement, name);
        this.myAppendToArgumentListWithOneElement = appendToArgumentListWithOneElement;
        this.myIsLiteralList = false;
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression2) {
        super.addParsedElement(expression2);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression2) {
        this.setNewElement(expression2);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression2, int index2) {
        this.addNewElementAt(index2, expression2);
    }

    public void removeElement(@NotNull GradleDslElement element2) {
        super.removeProperty(element2);
    }

    public GradleDslExpression getElementAt(int index2) {
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index2 < 0 || index2 > expressions.size()) {
            return null;
        }
        return expressions.get(index2);
    }

    public int findIndexOf(@NotNull GradleDslElement element2) {
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        for (int i2 = 0; i2 < expressions.size(); ++i2) {
            if (!expressions.get(i2).equals(element2)) continue;
            return i2;
        }
        return -1;
    }

    public void replaceExpression(@NotNull GradleDslExpression oldExpression, @NotNull GradleDslExpression newExpression) {
        super.replaceElement(oldExpression, newExpression);
    }

    @NotNull
    public List<GradleDslExpression> getExpressions() {
        return this.getPropertyElements(GradleDslExpression.class);
    }

    @NotNull
    public List<GradleDslSimpleExpression> getSimpleExpressions() {
        return this.getExpressions().stream().filter(e -> e instanceof GradleDslSimpleExpression).map(e -> (GradleDslSimpleExpression)e).collect(Collectors.toList());
    }

    @NotNull
    public <T> List<T> getLiterals(@NotNull Class<T> clazz) {
        return this.getSimpleExpressions().stream().map(e -> e.getValue(clazz)).filter(e -> e != null).collect(Collectors.toList());
    }

    public boolean isLiteralList() {
        return this.myIsLiteralList;
    }

    public boolean isAppendToArgumentListWithOneElement() {
        return this.myAppendToArgumentListWithOneElement;
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslExpressionList(this);
    }

    @Override
    public void delete() {
        this.myShouldBeDeleted = true;
        super.delete();
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslExpressionList(this);
        super.apply();
    }

    @Override
    @Nullable
    public PsiElement getExpression() {
        return this.getPsiElement();
    }

    public boolean shouldBeDeleted() {
        return !this.isLiteralList() || this.myShouldBeDeleted;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        return ContainerUtil.filter(this.getDependencies(), e -> e.isResolved());
    }

    @Override
    public void setParsedElement(@NotNull GradleDslElement element2) {
        assert (element2 instanceof GradleDslExpression);
        super.setParsedElement(element2);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element2) {
        assert (element2 instanceof GradleDslExpression);
        super.addParsedElement(element2);
    }

    @Override
    protected void addParsedResettingElement(@NotNull GradleDslElement element2, @NotNull String propertyToReset) {
        assert (element2 instanceof GradleDslExpression);
        super.addParsedResettingElement(element2, propertyToReset);
    }

    @Override
    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element2) {
        assert (element2 instanceof GradleDslExpression);
        super.addToParsedExpressionList(property2, element2);
    }

    @Override
    @NotNull
    public GradleDslElement setNewElement(@NotNull GradleDslElement newElement) {
        assert (newElement instanceof GradleDslExpression);
        return super.setNewElement(newElement);
    }

    @Override
    public void addNewElementAt(int index2, @NotNull GradleDslElement newElement) {
        assert (newElement instanceof GradleDslExpression);
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index2 > expressions.size()) {
            throw new IndexOutOfBoundsException(index2 + " is out of bounds for size " + expressions.size());
        }
        super.addNewElementAt(index2, newElement);
    }

    @Override
    @NotNull
    public GradleDslElement replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        assert (newElement instanceof GradleDslExpression && oldElement instanceof GradleDslExpression);
        return super.replaceElement(oldElement, newElement);
    }

    @Override
    @NotNull
    public GradleDslExpressionList copy() {
        GradleDslExpressionList listClone = new GradleDslExpressionList(this.myParent, GradleNameElement.copy(this.myName), false);
        for (GradleDslElement element2 : this.getCurrentElements()) {
            GradleDslExpression sourceExpression = (GradleDslExpression)element2;
            GradleDslExpression copiedExpression = sourceExpression.copy();
            listClone.setNewElement(copiedExpression);
        }
        return listClone;
    }
}

