/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.adtimport.actions;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.actions.OpenProjectFileChooserDescriptorWithAsyncIcon;
import com.android.tools.idea.gradle.adtimport.AdtImportProvider;
import com.android.tools.idea.gradle.adtimport.AdtModuleImporter;
import com.android.tools.idea.gradle.adtimport.GradleImport;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.ui.validation.validators.ProjectImportPathValidator;
import com.android.utils.BuildScriptUtil;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.NewWelcomeScreen;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidImportProjectAction
extends AnAction {
    @NonNls
    private static final String LAST_IMPORTED_LOCATION = "last.imported.location";
    private static final Logger LOG = Logger.getInstance(AndroidImportProjectAction.class);
    private static final String WIZARD_TITLE = "Select Eclipse or Gradle Project to Import";
    private static final String WIZARD_DESCRIPTION = "Select your Eclipse project folder, build.gradle or settings.gradle";
    @NonNls
    private static final String ANDROID_NATURE_NAME = "com.android.ide.eclipse.adt.AndroidNature";

    public AndroidImportProjectAction() {
        this("Import Project...");
    }

    public AndroidImportProjectAction(@NotNull String text2) {
        super(text2);
    }

    public void update(@NotNull AnActionEvent e) {
        if (NewWelcomeScreen.isNewWelcomeScreen((AnActionEvent)e)) {
            e.getPresentation().setIcon(AllIcons.ToolbarDecorator.Import);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Disposable wizardDisposable = Disposer.newDisposable();
        try {
            AddModuleWizard wizard = this.selectFileAndCreateWizard(wizardDisposable, e.getProject());
            if (wizard != null && wizard.getStepCount() > 0) {
                if (!wizard.showAndGet()) {
                    return;
                }
                NewProjectUtil.createFromWizard((AbstractProjectWizard)wizard, null);
            }
        }
        catch (ConfigurationException | IOException exception) {
            AndroidImportProjectAction.handleImportException(e.getProject(), (Exception)exception);
        }
        finally {
            Disposer.dispose((Disposable)wizardDisposable);
        }
    }

    private static void handleImportException(@Nullable Project project, @NotNull Exception e) {
        String message2 = String.format("Project import failed: %s", e.getMessage());
        Messages.showErrorDialog((Project)project, (String)message2, (String)"Import Project");
        LOG.error((Throwable)e);
    }

    @NotNull
    protected FileChooserDescriptor createFileChooserDescriptor(Disposable wizardDisposable) {
        final OpenProjectFileChooserDescriptorWithAsyncIcon delegate2 = new OpenProjectFileChooserDescriptorWithAsyncIcon();
        Disposer.register((Disposable)wizardDisposable, (Disposable)delegate2);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, true, true, false, false){

            public Icon getIcon(VirtualFile file2) {
                Icon icon2 = delegate2.getIcon(file2);
                return icon2 == null ? super.getIcon(file2) : icon2;
            }
        };
        descriptor2.setHideIgnored(false);
        descriptor2.setTitle(WIZARD_TITLE);
        descriptor2.setDescription(WIZARD_DESCRIPTION);
        return descriptor2;
    }

    @Nullable
    private AddModuleWizard selectFileAndCreateWizard(Disposable disposable2, @Nullable Project project) throws IOException, ConfigurationException {
        return this.selectFileAndCreateWizard(project, this.createFileChooserDescriptor(disposable2));
    }

    @Nullable
    private AddModuleWizard selectFileAndCreateWizard(@Nullable Project project, @NotNull FileChooserDescriptor descriptor2) throws IOException, ConfigurationException {
        VirtualFile[] files2;
        FileChooserDialog chooser2 = FileChooserFactory.getInstance().createFileChooser(descriptor2, null, null);
        VirtualFile toSelect = null;
        String lastLocation = PropertiesComponent.getInstance().getValue(LAST_IMPORTED_LOCATION);
        if (lastLocation != null) {
            toSelect = LocalFileSystem.getInstance().refreshAndFindFileByPath(lastLocation);
        }
        if ((files2 = chooser2.choose(project, new VirtualFile[]{toSelect})).length == 0) {
            return null;
        }
        VirtualFile file2 = files2[0];
        if (!AndroidImportProjectAction.isSelectedFileValid(project, file2)) {
            return null;
        }
        PropertiesComponent.getInstance().setValue(LAST_IMPORTED_LOCATION, file2.getPath());
        return this.createImportWizard(file2);
    }

    private static boolean isSelectedFileValid(@Nullable Project project, @NotNull VirtualFile file2) {
        ProjectImportPathValidator validator = new ProjectImportPathValidator("project file");
        Validator.Result result2 = validator.validate(VfsUtilCore.virtualToIoFile((VirtualFile)file2));
        if (result2.getSeverity() != Validator.Severity.OK) {
            boolean isError = result2.getSeverity() == Validator.Severity.ERROR;
            Messages.showInfoMessage((Project)project, (String)result2.getMessage(), (String)(isError ? "Cannot Import Project" : "Project Import Warning"));
            if (isError) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected AddModuleWizard createImportWizard(@NotNull VirtualFile file2) throws IOException, ConfigurationException {
        VirtualFile target = AndroidImportProjectAction.findImportTarget(file2);
        VirtualFile targetDir = target.isDirectory() ? target : target.getParent();
        File targetDirFile = VfsUtilCore.virtualToIoFile((VirtualFile)targetDir);
        if (AdtModuleImporter.isAdtProjectLocation(file2)) {
            AndroidImportProjectAction.importAdtProject(file2);
        } else if (GradleImport.isEclipseProjectDir(targetDirFile) && !BuildScriptUtil.findGradleBuildFile((File)targetDirFile).exists() && !ApplicationManager.getApplication().isUnitTestMode()) {
            String message2 = String.format("%1$s is an Eclipse project, but not an Android Eclipse project.\n\nPlease select the directory of an Android Eclipse project(which for example will contain\nan AndroidManifest.xml file) and try again.", file2.getPath());
            Messages.showErrorDialog((String)message2, (String)"Import Project");
        } else if (GradleProjects.canImportAsGradleProject(target)) {
            ProjectUtil.openOrImport((String)target.getPath(), null, (boolean)true);
        } else {
            return AndroidImportProjectAction.importWithExtensions(file2);
        }
        return null;
    }

    @Nullable
    private static AddModuleWizard importWithExtensions(@NotNull VirtualFile file2) {
        List<ProjectImportProvider> available = AndroidImportProjectAction.getImportProvidersForTarget(file2);
        if (available.isEmpty()) {
            Messages.showInfoMessage((Project)null, (String)("Cannot import anything from " + file2.getPath()), (String)"Cannot Import");
            return null;
        }
        String path2 = available.size() == 1 ? available.get(0).getPathToBeImported(file2) : ProjectImportProvider.getDefaultPath((VirtualFile)file2);
        ProjectImportProvider[] availableProviders = available.toArray(new ProjectImportProvider[0]);
        return new AddModuleWizard(null, path2, availableProviders);
    }

    @NotNull
    private static List<ProjectImportProvider> getImportProvidersForTarget(@NotNull VirtualFile file2) {
        VirtualFile target = AndroidImportProjectAction.findImportTarget(file2);
        ArrayList available = Lists.newArrayList();
        for (ProjectImportProvider provider2 : (ProjectImportProvider[])ProjectImportProvider.PROJECT_IMPORT_PROVIDER.getExtensions()) {
            if (!provider2.canImport(target, null)) continue;
            available.add(provider2);
        }
        return available;
    }

    private static void importAdtProject(@NotNull VirtualFile file2) {
        AdtImportProvider adtImportProvider = new AdtImportProvider(true);
        AddModuleWizard wizard = new AddModuleWizard(null, ProjectImportProvider.getDefaultPath((VirtualFile)file2), new ProjectImportProvider[]{adtImportProvider});
        if (wizard.showAndGet()) {
            try {
                AndroidImportProjectAction.doCreate(wizard);
            }
            catch (IOException e) {
                UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((String)e.getMessage(), (String)"Project Initialization Failed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCreate(@NotNull AddModuleWizard wizard) throws IOException {
        ProjectBuilder projectBuilder = wizard.getProjectBuilder();
        try {
            File projectFilePath = new File(wizard.getNewProjectFilePath());
            File projectDirPath = projectFilePath.isDirectory() ? projectFilePath : projectFilePath.getParentFile();
            LOG.assertTrue(projectDirPath != null, (Object)("Cannot create project in '" + projectFilePath + "': no parent file exists"));
            FileUtil.ensureExists((File)projectDirPath);
            if (StorageScheme.DIRECTORY_BASED == wizard.getStorageScheme()) {
                FileUtil.ensureExists((File)new File(projectDirPath, ".idea"));
            }
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
            Project project = projectManager.newProject(wizard.getProjectName(), projectDirPath.getPath(), true, false);
            if (project == null) {
                return;
            }
            if (!unitTestMode) {
                project.save();
            }
            if (projectBuilder != null) {
                if (!projectBuilder.validate(null, project)) {
                    return;
                }
                projectBuilder.commit(project, null, ModulesProvider.EMPTY_MODULES_PROVIDER);
            }
            if (!unitTestMode) {
                project.save();
            }
        }
        finally {
            if (projectBuilder != null) {
                projectBuilder.cleanup();
            }
        }
    }

    @NotNull
    public static VirtualFile findImportTarget(@NotNull VirtualFile file2) {
        VirtualFile gradleTarget = ProjectImportUtil.findGradleTarget(file2);
        if (gradleTarget != null) {
            return gradleTarget;
        }
        VirtualFile eclipseTarget = AndroidImportProjectAction.findEclipseTarget(file2);
        if (eclipseTarget != null) {
            return eclipseTarget;
        }
        return file2;
    }

    @Nullable
    private static VirtualFile findEclipseTarget(@NotNull VirtualFile file2) {
        VirtualFile result2 = null;
        if (file2.isDirectory()) {
            VirtualFile target = ProjectImportUtil.findMatch(file2, ".project");
            if (target != null) {
                result2 = AndroidImportProjectAction.findImportTarget(target);
            }
        } else if (".project".equals(file2.getName()) && AndroidImportProjectAction.hasAndroidNature(file2)) {
            result2 = file2;
        } else if (".classpath".equals(file2.getName())) {
            result2 = AndroidImportProjectAction.findImportTarget(file2.getParent());
        }
        return result2;
    }

    public static boolean hasAndroidNature(@NotNull VirtualFile projectFile) {
        File dotProjectFile = new File(projectFile.getPath());
        try {
            Element naturesElement = JDOMUtil.load((File)dotProjectFile).getChild("natures");
            if (naturesElement != null) {
                List naturesList = naturesElement.getChildren("nature");
                for (Element nature : naturesList) {
                    String natureName = nature.getText();
                    if (!ANDROID_NATURE_NAME.equals(natureName)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LOG.info(String.format("Unable to get natures for Eclipse project file '%1$s", projectFile.getPath()), (Throwable)e);
        }
        return false;
    }
}

