/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontLoader;
import com.android.ide.common.fonts.FontProvider;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.fonts.FontDirectoryDownloadService;
import com.android.tools.idea.fonts.FontDownloadService;
import com.android.tools.idea.fonts.SystemFonts;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DownloadableFontCacheServiceImpl
extends FontLoader
implements DownloadableFontCacheService {
    private static final String FONTS = "fonts";
    private static final String FONT = "font";
    private static final String V1 = "v1";
    private final SystemFonts mySystemFonts;
    private final Map<String, FontDirectoryDownloadService> myDownloadServiceMap = new HashMap<String, FontDirectoryDownloadService>();

    @NotNull
    static DownloadableFontCacheServiceImpl getInstance() {
        return (DownloadableFontCacheServiceImpl)DownloadableFontCacheService.getInstance();
    }

    @Override
    @NotNull
    public List<FontFamily> getSystemFontFamilies() {
        return new ArrayList<FontFamily>(this.mySystemFonts.getFontFamilies());
    }

    @Override
    @Nullable
    public FontFamily getSystemFont(@NotNull String name) {
        return this.mySystemFonts.getFont(name);
    }

    @Override
    @NotNull
    public FontFamily getDefaultSystemFont() {
        return this.mySystemFonts.getFontFamilies().iterator().next();
    }

    @Override
    @Nullable
    public File getCachedMenuFile(@NotNull FontFamily family) {
        String menu = family.getMenu();
        if (menu.isEmpty()) {
            return null;
        }
        if (menu.startsWith("file://")) {
            return new File(menu.substring("file://".length()));
        }
        return this.getCachedFont(family.getProvider().getAuthority(), menu);
    }

    @Nullable
    public File getRelativeCachedMenuFile(@NotNull FontFamily family) {
        String menu = family.getMenu();
        if (!menu.startsWith("https://")) {
            return null;
        }
        return DownloadableFontCacheServiceImpl.getRelativeCachedFont(family.getProvider().getAuthority(), menu);
    }

    @Override
    @Nullable
    public File getCachedFontFile(@NotNull FontDetail font) {
        String fontUrl = font.getFontUrl();
        if (fontUrl.isEmpty()) {
            return null;
        }
        if (fontUrl.startsWith("file://")) {
            return new File(fontUrl.substring("file://".length()));
        }
        return this.getCachedFont(font.getFamily().getProvider().getAuthority(), fontUrl);
    }

    @Nullable
    public File getRelativeFontFile(@NotNull FontDetail font) {
        String fontUrl = font.getFontUrl();
        if (!fontUrl.startsWith("https://")) {
            return null;
        }
        return DownloadableFontCacheServiceImpl.getRelativeCachedFont(font.getFamily().getProvider().getAuthority(), fontUrl);
    }

    @Override
    @Nullable
    @Language(value="XML")
    public String toXml(@NotNull FontFamily family) {
        StringBuilder output = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<font-family xmlns:android=\"http://schemas.android.com/apk/res/android\">");
        boolean hasAnyDownloadedFonts = false;
        for (FontDetail detail : family.getFonts()) {
            int weight;
            File cachedFile = this.getCachedFontFile(detail);
            if (cachedFile == null || !cachedFile.exists()) continue;
            hasAnyDownloadedFonts = true;
            output.append(String.format("<font android:font=\"%s\"", cachedFile.getAbsolutePath()));
            if (detail.getHasExplicitStyle()) {
                output.append(String.format(" android:fontStyle=\"%s\"", detail.getFontStyle()));
            }
            if ((weight = detail.getWeight()) != -1) {
                output.append(String.format(Locale.US, " android:fontWeight=\"%d\"", weight));
            }
            output.append(" />");
        }
        if (!hasAnyDownloadedFonts) {
            return null;
        }
        output.append("</font-family>");
        return output.toString();
    }

    @Override
    public void download(@NotNull FontFamily family) {
        FontDownloadService.download(Collections.singletonList(family), false, null, null);
    }

    @Override
    @Nullable
    public Font loadMenuFont(@NotNull FontFamily fontFamily) {
        File file2 = this.getCachedMenuFile(fontFamily);
        if (file2 != null && file2.exists()) {
            try {
                return Font.createFont(0, file2);
            }
            catch (FontFormatException | IOException ex) {
                Logger.getInstance(DownloadableFontCacheServiceImpl.class).warn("Could not load font: " + fontFamily.getName(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Font loadDetailFont(@NotNull FontDetail fontDetail) {
        File file2 = this.getCachedFontFile(fontDetail);
        if (file2 != null && file2.exists()) {
            try {
                return Font.createFont(0, file2);
            }
            catch (FontFormatException | IOException ex) {
                Logger.getInstance(DownloadableFontCacheServiceImpl.class).warn("Could not load font: " + fontDetail.getFamily().getName(), (Throwable)ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(@Nullable Runnable success2, @Nullable Runnable failure) {
        Collection<FontDirectoryDownloadService> services;
        Iterator<FontDirectoryDownloadService> iterator = this.getLock();
        synchronized (iterator) {
            if (this.updateSdkHome()) {
                this.updateDownloadServices();
            }
            services = this.myDownloadServiceMap.values();
        }
        for (FontDirectoryDownloadService service : services) {
            service.refresh(success2, failure);
        }
    }

    @VisibleForTesting
    DownloadableFontCacheServiceImpl() {
        this.init();
        this.mySystemFonts = new SystemFonts(this);
        instance = this;
    }

    SystemFonts getSystemFonts() {
        return this.mySystemFonts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        File initialSdkHome = this.locateSdkHome();
        if (initialSdkHome == null) {
            initialSdkHome = DownloadableFontCacheServiceImpl.createTempSdk();
        }
        Object object = this.getLock();
        synchronized (object) {
            this.clear(initialSdkHome);
            this.fontsLoaded();
            this.updateDownloadServices();
        }
    }

    @Nullable
    protected File locateSdkHome() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        return sdkHandler.getLocation();
    }

    protected void loadFonts() {
        super.loadFonts();
        if (this.getFontFamilies().isEmpty()) {
            this.loadDirectory(FontProvider.GOOGLE_PROVIDER, FontDirectoryDownloadService.getFallbackResourceUrl(FontProvider.GOOGLE_PROVIDER));
        }
    }

    @Nullable
    private static File createTempSdk() {
        try {
            return FileUtil.createTempDirectory((String)"temp", (String)"sdk");
        }
        catch (IOException ex) {
            Logger.getInstance(DownloadableFontCacheServiceImpl.class).error((Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateSdkHome() {
        Object object = this.getLock();
        synchronized (object) {
            File newSdkHome = this.locateSdkHome();
            File oldSdkHome = this.getSdkHome();
            if (Objects.equals(newSdkHome, oldSdkHome)) {
                return false;
            }
            if (newSdkHome == null) {
                if (oldSdkHome != null && oldSdkHome.getName().startsWith("temp")) {
                    return false;
                }
                newSdkHome = DownloadableFontCacheServiceImpl.createTempSdk();
            }
            this.clear(newSdkHome);
            return true;
        }
    }

    @Nullable
    private File getCachedFont(@NotNull String authority, @NotNull String url) {
        File cachePath = this.getFontPath();
        if (cachePath == null) {
            return null;
        }
        return new File(cachePath, DownloadableFontCacheServiceImpl.getRelativeCachedFont(authority, url).getPath());
    }

    private static File getRelativeCachedFont(@NotNull String authority, @NotNull String menu) {
        File providerPath = new File(authority);
        File fontsPath = new File(providerPath, FONTS);
        File fontPath = new File(fontsPath, DownloadableFontCacheServiceImpl.getChildName(menu, 2, FONT));
        File versionPath = new File(fontPath, DownloadableFontCacheServiceImpl.getChildName(menu, 1, V1));
        return new File(versionPath, DownloadableFontCacheServiceImpl.getChildName(menu, 0, menu));
    }

    @NotNull
    private static String getChildName(@NotNull String menu, int fromLast, @NotNull String defaultName) {
        int lastIndex = menu.length();
        int prevIndex = menu.lastIndexOf(47, lastIndex - 1);
        while (fromLast > 0) {
            lastIndex = prevIndex;
            prevIndex = menu.lastIndexOf(47, lastIndex - 1);
            --fromLast;
        }
        if (prevIndex < 0) {
            return defaultName;
        }
        return menu.substring(prevIndex + 1, lastIndex);
    }

    @NotNull
    static String convertNameToFilename(@NotNull String name) {
        StringBuilder builder2 = new StringBuilder();
        boolean previousUnderscore = true;
        for (char character : name.toCharArray()) {
            if (Character.isUpperCase(character)) {
                builder2.append(Character.toLowerCase(character));
                previousUnderscore = false;
                continue;
            }
            if (Character.isLowerCase(character) || Character.isDigit(character)) {
                builder2.append(character);
                previousUnderscore = false;
                continue;
            }
            if (previousUnderscore) continue;
            builder2.append('_');
            previousUnderscore = true;
        }
        return builder2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDownloadServices() {
        Object object = this.getLock();
        synchronized (object) {
            this.myDownloadServiceMap.clear();
            File fontPath = this.getFontPath();
            if (fontPath != null) {
                for (FontProvider provider2 : this.getProviders().values()) {
                    this.myDownloadServiceMap.put(provider2.getAuthority(), new FontDirectoryDownloadService(this, provider2, fontPath));
                }
            }
        }
    }
}

