/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.folding;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.folding.AndroidFoldingSettings;
import com.android.tools.idea.folding.InlinedResource;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFoldingBuilder
extends FoldingBuilderEx {
    private static final String ANDROID_RESOURCE_INT = "android.annotation.ResourceInt";
    private static final boolean ONLY_FOLD_ANNOTATED_METHODS = false;
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
    public static final String DIMEN_PREFIX = "@dimen/";
    public static final String INTEGER_PREFIX = "@integer/";

    private static boolean isFoldingEnabled() {
        return AndroidFoldingSettings.getInstance().isCollapseAndroidStrings();
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node2) {
        return ResourceFoldingBuilder.isFoldingEnabled();
    }

    public String getPlaceholderText(@NotNull ASTNode node2) {
        String foldLabel;
        InlinedResource string;
        PsiElement element2 = SourceTreeToPsiMap.treeElementToPsi((ASTNode)node2);
        if (element2 != null && (string = ResourceFoldingBuilder.getResolvedString(element2)) != InlinedResource.NONE && (foldLabel = string.getResolvedString()) != null) {
            return foldLabel;
        }
        return element2 != null ? element2.getText() : node2.getText();
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement element2, @NotNull Document document, boolean quick) {
        if (!(element2 instanceof PsiJavaFile) && !(element2 instanceof XmlFile) || quick && !UNIT_TEST_MODE || !ResourceFoldingBuilder.isFoldingEnabled()) {
            return FoldingDescriptor.EMPTY;
        }
        final ArrayList result2 = new ArrayList();
        if (element2 instanceof PsiJavaFile) {
            PsiJavaFile file2 = (PsiJavaFile)element2;
            file2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    InlinedResource inlinedResource = ResourceFoldingBuilder.findJavaExpressionReference(expression2);
                    if (inlinedResource != InlinedResource.NONE) {
                        result2.add(inlinedResource.getDescriptor());
                    }
                    super.visitReferenceExpression(expression2);
                }
            });
        } else {
            XmlFile file3 = (XmlFile)element2;
            file3.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlAttributeValue(XmlAttributeValue value2) {
                    FoldingDescriptor descriptor2;
                    InlinedResource inlinedResource = ResourceFoldingBuilder.findXmlValueReference(value2);
                    if (inlinedResource != InlinedResource.NONE && (descriptor2 = inlinedResource.getDescriptor()) != null) {
                        result2.add(descriptor2);
                    }
                    super.visitXmlAttributeValue(value2);
                }
            });
        }
        return result2.toArray(FoldingDescriptor.EMPTY);
    }

    @NotNull
    private static InlinedResource getResolvedString(PsiElement element2) {
        if (element2 instanceof PsiReferenceExpression) {
            return ResourceFoldingBuilder.findJavaExpressionReference((PsiReferenceExpression)element2);
        }
        if (element2 instanceof XmlAttributeValue) {
            return ResourceFoldingBuilder.findXmlValueReference((XmlAttributeValue)element2);
        }
        if (element2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)element2;
            for (PsiExpression expression2 : call.getArgumentList().getExpressions()) {
                InlinedResource string;
                if (!(expression2 instanceof PsiReferenceExpression) || (string = ResourceFoldingBuilder.findJavaExpressionReference((PsiReferenceExpression)expression2)) == InlinedResource.NONE) continue;
                return string;
            }
        }
        return InlinedResource.NONE;
    }

    @NotNull
    private static InlinedResource findXmlValueReference(XmlAttributeValue element2) {
        String value2 = element2.getValue();
        if (value2.startsWith("@string/")) {
            String name = value2.substring("@string/".length());
            return ResourceFoldingBuilder.createdInlinedResource(ResourceType.STRING, name, (PsiElement)element2);
        }
        if (value2.startsWith(DIMEN_PREFIX)) {
            String name = value2.substring(DIMEN_PREFIX.length());
            return ResourceFoldingBuilder.createdInlinedResource(ResourceType.DIMEN, name, (PsiElement)element2);
        }
        if (value2.startsWith(INTEGER_PREFIX)) {
            String name = value2.substring(INTEGER_PREFIX.length());
            return ResourceFoldingBuilder.createdInlinedResource(ResourceType.INTEGER, name, (PsiElement)element2);
        }
        return InlinedResource.NONE;
    }

    @NotNull
    private static InlinedResource findJavaExpressionReference(PsiReferenceExpression expression2) {
        PsiElement call;
        AndroidPsiUtils.ResourceReferenceType referenceType = AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)expression2);
        if (referenceType != AndroidPsiUtils.ResourceReferenceType.APP) {
            return InlinedResource.NONE;
        }
        ResourceType type = AndroidPsiUtils.getResourceType((PsiElement)expression2);
        if (type == null || type != ResourceType.STRING && type != ResourceType.DIMEN && type != ResourceType.INTEGER && type != ResourceType.PLURALS) {
            return InlinedResource.NONE;
        }
        PsiElement parameterList = expression2.getParent();
        String name = AndroidPsiUtils.getResourceName((PsiElement)expression2);
        if (parameterList instanceof PsiExpressionList && (call = parameterList.getParent()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)call;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName != null && (methodName.equals("getString") || methodName.equals("getText") || methodName.equals("getInteger") || methodName.startsWith("getDimension") || methodName.startsWith("getQuantityString"))) {
                ResourceType resourceType = type;
                return ResourceFoldingBuilder.createdInlinedResource(resourceType, name, (PsiElement)callExpression);
            }
            if (!UNIT_TEST_MODE) {
                // empty if block
            }
        }
        return ResourceFoldingBuilder.createdInlinedResource(type, name, (PsiElement)expression2);
    }

    @Nullable
    private static LocalResourceRepository getAppResources(PsiElement element2) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element2);
        if (module2 == null) {
            return null;
        }
        return ResourceRepositoryManager.getAppResources(module2);
    }

    private static InlinedResource createdInlinedResource(@NotNull ResourceType type, @NotNull String name, @NotNull PsiElement foldElement) {
        ASTNode node2;
        LocalResourceRepository appResources = ResourceFoldingBuilder.getAppResources(foldElement);
        if (appResources != null && appResources.hasResources(ResourceNamespace.TODO(), type, name) && (node2 = foldElement.getNode()) != null) {
            TextRange textRange = foldElement.getTextRange();
            HashSet<Object> dependencies2 = new HashSet<Object>();
            dependencies2.add(foldElement);
            FoldingDescriptor descriptor2 = new FoldingDescriptor(node2, textRange, null, dependencies2);
            InlinedResource inlinedResource = new InlinedResource(type, name, appResources, descriptor2, foldElement);
            dependencies2.add(inlinedResource);
            return inlinedResource;
        }
        return InlinedResource.NONE;
    }

    public static boolean allowsResourceType(@NotNull ResourceType type, @Nullable PsiModifierListOwner owner) {
        if (owner == null) {
            return false;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{ANDROID_RESOURCE_INT});
        Boolean allowed = ResourceFoldingBuilder.allowsResourceType(type, annotation);
        return allowed != null && allowed != false;
    }

    @Nullable
    public static Boolean allowsResourceType(@NotNull ResourceType type, @Nullable PsiAnnotation annotation) {
        if (annotation == null) {
            return null;
        }
        assert (ANDROID_RESOURCE_INT.equals(annotation.getQualifiedName()));
        PsiAnnotationParameterList annotationParameters = annotation.getParameterList();
        for (PsiNameValuePair pair : annotationParameters.getAttributes()) {
            PsiAnnotationMemberValue value2 = pair.getValue();
            if (value2 instanceof PsiReferenceExpression) {
                PsiReferenceExpression expression2 = (PsiReferenceExpression)value2;
                return ResourceFoldingBuilder.allowsResourceType(type, expression2);
            }
            if (!(value2 instanceof PsiArrayInitializerMemberValue)) continue;
            PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)value2;
            for (PsiAnnotationMemberValue v : mv.getInitializers()) {
                Boolean b;
                if (!(v instanceof PsiReferenceExpression) || (b = ResourceFoldingBuilder.allowsResourceType(type, (PsiReferenceExpression)v)) == null) continue;
                return b;
            }
        }
        return null;
    }

    private static Boolean allowsResourceType(ResourceType type, PsiReferenceExpression v) {
        String name = v.getText();
        if (name.equals("all")) {
            return true;
        }
        if (name.equals("none")) {
            return false;
        }
        return type.getName().equalsIgnoreCase(name);
    }
}

