/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.explorer;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.device.fs.DownloadProgress;
import com.android.tools.idea.explorer.DeviceExplorerFileManager;
import com.android.tools.idea.explorer.DeviceExplorerFilesUtils;
import com.android.tools.idea.explorer.DeviceExplorerModel;
import com.android.tools.idea.explorer.DeviceExplorerView;
import com.android.tools.idea.explorer.DeviceExplorerViewListener;
import com.android.tools.idea.explorer.DeviceFileEntryNode;
import com.android.tools.idea.explorer.ErrorNode;
import com.android.tools.idea.explorer.FileTransferOperationTracker;
import com.android.tools.idea.explorer.FileTransferSummary;
import com.android.tools.idea.explorer.FileTransferWorkEstimate;
import com.android.tools.idea.explorer.FileTransferWorkEstimator;
import com.android.tools.idea.explorer.FileTransferWorkEstimatorProgress;
import com.android.tools.idea.explorer.LongRunningOperationTracker;
import com.android.tools.idea.explorer.MyLoadingNode;
import com.android.tools.idea.explorer.adbimpl.AdbPathUtil;
import com.android.tools.idea.explorer.fs.DeviceFileEntry;
import com.android.tools.idea.explorer.fs.DeviceFileSystem;
import com.android.tools.idea.explorer.fs.DeviceFileSystemService;
import com.android.tools.idea.explorer.fs.DeviceFileSystemServiceListener;
import com.android.tools.idea.explorer.fs.DeviceState;
import com.android.tools.idea.explorer.fs.FileTransferProgress;
import com.android.tools.idea.explorer.ui.TreeUtil;
import com.android.utils.FileUtils;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceExplorerController {
    @NotNull
    private static final Logger LOGGER = Logger.getInstance(DeviceExplorerController.class);
    @NotNull
    private static final Key<DeviceExplorerController> KEY = Key.create((String)DeviceExplorerController.class.getName());
    @NotNull
    private static final String DEVICE_EXPLORER_BUSY_MESSAGE = "Device Explorer is busy, please retry later or cancel current operation";
    private static final long FILE_ENTRY_CREATION_TIMEOUT_MILLIS = 10000L;
    private static final long FILE_ENTRY_DELETION_TIMEOUT_MILLIS = 10000L;
    private int myShowLoadingNodeDelayMillis = 200;
    private int myTransferringNodeRepaintMillis = 100;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DeviceExplorerModel myModel;
    @NotNull
    private final DeviceExplorerView myView;
    @NotNull
    private final DeviceFileSystemService<? extends DeviceFileSystem> myService;
    @NotNull
    private final FutureCallbackExecutor myEdtExecutor;
    @NotNull
    private final DeviceExplorerFileManager myFileManager;
    @NotNull
    private final FileTransferWorkEstimator myWorkEstimator;
    @NotNull
    private final Set<DeviceFileEntryNode> myTransferringNodes = new HashSet<DeviceFileEntryNode>();
    @NotNull
    private final Set<DeviceFileEntryNode> myLoadingChildren = new HashSet<DeviceFileEntryNode>();
    @NotNull
    private final Alarm myLoadingNodesAlarms;
    @NotNull
    private final Alarm myTransferringNodesAlarms;
    @NotNull
    private final Alarm myLoadingChildrenAlarms;
    @NotNull
    private final FileOpener myFileOpener;
    @Nullable
    private LongRunningOperationTracker myLongRunningOperationTracker;

    public DeviceExplorerController(@NotNull Project project, @NotNull DeviceExplorerModel model2, @NotNull DeviceExplorerView view, @NotNull DeviceFileSystemService<? extends DeviceFileSystem> service, @NotNull DeviceExplorerFileManager fileManager, @NotNull FileOpener fileOpener, @NotNull Executor edtExecutor2, @NotNull Executor taskExecutor2) {
        this.myProject = project;
        this.myModel = model2;
        this.myView = view;
        this.myService = service;
        this.myEdtExecutor = FutureCallbackExecutor.wrap((Executor)edtExecutor2);
        this.myService.addListener(new ServiceListener());
        this.myView.addListener(new ViewListener());
        this.myFileManager = fileManager;
        this.myWorkEstimator = new FileTransferWorkEstimator((Executor)this.myEdtExecutor, taskExecutor2);
        this.myLoadingNodesAlarms = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myTransferringNodesAlarms = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myLoadingChildrenAlarms = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myFileOpener = fileOpener;
        project.putUserData(KEY, (Object)this);
    }

    @Nullable
    public static DeviceExplorerController getProjectController(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        return (DeviceExplorerController)project.getUserData(KEY);
    }

    @Nullable
    private DefaultTreeModel getTreeModel() {
        return this.myModel.getTreeModel();
    }

    @Nullable
    private DefaultTreeSelectionModel getTreeSelectionModel() {
        return this.myModel.getTreeSelectionModel();
    }

    public void setup() {
        this.myView.setup();
        this.myView.startRefresh("Initializing ADB");
        ListenableFuture<Void> future2 = this.myService.start(() -> AndroidSdkUtils.getAdb(this.myProject));
        this.myEdtExecutor.addListener(future2, this.myView::stopRefresh);
        this.myEdtExecutor.addCallback(future2, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result2) {
                DeviceExplorerController.this.refreshDeviceList();
            }

            public void onFailure(@NotNull Throwable t) {
                DeviceExplorerController.this.myView.reportErrorRelatedToService(DeviceExplorerController.this.myService, "Error initializing ADB", t);
            }
        });
    }

    public void restartService() {
        this.myView.startRefresh("Restarting ADB");
        ListenableFuture<Void> future2 = this.myService.restart(() -> AndroidSdkUtils.getAdb(this.myProject));
        this.myEdtExecutor.addListener(future2, this.myView::stopRefresh);
        this.myEdtExecutor.addCallback(future2, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result2) {
            }

            public void onFailure(@NotNull Throwable t) {
                DeviceExplorerController.this.myView.reportErrorRelatedToService(DeviceExplorerController.this.myService, "Error restarting ADB", t);
            }
        });
    }

    private void refreshDeviceList() {
        this.cancelPendingOperations();
        this.myView.startRefresh("Refreshing list of devices");
        ListenableFuture<List<? extends DeviceFileSystem>> futureDevices = this.myService.getDevices();
        this.myEdtExecutor.addListener(futureDevices, this.myView::stopRefresh);
        this.myEdtExecutor.addCallback(futureDevices, (FutureCallback)new FutureCallback<List<? extends DeviceFileSystem>>(){

            public void onSuccess(@Nullable List<? extends DeviceFileSystem> result2) {
                assert (result2 != null);
                DeviceExplorerController.this.myModel.removeAllDevices();
                result2.forEach(DeviceExplorerController.this.myModel::addDevice);
                if (result2.isEmpty()) {
                    DeviceExplorerController.this.myView.showNoDeviceScreen();
                }
            }

            public void onFailure(@NotNull Throwable t) {
                DeviceExplorerController.this.myModel.removeAllDevices();
                DeviceExplorerController.this.myView.reportErrorRelatedToService(DeviceExplorerController.this.myService, "Error refreshing list of devices", t);
            }
        });
    }

    private void setNoActiveDevice() {
        this.cancelPendingOperations();
        this.myModel.setActiveDevice(null);
        this.myModel.setActiveDeviceTreeModel(null, null, null);
        this.myView.showNoDeviceScreen();
    }

    private void setActiveDevice(@NotNull DeviceFileSystem device) {
        this.cancelPendingOperations();
        this.myModel.setActiveDevice(device);
        this.refreshActiveDevice(device);
    }

    private void deviceStateUpdated(@NotNull DeviceFileSystem device) {
        DeviceState lastKnownState;
        if (!Objects.equals(device, this.myModel.getActiveDevice())) {
            return;
        }
        DeviceState newState = device.getDeviceState();
        if (Objects.equals((Object)newState, (Object)(lastKnownState = this.myModel.getActiveDeviceLastKnownState(device)))) {
            return;
        }
        this.myModel.setActiveDeviceLastKnownState(device);
        this.refreshActiveDevice(device);
    }

    private void refreshActiveDevice(final @NotNull DeviceFileSystem device) {
        if (!Objects.equals(device, this.myModel.getActiveDevice())) {
            return;
        }
        if (device.getDeviceState() != DeviceState.ONLINE) {
            String message2 = device.getDeviceState() == DeviceState.UNAUTHORIZED || device.getDeviceState() == DeviceState.OFFLINE ? "Device is pending authentication: please accept debugging session on the device" : String.format("Device is not online (%s)", new Object[]{device.getDeviceState()});
            this.myView.reportMessageRelatedToDevice(device, message2);
            this.myModel.setActiveDeviceTreeModel(device, null, null);
            return;
        }
        ListenableFuture<DeviceFileEntry> futureRoot = device.getRootDirectory();
        this.myEdtExecutor.addCallback(futureRoot, (FutureCallback)new FutureCallback<DeviceFileEntry>(){

            public void onSuccess(@Nullable DeviceFileEntry result2) {
                assert (result2 != null);
                DeviceFileEntryNode rootNode = new DeviceFileEntryNode(result2);
                DefaultTreeModel model2 = new DefaultTreeModel(rootNode);
                DeviceExplorerController.this.myModel.setActiveDeviceTreeModel(device, model2, new DefaultTreeSelectionModel());
            }

            public void onFailure(@NotNull Throwable t) {
                DeviceExplorerController.this.myModel.setActiveDeviceTreeModel(device, null, null);
                DeviceExplorerController.this.myView.reportErrorRelatedToDevice(device, "Unable to access root directory of device", t);
            }
        });
    }

    private void cancelPendingOperations() {
        this.myLoadingNodesAlarms.cancelAllRequests();
        this.myLoadingChildrenAlarms.cancelAllRequests();
        this.myTransferringNodesAlarms.cancelAllRequests();
        this.myLoadingChildren.clear();
        this.myTransferringNodes.clear();
        if (this.myLongRunningOperationTracker != null) {
            this.myLongRunningOperationTracker.cancel();
        }
    }

    private <T> ListenableFuture<Void> executeFuturesInSequence(@NotNull Iterator<T> iterator, @NotNull Function<T, ListenableFuture<Void>> taskFactory) {
        return this.myEdtExecutor.executeFuturesInSequence(iterator, taskFactory);
    }

    private void startNodeDownload(@NotNull DeviceFileEntryNode node2) {
        this.startNodeTransfer(node2, true);
    }

    private void startNodeUpload(@NotNull DeviceFileEntryNode node2) {
        this.startNodeTransfer(node2, false);
    }

    private void startNodeTransfer(@NotNull DeviceFileEntryNode node2, boolean download) {
        this.myView.startTreeBusyIndicator();
        if (download) {
            node2.setDownloading(true);
        } else {
            node2.setUploading(true);
        }
        if (this.myTransferringNodes.isEmpty()) {
            this.myTransferringNodesAlarms.addRequest((Runnable)new MyTransferringNodesRepaint(), this.myTransferringNodeRepaintMillis);
        }
        this.myTransferringNodes.add(node2);
    }

    private void stopNodeDownload(@NotNull DeviceFileEntryNode node2) {
        this.stopNodeTransfer(node2, true);
    }

    private void stopNodeUpload(@NotNull DeviceFileEntryNode node2) {
        this.stopNodeTransfer(node2, false);
    }

    private void stopNodeTransfer(@NotNull DeviceFileEntryNode node2, boolean download) {
        this.myView.stopTreeBusyIndicator();
        if (download) {
            node2.setDownloading(false);
        } else {
            node2.setUploading(false);
        }
        if (this.getTreeModel() != null) {
            this.getTreeModel().nodeChanged(node2);
        }
        this.myTransferringNodes.remove(node2);
        if (this.myTransferringNodes.isEmpty()) {
            this.myTransferringNodesAlarms.cancelAllRequests();
        }
    }

    private void startLoadChildren(@NotNull DeviceFileEntryNode node2) {
        this.myView.startTreeBusyIndicator();
        if (this.myLoadingChildren.isEmpty()) {
            this.myLoadingChildrenAlarms.addRequest((Runnable)new MyLoadingChildrenRepaint(), this.myTransferringNodeRepaintMillis);
        }
        this.myLoadingChildren.add(node2);
    }

    private void stopLoadChildren(@NotNull DeviceFileEntryNode node2) {
        this.myView.stopTreeBusyIndicator();
        this.myLoadingChildren.remove(node2);
        if (this.myLoadingChildren.isEmpty()) {
            this.myLoadingChildrenAlarms.cancelAllRequests();
        }
    }

    private boolean checkLongRunningOperationAllowed() {
        return this.myLongRunningOperationTracker == null;
    }

    private void registerLongRunningOperation(@NotNull LongRunningOperationTracker tracker) throws Exception {
        if (!this.checkLongRunningOperationAllowed()) {
            throw new Exception(DEVICE_EXPLORER_BUSY_MESSAGE);
        }
        this.myLongRunningOperationTracker = tracker;
        Disposer.register((Disposable)this.myLongRunningOperationTracker, () -> {
            assert (ApplicationManager.getApplication().isDispatchThread());
            this.myLongRunningOperationTracker = null;
        });
    }

    public boolean hasActiveDevice() {
        return this.myModel.getActiveDevice() != null;
    }

    public void setShowLoadingNodeDelayMillis(int showLoadingNodeDelayMillis) {
        this.myShowLoadingNodeDelayMillis = showLoadingNodeDelayMillis;
    }

    public void setTransferringNodeRepaintMillis(int transferringNodeRepaintMillis) {
        this.myTransferringNodeRepaintMillis = transferringNodeRepaintMillis;
    }

    public static interface FileOpener {
        @UiThread
        public void openFile(@NotNull Path var1);

        @UiThread
        public void openFile(@NotNull VirtualFile var1);
    }

    private static class NodeSorting {
        private NodeSorting() {
        }

        @NotNull
        public static Comparator<DeviceFileEntryNode> getEntryNodeComparator() {
            return NodeSorting.getCustomComparator(x -> x.getEntry().getName(), o1 -> o1.getEntry().isDirectory() || o1.isSymbolicLinkToDirectory());
        }

        @NotNull
        public static Comparator<TreeNode> getTreeNodeComparator() {
            return (o1, o2) -> {
                if (o1 instanceof DeviceFileEntryNode && o2 instanceof DeviceFileEntryNode) {
                    return NodeSorting.getEntryNodeComparator().compare((DeviceFileEntryNode)o1, (DeviceFileEntryNode)o2);
                }
                if (o1 instanceof DeviceFileEntryNode) {
                    return 1;
                }
                if (o2 instanceof DeviceFileEntryNode) {
                    return -1;
                }
                return 0;
            };
        }

        @NotNull
        public static <V> Comparator<V> getCustomComparator(@NotNull Function<V, String> nameProvider, @NotNull Predicate<V> isDirectory) {
            return (o1, o2) -> {
                boolean isDir2;
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                boolean isDir1 = isDirectory.test(o1);
                if (isDir1 == (isDir2 = isDirectory.test(o2))) {
                    return StringUtil.compare((String)((String)nameProvider.apply(o1)), (String)((String)nameProvider.apply(o2)), (boolean)true);
                }
                if (isDir1) {
                    return -1;
                }
                return 1;
            };
        }
    }

    private class MyLoadingChildrenRepaint
    implements Runnable {
        private MyLoadingChildrenRepaint() {
        }

        @Override
        public void run() {
            DeviceExplorerController.this.myLoadingChildren.forEach(x -> {
                if (x.getChildCount() == 0) {
                    return;
                }
                TreeNode node2 = x.getFirstChild();
                if (node2 instanceof MyLoadingNode) {
                    MyLoadingNode loadingNode = (MyLoadingNode)((Object)((Object)node2));
                    loadingNode.incTick();
                    if (DeviceExplorerController.this.getTreeModel() != null) {
                        DeviceExplorerController.this.getTreeModel().nodeChanged((TreeNode)((Object)loadingNode));
                    }
                }
            });
            DeviceExplorerController.this.myLoadingChildrenAlarms.addRequest((Runnable)new MyLoadingChildrenRepaint(), DeviceExplorerController.this.myTransferringNodeRepaintMillis);
        }
    }

    private class MyTransferringNodesRepaint
    implements Runnable {
        private MyTransferringNodesRepaint() {
        }

        @Override
        public void run() {
            DeviceExplorerController.this.myTransferringNodes.forEach(x -> {
                x.incTransferringTick();
                if (DeviceExplorerController.this.getTreeModel() != null) {
                    DeviceExplorerController.this.getTreeModel().nodeChanged((TreeNode)x);
                }
            });
            DeviceExplorerController.this.myTransferringNodesAlarms.addRequest((Runnable)new MyTransferringNodesRepaint(), DeviceExplorerController.this.myTransferringNodeRepaintMillis);
        }
    }

    private static class ShowLoadingNodeRequest
    implements Runnable {
        @NotNull
        private DefaultTreeModel myTreeModel;
        @NotNull
        private DeviceFileEntryNode myNode;

        private ShowLoadingNodeRequest(@NotNull DefaultTreeModel treeModel, @NotNull DeviceFileEntryNode node2) {
            this.myTreeModel = treeModel;
            this.myNode = node2;
        }

        @Override
        public void run() {
            this.myNode.setAllowsChildren(true);
            this.myNode.add((MutableTreeNode)((Object)new MyLoadingNode(this.myNode.getEntry())));
            this.myTreeModel.nodeStructureChanged(this.myNode);
        }
    }

    private class ViewListener
    implements DeviceExplorerViewListener {
        private ViewListener() {
        }

        @Override
        public void noDeviceSelected() {
            DeviceExplorerController.this.setNoActiveDevice();
        }

        @Override
        public void deviceSelected(@NotNull DeviceFileSystem device) {
            DeviceExplorerController.this.setActiveDevice(device);
        }

        @Override
        public void openNodesInEditorInvoked(@NotNull List<DeviceFileEntryNode> treeNodes) {
            if (treeNodes.isEmpty()) {
                return;
            }
            if (!DeviceExplorerController.this.checkLongRunningOperationAllowed()) {
                DeviceExplorerController.this.myView.reportErrorRelatedToNode(this.getCommonParentNode(treeNodes), DeviceExplorerController.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            DeviceFileSystem device = DeviceExplorerController.this.myModel.getActiveDevice();
            DeviceExplorerController.this.myEdtExecutor.executeFuturesInSequence(treeNodes.iterator(), treeNode -> {
                if (!Objects.equals(device, DeviceExplorerController.this.myModel.getActiveDevice())) {
                    return Futures.immediateFuture(null);
                }
                if (treeNode.getEntry().isDirectory()) {
                    return Futures.immediateFuture(null);
                }
                if (treeNode.isTransferring()) {
                    DeviceExplorerController.this.myView.reportErrorRelatedToNode((DeviceFileEntryNode)treeNode, "Entry is already downloading or uploading", new RuntimeException());
                    return Futures.immediateFuture(null);
                }
                return DeviceExplorerController.this.myEdtExecutor.transformAsync(treeNode.getEntry().isSymbolicLinkToDirectory(), isSymlinkToDir -> {
                    assert (isSymlinkToDir != null);
                    if (isSymlinkToDir.booleanValue()) {
                        return Futures.immediateFuture(null);
                    }
                    return this.downloadAndOpenFile((DeviceFileEntryNode)treeNode);
                });
            });
        }

        private ListenableFuture<Void> downloadAndOpenFile(DeviceFileEntryNode treeNode) {
            ListenableFuture<Path> futurePath = this.downloadFileEntryToDefaultLocation(treeNode);
            ListenableFuture done = DeviceExplorerController.this.myEdtExecutor.transformAsync(futurePath, path2 -> {
                assert (path2 != null);
                ListenableFuture<VirtualFile> getVirtualFile = DeviceExplorerFilesUtils.findFile(path2);
                return DeviceExplorerController.this.myEdtExecutor.transform(getVirtualFile, virtualFile -> {
                    DeviceExplorerController.this.myFileOpener.openFile((VirtualFile)virtualFile);
                    return null;
                });
            });
            return DeviceExplorerController.this.myEdtExecutor.catching(done, Throwable.class, t -> {
                String message2 = String.format("Error opening contents of device file %s", this.getUserFacingNodeName(treeNode));
                DeviceExplorerController.this.myView.reportErrorRelatedToNode(treeNode, message2, (Throwable)t);
                return null;
            });
        }

        @Nullable
        private DeviceFileEntryNode getTreeNodeFromEntry(DeviceFileEntryNode treeNode, String entryFullPath) {
            TreeNode treeNodeRoot = this.getTreeNodeRoot(treeNode);
            if (!(treeNodeRoot instanceof DeviceFileEntryNode)) {
                return null;
            }
            DeviceFileEntryNode treeRoot = (DeviceFileEntryNode)treeNodeRoot;
            return this.findDeviceFileEntryNodeFromPath(treeRoot, entryFullPath);
        }

        private TreeNode getTreeNodeRoot(TreeNode node2) {
            while (node2.getParent() != null) {
                node2 = node2.getParent();
            }
            return node2;
        }

        @Nullable
        private DeviceFileEntryNode findDeviceFileEntryNodeFromPath(DeviceFileEntryNode root2, String entryFullPath) {
            List<String> pathComponents = AdbPathUtil.getSegments(entryFullPath);
            if (pathComponents.isEmpty()) {
                return root2;
            }
            DeviceFileEntryNode currentNode = root2;
            for (String segment : pathComponents) {
                if ((currentNode = currentNode.findChildEntry(segment)) != null) continue;
                return null;
            }
            return currentNode;
        }

        @UiThread
        @NotNull
        private ListenableFuture<Path> downloadFileEntryToDefaultLocation(@NotNull DeviceFileEntryNode treeNode) {
            Path localPath;
            try {
                localPath = DeviceExplorerController.this.myFileManager.getDefaultLocalPathForEntry(treeNode.getEntry());
            }
            catch (Throwable t) {
                return Futures.immediateFailedFuture((Throwable)t);
            }
            ListenableFuture<FileTransferSummary> futureSave = this.wrapFileTransfer(tracker -> this.addDownloadOperationWork((FileTransferOperationTracker)tracker, treeNode), tracker -> FutureUtils.ignoreResult(this.downloadFileEntry(treeNode, localPath, (FileTransferOperationTracker)tracker)));
            return DeviceExplorerController.this.myEdtExecutor.transform(futureSave, summary -> localPath);
        }

        @Override
        public void saveNodesAsInvoked(@NotNull List<DeviceFileEntryNode> treeNodes) {
            if (treeNodes.isEmpty()) {
                return;
            }
            final DeviceFileEntryNode commonParentNode = this.getCommonParentNode(treeNodes);
            if (!DeviceExplorerController.this.checkLongRunningOperationAllowed()) {
                DeviceExplorerController.this.myView.reportErrorRelatedToNode(commonParentNode, DeviceExplorerController.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            ListenableFuture<FileTransferSummary> futureSummary = treeNodes.size() == 1 ? this.saveSingleNodeAs(treeNodes.get(0)) : this.saveMultiNodesAs(commonParentNode, treeNodes);
            DeviceExplorerController.this.myEdtExecutor.addCallback(futureSummary, (FutureCallback)new FutureCallback<FileTransferSummary>(){

                public void onSuccess(@Nullable FileTransferSummary result2) {
                    assert (result2 != null);
                    ViewListener.this.reportSaveNodesAsSummary(commonParentNode, result2);
                }

                public void onFailure(@NotNull Throwable t) {
                    DeviceExplorerController.this.myView.reportErrorRelatedToNode(commonParentNode, "Error saving file(s) to local file system", t);
                }
            });
        }

        private void reportSaveNodesAsSummary(@NotNull DeviceFileEntryNode node2, @NotNull FileTransferSummary summary) {
            this.reportFileTransferSummary(node2, summary, "downloaded", "downloading");
        }

        @NotNull
        private ListenableFuture<FileTransferSummary> saveSingleNodeAs(@NotNull DeviceFileEntryNode treeNode) {
            Path localFile;
            if (treeNode.getEntry().isDirectory() || treeNode.isSymbolicLinkToDirectory()) {
                Path localDirectory;
                try {
                    localDirectory = this.chooseSaveAsDirectoryPath(treeNode);
                }
                catch (Exception e) {
                    return Futures.immediateFailedFuture((Throwable)e);
                }
                if (localDirectory == null) {
                    return Futures.immediateFailedFuture((Throwable)new CancellationException());
                }
                return this.wrapFileTransfer(tracker -> this.addDownloadOperationWork((FileTransferOperationTracker)tracker, treeNode), tracker -> this.downloadSingleDirectory(treeNode, localDirectory, (FileTransferOperationTracker)tracker));
            }
            try {
                localFile = this.chooseSaveAsFilePath(treeNode);
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            if (localFile == null) {
                return Futures.immediateFailedFuture((Throwable)new CancellationException());
            }
            return this.wrapFileTransfer(tracker -> this.addDownloadOperationWork((FileTransferOperationTracker)tracker, treeNode), tracker -> this.downloadSingleFile(treeNode, localFile, (FileTransferOperationTracker)tracker));
        }

        @NotNull
        private ListenableFuture<FileTransferSummary> saveMultiNodesAs(@NotNull DeviceFileEntryNode commonParentNode, @NotNull List<DeviceFileEntryNode> treeNodes) {
            Path localDirectory;
            assert (!treeNodes.isEmpty());
            try {
                localDirectory = this.chooseSaveAsDirectoryPath(commonParentNode);
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            if (localDirectory == null) {
                return Futures.immediateFailedFuture((Throwable)new CancellationException());
            }
            return this.wrapFileTransfer(tracker -> this.addDownloadOperationWork((FileTransferOperationTracker)tracker, treeNodes), tracker -> DeviceExplorerController.this.executeFuturesInSequence(treeNodes.iterator(), treeNode -> {
                Path nodePath = localDirectory.resolve(treeNode.getEntry().getName());
                return this.downloadSingleNode((DeviceFileEntryNode)treeNode, nodePath, (FileTransferOperationTracker)tracker);
            }));
        }

        @UiThread
        @NotNull
        private ListenableFuture<FileTransferSummary> wrapFileTransfer(@NotNull Function<FileTransferOperationTracker, ListenableFuture<Void>> prepareTransfer, @NotNull Function<FileTransferOperationTracker, ListenableFuture<Void>> performTransfer) {
            FileTransferOperationTracker tracker = new FileTransferOperationTracker(DeviceExplorerController.this.myView);
            try {
                DeviceExplorerController.this.registerLongRunningOperation(tracker);
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            tracker.start();
            tracker.setCalculatingText(0, 0);
            tracker.setIndeterminate(true);
            Disposer.register((Disposable)DeviceExplorerController.this.myProject, (Disposable)tracker);
            DeviceExplorerController.this.myView.startTreeBusyIndicator();
            ListenableFuture<Void> futurePrepare = prepareTransfer.apply(tracker);
            ListenableFuture futureTransfer = DeviceExplorerController.this.myEdtExecutor.transformAsync(futurePrepare, aVoid -> {
                tracker.setIndeterminate(false);
                return (ListenableFuture)performTransfer.apply(tracker);
            });
            DeviceExplorerController.this.myEdtExecutor.addListener(futureTransfer, DeviceExplorerController.this.myView::stopTreeBusyIndicator);
            DeviceExplorerController.this.myEdtExecutor.addListener(futureTransfer, () -> Disposer.dispose((Disposable)tracker));
            return DeviceExplorerController.this.myEdtExecutor.transform(futureTransfer, aVoid -> tracker.getSummary());
        }

        public ListenableFuture<Void> addUploadOperationWork(@NotNull FileTransferOperationTracker tracker, @NotNull List<Path> files2) {
            return DeviceExplorerController.this.executeFuturesInSequence(files2.iterator(), x -> this.addUploadOperationWork(tracker, (Path)x));
        }

        public ListenableFuture<Void> addUploadOperationWork(@NotNull FileTransferOperationTracker tracker, @NotNull Path path2) {
            FileTransferWorkEstimatorProgress progress = this.createFileTransferEstimatorProgress(tracker);
            ListenableFuture<FileTransferWorkEstimate> futureWork = DeviceExplorerController.this.myWorkEstimator.estimateUploadWork(path2, progress);
            return DeviceExplorerController.this.myEdtExecutor.transform(futureWork, work -> {
                assert (work != null);
                tracker.addWorkEstimate((FileTransferWorkEstimate)work);
                return null;
            });
        }

        public ListenableFuture<Void> addDownloadOperationWork(@NotNull FileTransferOperationTracker tracker, @NotNull List<DeviceFileEntryNode> entryNodes) {
            return DeviceExplorerController.this.executeFuturesInSequence(entryNodes.iterator(), node2 -> this.addDownloadOperationWork(tracker, (DeviceFileEntryNode)node2));
        }

        public ListenableFuture<Void> addDownloadOperationWork(@NotNull FileTransferOperationTracker tracker, @NotNull DeviceFileEntryNode entryNode) {
            FileTransferWorkEstimatorProgress progress = this.createFileTransferEstimatorProgress(tracker);
            ListenableFuture<FileTransferWorkEstimate> futureEstimate = DeviceExplorerController.this.myWorkEstimator.estimateDownloadWork(entryNode.getEntry(), entryNode.isSymbolicLinkToDirectory(), progress);
            return DeviceExplorerController.this.myEdtExecutor.transform(futureEstimate, estimate -> {
                assert (estimate != null);
                tracker.addWorkEstimate((FileTransferWorkEstimate)estimate);
                return null;
            });
        }

        @NotNull
        private FileTransferWorkEstimatorProgress createFileTransferEstimatorProgress(final @NotNull FileTransferOperationTracker tracker) {
            return new FileTransferWorkEstimatorProgress(){

                @Override
                public void progress(int fileCount2, int directoryCount) {
                    tracker.setCalculatingText(fileCount2, directoryCount);
                }

                @Override
                public boolean isCancelled() {
                    return tracker.isCancelled();
                }
            };
        }

        @NotNull
        private ListenableFuture<Void> downloadSingleNode(@NotNull DeviceFileEntryNode node2, @NotNull Path localPath, @NotNull FileTransferOperationTracker tracker) {
            if (node2.getEntry().isDirectory()) {
                return this.downloadSingleDirectory(node2, localPath, tracker);
            }
            return this.downloadSingleFile(node2, localPath, tracker);
        }

        @NotNull
        private ListenableFuture<Void> downloadSingleFile(@NotNull DeviceFileEntryNode treeNode, @NotNull Path localPath, @NotNull FileTransferOperationTracker tracker) {
            assert (!treeNode.getEntry().isDirectory());
            if (treeNode.isTransferring()) {
                tracker.addProblem(new Exception(String.format("File %s is already downloading or uploading", this.getUserFacingNodeName(treeNode))));
                return Futures.immediateFuture(null);
            }
            ListenableFuture<Long> futureEntrySize = this.downloadFileEntry(treeNode, localPath, tracker);
            SettableFuture futureResult = SettableFuture.create();
            DeviceExplorerController.this.myEdtExecutor.addConsumer(futureEntrySize, (byteCount, throwable) -> {
                if (throwable != null) {
                    tracker.addProblem(new Exception(String.format("Error saving contents of device file %s", this.getUserFacingNodeName(treeNode)), (Throwable)throwable));
                } else {
                    tracker.getSummary().addFileCount(1);
                    tracker.getSummary().addByteCount((long)byteCount);
                }
                futureResult.set(null);
            });
            return futureResult;
        }

        @NotNull
        private ListenableFuture<Void> downloadSingleDirectory(final @NotNull DeviceFileEntryNode treeNode, final @NotNull Path localDirectoryPath, final @NotNull FileTransferOperationTracker tracker) {
            assert (treeNode.getEntry().isDirectory() || treeNode.isSymbolicLinkToDirectory());
            if (tracker.isCancelled()) {
                return Futures.immediateCancelledFuture();
            }
            tracker.processDirectory();
            try {
                FileUtils.mkdirs((File)localDirectoryPath.toFile());
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            tracker.getSummary().addDirectoryCount(1);
            final SettableFuture futureResult = SettableFuture.create();
            ListenableFuture<Void> futureLoadChildren = this.loadNodeChildren(treeNode);
            DeviceExplorerController.this.myEdtExecutor.addCallback(futureLoadChildren, (FutureCallback)new FutureCallback<Void>(){

                public void onSuccess(@Nullable Void result2) {
                    ListenableFuture futureDownloadChildren = DeviceExplorerController.this.executeFuturesInSequence(treeNode.getChildEntryNodes().iterator(), node2 -> {
                        Path nodePath = localDirectoryPath.resolve(node2.getEntry().getName());
                        return ViewListener.this.downloadSingleNode(node2, nodePath, tracker);
                    });
                    DeviceExplorerController.this.myEdtExecutor.addConsumer(futureDownloadChildren, (aVoid, throwable) -> {
                        if (throwable != null) {
                            tracker.addProblem((Throwable)throwable);
                        }
                        futureResult.set(null);
                    });
                }

                public void onFailure(@NotNull Throwable t) {
                    tracker.addProblem(t);
                    futureResult.set(null);
                }
            });
            return futureResult;
        }

        @Override
        public void copyNodePathsInvoked(@NotNull List<DeviceFileEntryNode> treeNodes) {
            String text2 = treeNodes.stream().map(x -> x.getEntry().getFullPath()).collect(Collectors.joining("\n"));
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
        }

        @Override
        public void newFileInvoked(@NotNull DeviceFileEntryNode parentTreeNode) {
            this.newFileOrDirectory(parentTreeNode, "NewTextFile.txt", UIBundle.message((String)"new.file.dialog.title", (Object[])new Object[0]), UIBundle.message((String)"create.new.file.enter.new.file.name.prompt.text", (Object[])new Object[0]), UIBundle.message((String)"create.new.file.file.name.cannot.be.empty.error.message", (Object[])new Object[0]), x -> UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{x}), x -> parentTreeNode.getEntry().createNewFile((String)x));
        }

        @Override
        public void synchronizeNodesInvoked(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes.isEmpty()) {
                return;
            }
            Set directoryNodes = nodes.stream().map(x -> {
                if (x.isSymbolicLinkToDirectory() || x.getEntry().isDirectory()) {
                    return x;
                }
                return DeviceFileEntryNode.fromNode(x.getParent());
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            directoryNodes = directoryNodes.stream().flatMap(node2 -> {
                ArrayList<DeviceFileEntryNode> nodesToSynchronize = new ArrayList<DeviceFileEntryNode>();
                Stack<DeviceFileEntryNode> stack = new Stack<DeviceFileEntryNode>();
                stack.push((DeviceFileEntryNode)node2);
                while (!stack.isEmpty()) {
                    DeviceFileEntryNode currentNode = (DeviceFileEntryNode)stack.pop();
                    nodesToSynchronize.add(currentNode);
                    currentNode.getChildEntryNodes().stream().filter(x -> x.getEntry().isDirectory() || x.isSymbolicLinkToDirectory()).filter(DeviceFileEntryNode::isLoaded).forEach(stack::push);
                }
                return nodesToSynchronize.stream();
            }).collect(Collectors.toSet());
            DeviceExplorerController.this.myView.startTreeBusyIndicator();
            ListenableFuture futuresRefresh = DeviceExplorerController.this.executeFuturesInSequence(directoryNodes.iterator(), treeNode -> {
                treeNode.setLoaded(false);
                return this.loadNodeChildren((DeviceFileEntryNode)treeNode);
            });
            DeviceExplorerController.this.myEdtExecutor.addListener(futuresRefresh, DeviceExplorerController.this.myView::stopTreeBusyIndicator);
        }

        @Override
        public void deleteNodesInvoked(@NotNull List<DeviceFileEntryNode> nodes) {
            if (nodes.isEmpty()) {
                return;
            }
            if (!DeviceExplorerController.this.checkLongRunningOperationAllowed()) {
                DeviceExplorerController.this.myView.reportErrorRelatedToNode(this.getCommonParentNode(nodes), DeviceExplorerController.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            List fileEntries = ContainerUtil.map(nodes, DeviceFileEntryNode::getEntry);
            String message2 = this.createDeleteConfirmationMessage(fileEntries);
            int returnValue = Messages.showOkCancelDialog((String)message2, (String)UIBundle.message((String)"delete.dialog.title", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            if (returnValue != 0) {
                return;
            }
            fileEntries.sort(Comparator.comparing(DeviceFileEntry::getFullPath));
            LinkedList<String> problems = new LinkedList<String>();
            for (DeviceFileEntry fileEntry : fileEntries) {
                ListenableFuture<Void> futureDelete = fileEntry.delete();
                try {
                    futureDelete.get(10000L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable t) {
                    LOGGER.info(String.format("Error deleting file \"%s\"", fileEntry.getFullPath()), t);
                    String problemMessage = ExceptionUtil.getRootCause((Throwable)t).getMessage();
                    if (StringUtil.isEmpty((String)problemMessage)) {
                        problemMessage = "Error deleting file";
                    }
                    problemMessage = String.format("%s: %s", fileEntry.getFullPath(), problemMessage);
                    problems.add(problemMessage);
                }
            }
            if (!problems.isEmpty()) {
                this.reportDeletionProblem(problems);
            }
            Set parentsToRefresh = nodes.stream().map(x -> DeviceFileEntryNode.fromNode(x.getParent())).filter(Objects::nonNull).collect(Collectors.toSet());
            DeviceExplorerController.this.executeFuturesInSequence(parentsToRefresh.iterator(), parentNode -> {
                parentNode.setLoaded(false);
                return this.loadNodeChildren((DeviceFileEntryNode)parentNode);
            });
        }

        private void reportDeletionProblem(@NotNull List<String> problems) {
            if (problems.size() == 1) {
                Messages.showMessageDialog((String)("Could not erase file or folder:\n" + problems.get(0)), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
                return;
            }
            boolean more = false;
            if (problems.size() > 10) {
                problems = problems.subList(0, 10);
                more = true;
            }
            Messages.showMessageDialog((String)("Could not erase files or folders:\n  " + StringUtil.join(problems, (String)",\n  ") + (more ? "\n  ..." : "")), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }

        private String createDeleteConfirmationMessage(@NotNull List<DeviceFileEntry> filesToDelete) {
            if (filesToDelete.size() == 1) {
                if (filesToDelete.get(0).isDirectory()) {
                    return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folder.confirmation.message", (Object[])new Object[]{filesToDelete.get(0).getName()});
                }
                return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.file.confirmation.message", (Object[])new Object[]{filesToDelete.get(0).getName()});
            }
            boolean hasFiles = false;
            boolean hasFolders = false;
            for (DeviceFileEntry file2 : filesToDelete) {
                boolean isDirectory = file2.isDirectory();
                hasFiles |= !isDirectory;
                hasFolders |= isDirectory;
            }
            if (hasFiles && hasFolders) {
                return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.directories.confirmation.message", (Object[])new Object[]{filesToDelete.size()});
            }
            if (hasFolders) {
                return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.folders.confirmation.message", (Object[])new Object[]{filesToDelete.size()});
            }
            return UIBundle.message((String)"are.you.sure.you.want.to.delete.selected.files.and.files.confirmation.message", (Object[])new Object[]{filesToDelete.size()});
        }

        @Override
        public void newDirectoryInvoked(@NotNull DeviceFileEntryNode parentTreeNode) {
            this.newFileOrDirectory(parentTreeNode, "NewFolder", UIBundle.message((String)"new.folder.dialog.title", (Object[])new Object[0]), UIBundle.message((String)"create.new.folder.enter.new.folder.name.prompt.text", (Object[])new Object[0]), UIBundle.message((String)"create.new.folder.folder.name.cannot.be.empty.error.message", (Object[])new Object[0]), x -> UIBundle.message((String)"create.new.folder.could.not.create.folder.error.message", (Object[])new Object[]{x}), x -> parentTreeNode.getEntry().createNewDirectory((String)x));
        }

        private void newFileOrDirectory(@NotNull DeviceFileEntryNode parentTreeNode, @NotNull String initialName, @NotNull String title, @NotNull String prompt, final @NotNull String emptyErrorMessage, @NotNull Function<String, String> errorMessage, @NotNull Function<String, ListenableFuture<Void>> createFunction) {
            DefaultTreeModel treeModel = DeviceExplorerController.this.getTreeModel();
            if (treeModel == null) {
                return;
            }
            while (true) {
                String newFileName;
                if ((newFileName = Messages.showInputDialog((String)prompt, (String)title, (Icon)Messages.getQuestionIcon(), (String)initialName, (InputValidator)new InputValidatorEx(){

                    @Nullable
                    public String getErrorText(String inputString) {
                        if (StringUtil.isEmpty((String)inputString.trim())) {
                            return emptyErrorMessage;
                        }
                        if (inputString.contains("/")) {
                            return "Path cannot contain \"/\" characters";
                        }
                        return null;
                    }

                    public boolean checkInput(String inputString) {
                        return this.canClose(inputString);
                    }

                    public boolean canClose(String inputString) {
                        return !StringUtil.isEmpty((String)inputString.trim());
                    }
                })) == null) {
                    return;
                }
                ListenableFuture<Void> futureResult = createFunction.apply(newFileName);
                try {
                    futureResult.get(10000L, TimeUnit.MILLISECONDS);
                    parentTreeNode.setLoaded(false);
                    ListenableFuture<Void> futureLoad = this.loadNodeChildren(parentTreeNode);
                    DeviceExplorerController.this.myEdtExecutor.addListener(futureLoad, () -> DeviceExplorerController.this.myView.expandNode(parentTreeNode));
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    this.showErrorMessage(errorMessage.apply(newFileName), e);
                    initialName = newFileName;
                    continue;
                }
                break;
            }
        }

        private void showErrorMessage(@NotNull String message2, @NotNull Throwable error) {
            if (error instanceof ExecutionException && error.getCause() != null) {
                error = error.getCause();
            }
            if (error.getMessage() != null) {
                message2 = message2 + ":\n" + error.getMessage();
            }
            Messages.showMessageDialog((String)message2, (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }

        @Override
        public void uploadFilesInvoked(final @NotNull DeviceFileEntryNode treeNode) {
            if (!DeviceExplorerController.this.checkLongRunningOperationAllowed()) {
                DeviceExplorerController.this.myView.reportErrorRelatedToNode(treeNode, DeviceExplorerController.DEVICE_EXPLORER_BUSY_MESSAGE, new RuntimeException());
                return;
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
            AtomicReference filesRef = new AtomicReference();
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)DeviceExplorerController.this.myProject, null, filesRef::set);
            if (filesRef.get() == null || ((List)filesRef.get()).isEmpty()) {
                return;
            }
            ListenableFuture<FileTransferSummary> futureSummary = this.wrapFileTransfer(tracker -> {
                List<Path> paths = ((List)filesRef.get()).stream().map(x -> Paths.get(x.getPath(), new String[0])).collect(Collectors.toList());
                return this.addUploadOperationWork((FileTransferOperationTracker)tracker, paths);
            }, tracker -> this.uploadVirtualFiles(treeNode, (List)filesRef.get(), (FileTransferOperationTracker)tracker));
            DeviceExplorerController.this.myEdtExecutor.addCallback(futureSummary, (FutureCallback)new FutureCallback<FileTransferSummary>(){

                public void onSuccess(@Nullable FileTransferSummary result2) {
                    assert (result2 != null);
                    ViewListener.this.reportUploadFilesSummary(treeNode, result2);
                }

                public void onFailure(@NotNull Throwable t) {
                    DeviceExplorerController.this.myView.reportErrorRelatedToNode(treeNode, "Error uploading files(s) to device", t);
                }
            });
        }

        private void reportUploadFilesSummary(@NotNull DeviceFileEntryNode treeNode, @NotNull FileTransferSummary summary) {
            this.reportFileTransferSummary(treeNode, summary, "uploaded", "uploading");
        }

        private ListenableFuture<Void> uploadVirtualFiles(@NotNull DeviceFileEntryNode parentNode, @NotNull List<VirtualFile> files2, @NotNull FileTransferOperationTracker tracker) {
            ListenableFuture futureUploadFiles = DeviceExplorerController.this.executeFuturesInSequence(files2.iterator(), file2 -> this.uploadVirtualFile(parentNode, (VirtualFile)file2, tracker));
            return DeviceExplorerController.this.myEdtExecutor.transformAsync(futureUploadFiles, aVoid -> {
                parentNode.setLoaded(false);
                return this.loadNodeChildren(parentNode);
            });
        }

        @NotNull
        private ListenableFuture<Void> uploadVirtualFile(@NotNull DeviceFileEntryNode treeNode, @NotNull VirtualFile file2, @NotNull FileTransferOperationTracker tracker) {
            if (file2.isDirectory()) {
                return this.uploadDirectory(treeNode, file2, tracker);
            }
            return this.uploadFile(treeNode, file2, tracker);
        }

        @NotNull
        private ListenableFuture<Void> uploadDirectory(final @NotNull DeviceFileEntryNode parentNode, final @NotNull VirtualFile file2, final @NotNull FileTransferOperationTracker tracker) {
            if (tracker.isCancelled()) {
                return Futures.immediateCancelledFuture();
            }
            tracker.processDirectory();
            tracker.getSummary().addDirectoryCount(1);
            final SettableFuture futureResult = SettableFuture.create();
            DeviceFileEntry parentEntry = parentNode.getEntry();
            final String directoryName = file2.getName();
            ListenableFuture<Void> futureDirectory = parentEntry.createNewDirectory(directoryName);
            DeviceExplorerController.this.myEdtExecutor.addConsumer(futureDirectory, (aVoid, createDirectoryError) -> {
                parentNode.setLoaded(false);
                ListenableFuture<Void> futureLoadChildren = this.loadNodeChildren(parentNode);
                DeviceExplorerController.this.myEdtExecutor.addCallback(futureLoadChildren, (FutureCallback)new FutureCallback<Void>(){

                    public void onSuccess(@Nullable Void result2) {
                        DeviceFileEntryNode childNode = parentNode.findChildEntry(directoryName);
                        if (childNode == null) {
                            if (createDirectoryError != null) {
                                tracker.addProblem(createDirectoryError);
                            } else {
                                tracker.addProblem(new Exception(String.format("Error creating directory \"%s\"", directoryName)));
                            }
                            futureResult.set(null);
                            return;
                        }
                        List childFiles = Arrays.stream(file2.getChildren()).filter(x -> !x.getName().startsWith(".")).collect(Collectors.toList());
                        ListenableFuture futureFileUploads = ViewListener.this.uploadVirtualFiles(childNode, childFiles, tracker);
                        DeviceExplorerController.this.myEdtExecutor.addListener(futureFileUploads, () -> futureResult.set(null));
                    }

                    public void onFailure(@NotNull Throwable t) {
                        tracker.addProblem(t);
                        futureResult.set(null);
                    }
                });
            });
            return futureResult;
        }

        @NotNull
        private ListenableFuture<Void> uploadFile(final @NotNull DeviceFileEntryNode parentNode, final @NotNull VirtualFile file2, final @NotNull FileTransferOperationTracker tracker) {
            if (tracker.isCancelled()) {
                return Futures.immediateCancelledFuture();
            }
            tracker.processFile();
            tracker.setUploadFileText(file2, 0L, 0L);
            SettableFuture futureResult = SettableFuture.create();
            this.logFuture((ListenableFuture)futureResult, millis -> String.format(Locale.US, "Uploaded file in %,d msec: %s", millis, AdbPathUtil.resolve(parentNode.getEntry().getFullPath(), file2.getName())));
            DeviceFileEntry parentEntry = parentNode.getEntry();
            final Path localPath = Paths.get(file2.getPath(), new String[0]);
            final UploadFileState uploadState = new UploadFileState();
            ListenableFuture<Void> futureUpload = parentEntry.uploadFile(localPath, new FileTransferProgress(){
                private long previousBytes;

                @Override
                public void progress(long currentBytes, long totalBytes) {
                    tracker.processFileBytes(currentBytes - this.previousBytes);
                    tracker.setUploadFileText(file2, currentBytes, totalBytes);
                    this.previousBytes = currentBytes;
                    uploadState.byteCount = totalBytes;
                    if (uploadState.childNode == null) {
                        String fileName = localPath.getFileName().toString();
                        uploadState.childNode = parentNode.findChildEntry(fileName);
                        if (uploadState.childNode != null) {
                            DeviceExplorerController.this.startNodeUpload(uploadState.childNode);
                        }
                    }
                    if (uploadState.childNode != null) {
                        uploadState.childNode.setTransferProgress(currentBytes, totalBytes);
                        return;
                    }
                    if (uploadState.loadChildrenFuture != null && uploadState.loadChildrenFuture.isDone()) {
                        uploadState.loadChildrenFuture = null;
                    }
                    if (currentBytes > 0L && uploadState.loadChildrenFuture == null) {
                        parentNode.setLoaded(false);
                        uploadState.loadChildrenFuture = ViewListener.this.loadNodeChildren(parentNode);
                    }
                }

                @Override
                public boolean isCancelled() {
                    return tracker.isCancelled();
                }
            });
            DeviceExplorerController.this.myEdtExecutor.addConsumer(futureUpload, (aVoid, throwable) -> {
                futureResult.set(null);
                if (throwable != null) {
                    tracker.addProblem((Throwable)throwable);
                } else {
                    tracker.getSummary().addFileCount(1);
                    tracker.getSummary().addByteCount(uploadState.byteCount);
                }
                if (uploadState.childNode != null) {
                    DeviceExplorerController.this.stopNodeUpload(uploadState.childNode);
                }
            });
            return futureResult;
        }

        private void reportFileTransferSummary(@NotNull DeviceFileEntryNode node2, @NotNull FileTransferSummary summary, @NotNull String pastParticiple, @NotNull String presentParticiple) {
            String fileString = StringUtil.pluralize((String)"file", (int)summary.getFileCount());
            String directoryString = StringUtil.pluralize((String)"directory", (int)summary.getDirectoryCount());
            String byteCountString = StringUtil.pluralize((String)"byte", (int)Ints.saturatedCast((long)summary.getByteCount()));
            if (summary.getProblems().isEmpty()) {
                String successMessage = summary.getDirectoryCount() > 0 ? String.format(Locale.getDefault(), "Successfully %s %,d %s and %,d %s for a total size of %,d %s in %s.", pastParticiple, summary.getFileCount(), fileString, summary.getDirectoryCount(), directoryString, summary.getByteCount(), byteCountString, StringUtil.formatDuration((long)summary.getDurationMillis())) : String.format(Locale.getDefault(), "Successfully %s %,d %s for a total of size of %,d %s in %s.", pastParticiple, summary.getFileCount(), fileString, summary.getByteCount(), byteCountString, StringUtil.formatDuration((long)summary.getDurationMillis()));
                DeviceExplorerController.this.myView.reportMessageRelatedToNode(node2, successMessage);
                return;
            }
            List problems = summary.getProblems().stream().map(x -> ExceptionUtil.getRootCause((Throwable)x).getMessage()).filter(Objects::nonNull).collect(Collectors.toList());
            boolean more = false;
            if (problems.size() > 10) {
                problems = problems.subList(0, 10);
                more = true;
            }
            String message2 = String.format("There were errors %s files and/or directories", presentParticiple);
            if (summary.getFileCount() > 0) {
                message2 = message2 + String.format(Locale.getDefault(), ", although %,d %s %s successfully %s in %s for a total of size of %,d %s", summary.getFileCount(), fileString, summary.getFileCount() <= 1 ? "was" : "were", pastParticiple, StringUtil.formatDuration((long)summary.getDurationMillis()), summary.getByteCount(), byteCountString);
            }
            DeviceExplorerController.this.myView.reportErrorRelatedToNode(node2, message2, new Exception("\n  " + StringUtil.join(problems, (String)",\n  ") + (more ? "\n  ..." : "")));
        }

        @NotNull
        private DeviceFileEntryNode getCommonParentNode(@NotNull List<DeviceFileEntryNode> treeNodes) {
            TreePath commonPath = TreeUtil.getCommonPath(treeNodes);
            LOGGER.assertTrue(commonPath != null);
            DeviceFileEntryNode result2 = DeviceFileEntryNode.fromNode(commonPath.getLastPathComponent());
            LOGGER.assertTrue(result2 != null);
            return result2;
        }

        private <V> void logFuture(@NotNull ListenableFuture<V> future2, @NotNull Function<Long, String> message2) {
            long startNano = System.nanoTime();
            DeviceExplorerController.this.myEdtExecutor.addListener(future2, () -> {
                long endNano = System.nanoTime();
                LOGGER.trace((String)message2.apply((endNano - startNano) / 1000000L));
            });
        }

        @Nullable
        private Path chooseSaveAsFilePath(@NotNull DeviceFileEntryNode treeNode) throws Exception {
            DeviceFileEntry entry = treeNode.getEntry();
            Path localPath = DeviceExplorerController.this.myFileManager.getDefaultLocalPathForEntry(entry);
            FileUtils.mkdirs((File)localPath.getParent().toFile());
            VirtualFile baseDir = VfsUtil.findFileByIoFile((File)localPath.getParent().toFile(), (boolean)true);
            if (baseDir == null) {
                throw new Exception(String.format("Unable to locate file \"%s\"", localPath.getParent()));
            }
            FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save As", "", new String[0]);
            FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, DeviceExplorerController.this.myProject);
            VirtualFileWrapper fileWrapper = saveFileDialog.save(baseDir, localPath.getFileName().toString());
            if (fileWrapper == null) {
                throw new CancellationException();
            }
            return fileWrapper.getFile().toPath();
        }

        @Nullable
        private Path chooseSaveAsDirectoryPath(@NotNull DeviceFileEntryNode treeNode) throws Exception {
            DeviceFileEntry entry = treeNode.getEntry();
            Path localPath = DeviceExplorerController.this.myFileManager.getDefaultLocalPathForEntry(entry);
            FileUtils.mkdirs((File)localPath.toFile());
            VirtualFile localDir = VfsUtil.findFileByIoFile((File)localPath.toFile(), (boolean)true);
            if (localDir == null) {
                throw new Exception(String.format("Unable to locate directory \"%s\"", localPath.getParent()));
            }
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            AtomicReference result2 = new AtomicReference();
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)DeviceExplorerController.this.myProject, (VirtualFile)localDir, files2 -> {
                if (files2.size() == 1) {
                    Path path2 = Paths.get(((VirtualFile)files2.get(0)).getPath(), new String[0]);
                    result2.set(path2);
                }
            });
            return (Path)result2.get();
        }

        @NotNull
        private ListenableFuture<Long> downloadFileEntry(final @NotNull DeviceFileEntryNode treeNode, @NotNull Path localPath, final @NotNull FileTransferOperationTracker tracker) {
            if (tracker.isCancelled()) {
                return Futures.immediateCancelledFuture();
            }
            tracker.processFile();
            DeviceFileEntry entry = treeNode.getEntry();
            final AtomicReference<Long> sizeRef = new AtomicReference<Long>(0L);
            ListenableFuture<VirtualFile> futureDownload = DeviceExplorerController.this.myFileManager.downloadFileEntry(entry, localPath, new DownloadProgress(){
                private long previousBytes;

                @Override
                public void onStarting(@NotNull String entryFullPath) {
                    DeviceFileEntryNode currentNode = ViewListener.this.getTreeNodeFromEntry(treeNode, entryFullPath);
                    assert (currentNode != null);
                    this.previousBytes = 0L;
                    DeviceExplorerController.this.startNodeDownload(currentNode);
                }

                @Override
                public void onProgress(@NotNull String entryFullPath, long currentBytes, long totalBytes) {
                    DeviceFileEntryNode currentNode = ViewListener.this.getTreeNodeFromEntry(treeNode, entryFullPath);
                    assert (currentNode != null);
                    tracker.processFileBytes(currentBytes - this.previousBytes);
                    this.previousBytes = currentBytes;
                    tracker.setDownloadFileText(entryFullPath, currentBytes, totalBytes);
                    currentNode.setTransferProgress(currentBytes, totalBytes);
                }

                @Override
                public void onCompleted(@NotNull String entryFullPath) {
                    DeviceFileEntryNode currentNode = ViewListener.this.getTreeNodeFromEntry(treeNode, entryFullPath);
                    assert (currentNode != null);
                    sizeRef.set((Long)sizeRef.get() + this.previousBytes);
                    DeviceExplorerController.this.stopNodeDownload(currentNode);
                }

                @Override
                public boolean isCancelled() {
                    return tracker.isCancelled();
                }
            });
            this.logFuture(futureDownload, millis -> String.format(Locale.US, "Downloaded file in %,d msec: %s", millis, entry.getFullPath()));
            return DeviceExplorerController.this.myEdtExecutor.transform(futureDownload, aVoid -> (Long)sizeRef.get());
        }

        @Override
        public void treeNodeExpanding(@NotNull DeviceFileEntryNode node2) {
            this.loadNodeChildren(node2);
        }

        private ListenableFuture<Void> loadNodeChildren(final @NotNull DeviceFileEntryNode node2) {
            if (node2.isLoaded()) {
                return Futures.immediateFuture(null);
            }
            node2.setLoaded(true);
            if (node2.isLeaf()) {
                return Futures.immediateFuture(null);
            }
            final DefaultTreeModel treeModel = DeviceExplorerController.this.getTreeModel();
            final DefaultTreeSelectionModel treeSelectionModel = DeviceExplorerController.this.getTreeSelectionModel();
            if (treeModel == null || treeSelectionModel == null) {
                return Futures.immediateFuture(null);
            }
            DeviceFileSystem fileSystem = DeviceExplorerController.this.myModel.getActiveDevice();
            if (!Objects.equals(fileSystem, node2.getEntry().getFileSystem())) {
                return Futures.immediateFuture(null);
            }
            ShowLoadingNodeRequest showLoadingNode = new ShowLoadingNodeRequest(treeModel, node2);
            DeviceExplorerController.this.myLoadingNodesAlarms.addRequest((Runnable)showLoadingNode, DeviceExplorerController.this.myShowLoadingNodeDelayMillis);
            DeviceExplorerController.this.startLoadChildren(node2);
            ListenableFuture<List<DeviceFileEntry>> futureEntries = node2.getEntry().getEntries();
            DeviceExplorerController.this.myEdtExecutor.addCallback(futureEntries, (FutureCallback)new FutureCallback<List<DeviceFileEntry>>(){

                public void onSuccess(List<DeviceFileEntry> result2) {
                    if (!Objects.equals(treeModel, DeviceExplorerController.this.getTreeModel())) {
                        return;
                    }
                    TreePath[] oldSelections = treeSelectionModel.getSelectionPaths();
                    Set isLinkToDirectory = node2.getChildEntryNodes().stream().filter(DeviceFileEntryNode::isSymbolicLinkToDirectory).map(x -> x.getEntry().getName()).collect(Collectors.toSet());
                    Comparator<DeviceFileEntry> comparator2 = NodeSorting.getCustomComparator(DeviceFileEntry::getName, x -> x.isDirectory() || isLinkToDirectory.contains(x.getName()));
                    result2.sort(comparator2);
                    List addedNodes = ViewListener.this.updateChildrenNodes(treeModel, node2, result2);
                    ViewListener.this.restoreTreeSelection(treeSelectionModel, oldSelections, node2);
                    List symlinkNodes = addedNodes.stream().filter(x -> x.getEntry().isSymbolicLink()).collect(Collectors.toList());
                    ViewListener.this.querySymbolicLinks(symlinkNodes, treeModel);
                }

                public void onFailure(@NotNull Throwable t) {
                    String message2 = ExceptionUtil.getRootCause((Throwable)t).getMessage();
                    if (StringUtil.isEmpty((String)message2)) {
                        message2 = String.format("Unable to list entries of directory %s", ViewListener.this.getUserFacingNodeName(node2));
                    }
                    node2.removeAllChildren();
                    node2.add(new ErrorNode(message2));
                    node2.setAllowsChildren(true);
                    treeModel.nodeStructureChanged(node2);
                }
            });
            DeviceExplorerController.this.myEdtExecutor.addListener(futureEntries, () -> {
                DeviceExplorerController.this.stopLoadChildren(node2);
                DeviceExplorerController.this.myLoadingNodesAlarms.cancelRequest((Runnable)showLoadingNode);
            });
            return FutureUtils.ignoreResult(futureEntries);
        }

        @NotNull
        private List<DeviceFileEntryNode> updateChildrenNodes(@NotNull DefaultTreeModel treeModel, @NotNull DeviceFileEntryNode parentNode, @NotNull List<DeviceFileEntry> newEntries) {
            TreeUtil.UpdateChildrenOps<DeviceFileEntryNode, DeviceFileEntry> updateChildrenOps = new TreeUtil.UpdateChildrenOps<DeviceFileEntryNode, DeviceFileEntry>(){

                @Override
                @Nullable
                public DeviceFileEntryNode getChildNode(@NotNull DeviceFileEntryNode parentNode, int index2) {
                    return DeviceFileEntryNode.fromNode(parentNode.getChildAt(index2));
                }

                @Override
                @NotNull
                public DeviceFileEntryNode mapEntry(@NotNull DeviceFileEntry entry) {
                    return new DeviceFileEntryNode(entry);
                }

                @Override
                public int compareNodeWithEntry(@NotNull DeviceFileEntryNode node2, @NotNull DeviceFileEntry entry) {
                    return node2.getEntry().getName().compareTo(entry.getName());
                }

                @Override
                public void updateNode(@NotNull DeviceFileEntryNode node2, @NotNull DeviceFileEntry entry) {
                    node2.setEntry(entry);
                }
            };
            List<DeviceFileEntryNode> addedNodes = TreeUtil.updateChildrenNodes(treeModel, parentNode, newEntries, updateChildrenOps);
            parentNode.setAllowsChildren(parentNode.getChildCount() > 0);
            return addedNodes;
        }

        private void restoreTreeSelection(@NotNull DefaultTreeSelectionModel treeSelectionModel, @NotNull TreePath[] oldSelections, @NotNull DefaultMutableTreeNode parentNode) {
            HashSet newSelections = new HashSet();
            TreePath parentPath = new TreePath(parentNode.getPath());
            Arrays.stream(oldSelections).forEach(x -> this.restorePathSelection(treeSelectionModel, parentPath, (TreePath)x, newSelections));
            TreePath[] newSelectionArray = (TreePath[])ArrayUtil.toObjectArray(new ArrayList(newSelections), TreePath.class);
            treeSelectionModel.addSelectionPaths(newSelectionArray);
        }

        private void restorePathSelection(@NotNull DefaultTreeSelectionModel treeSelectionModel, @NotNull TreePath parentPath, @NotNull TreePath oldPath, @NotNull Set<TreePath> selections) {
            if (treeSelectionModel.isPathSelected(oldPath)) {
                return;
            }
            if (Objects.equals(parentPath, oldPath)) {
                return;
            }
            if (!parentPath.isDescendant(oldPath)) {
                return;
            }
            TreeNode node2 = (TreeNode)parentPath.getLastPathComponent();
            TreeNode existingChild = TreeUtil.getChildren(node2).filter(x -> Objects.equals(x, oldPath.getLastPathComponent())).findFirst().orElse(null);
            if (existingChild == null) {
                selections.add(parentPath);
            }
        }

        private void querySymbolicLinks(@NotNull @Nullable List<DeviceFileEntryNode> symlinkNodes, @NotNull @Nullable DefaultTreeModel treeModel) {
            DeviceExplorerController.this.executeFuturesInSequence(symlinkNodes.iterator(), treeNode -> {
                ListenableFuture<Boolean> futureIsLinkToDirectory = treeNode.getEntry().isSymbolicLinkToDirectory();
                DeviceExplorerController.this.myEdtExecutor.addConsumer(futureIsLinkToDirectory, (result2, throwable) -> {
                    boolean isDirectory;
                    if (throwable != null) {
                        LOGGER.info(String.format("Error determining if file entry \"%s\" is a link to a directory", treeNode.getEntry().getName()), throwable);
                    }
                    if (!Objects.equals(DeviceExplorerController.this.myModel.getTreeModel(), treeModel)) {
                        return;
                    }
                    boolean bl = isDirectory = result2 != null && result2 != false;
                    if (treeNode.isSymbolicLinkToDirectory() != isDirectory) {
                        MutableTreeNode parent = (MutableTreeNode)treeNode.getParent();
                        int previousIndex = TreeUtil.binarySearch(parent, treeNode, NodeSorting.getTreeNodeComparator());
                        if (previousIndex >= 0) {
                            treeModel.removeNodeFromParent((MutableTreeNode)treeNode);
                        }
                        treeNode.setSymbolicLinkToDirectory(isDirectory);
                        int newIndex = TreeUtil.binarySearch(parent, treeNode, NodeSorting.getTreeNodeComparator());
                        if (newIndex < 0) {
                            treeModel.insertNodeInto((MutableTreeNode)treeNode, parent, -(newIndex + 1));
                        }
                    }
                });
                return FutureUtils.ignoreResult(futureIsLinkToDirectory);
            });
        }

        @NotNull
        private String getUserFacingNodeName(@NotNull DeviceFileEntryNode node2) {
            return StringUtil.isEmpty((String)node2.getEntry().getName()) ? "[root]" : "\"" + node2.getEntry().getName() + "\"";
        }

        private class UploadFileState {
            @Nullable
            public ListenableFuture<Void> loadChildrenFuture;
            @Nullable
            public DeviceFileEntryNode childNode;
            public long byteCount;

            private UploadFileState() {
            }
        }
    }

    private class ServiceListener
    implements DeviceFileSystemServiceListener {
        private ServiceListener() {
        }

        @Override
        public void serviceRestarted() {
            DeviceExplorerController.this.refreshDeviceList();
        }

        @Override
        public void deviceAdded(@NotNull DeviceFileSystem device) {
            DeviceExplorerController.this.myModel.addDevice(device);
        }

        @Override
        public void deviceRemoved(@NotNull DeviceFileSystem device) {
            DeviceExplorerController.this.myModel.removeDevice(device);
        }

        @Override
        public void deviceUpdated(@NotNull DeviceFileSystem device) {
            DeviceExplorerController.this.myModel.updateDevice(device);
            DeviceExplorerController.this.deviceStateUpdated(device);
        }
    }
}

