/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl;

import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.BlockGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.SwitchCaseGraph;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.GraphNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.SwitchBranchingNode;
import com.android.tools.idea.experimental.codeanalysis.datastructs.graph.node.impl.GraphNodeImpl;
import com.android.tools.idea.experimental.codeanalysis.datastructs.value.Value;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public class SwitchBranchingNodeImpl
extends GraphNodeImpl
implements SwitchBranchingNode {
    protected Value mCheckedValue;
    protected Map<Value, GraphNode> mSwitchTable = Maps.newHashMap();
    protected GraphNode mDefaultTarget;
    protected SwitchCaseGraph mCaseGraph;

    @Override
    public GraphNode[] getOut() {
        GraphNode[] retArray = new GraphNode[this.mSwitchTable.size()];
        int i2 = 0;
        for (Value v : this.mSwitchTable.keySet()) {
            GraphNode target;
            retArray[i2] = target = this.mSwitchTable.get(v);
            ++i2;
        }
        return retArray;
    }

    @Override
    public Value getCheckedValue() {
        return this.mCheckedValue;
    }

    @Override
    public GraphNode getDefaultTarget() {
        return this.mDefaultTarget;
    }

    @Override
    public void setDefaultTarget(GraphNode target) {
        this.mDefaultTarget = target;
    }

    @Override
    public Value[] getKeys() {
        Set<Value> keySet = this.mSwitchTable.keySet();
        return keySet.toArray(Value.EMPTY_ARRAY);
    }

    @Override
    public GraphNode getTargetViaKey(Value key) {
        if (this.mSwitchTable.containsKey(key)) {
            return this.mSwitchTable.get(key);
        }
        return null;
    }

    public void setCheckedValue(Value checkedValue) {
        this.mCheckedValue = checkedValue;
    }

    @Override
    public void setTargetViaKey(Value key, GraphNode target) {
        this.mSwitchTable.put(key, target);
        target.addIn(this);
    }

    @Override
    public void setSwitchCaseGraph(SwitchCaseGraph graph) {
        this.mCaseGraph = graph;
    }

    @Override
    public SwitchCaseGraph getSwitchCaseGraph() {
        return this.mCaseGraph;
    }

    @Override
    public String getSimpleName() {
        return "SwitchNode";
    }

    public SwitchBranchingNodeImpl(BlockGraph graph) {
        super(graph);
    }
}

