/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.experimental.codeanalysis.callgraph;

import com.android.tools.idea.experimental.codeanalysis.PsiCFGScene;
import com.android.tools.idea.experimental.codeanalysis.datastructs.PsiCFGClass;
import com.android.tools.idea.experimental.codeanalysis.utils.PsiCFGAnalysisUtil;
import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Map;
import java.util.Set;

public class CHAUtil {
    protected PsiCFGScene mScene;
    protected PsiCFGAnalysisUtil mAnalysisUtil;
    protected PsiCFGClass[] mClassIndexArray;
    protected Map<PsiCFGClass, Integer> mClassIndexMap;

    public CHAUtil(PsiCFGScene scene) {
        this.mScene = scene;
        this.mAnalysisUtil = this.mScene.analysisUtil;
    }

    public void buildBitSetIndex() {
        int i2;
        PsiCFGClass[] libraryClassArray;
        PsiCFGClass[] applicationClassArray = this.mScene.getAllApplicationClasses();
        int numofBits = applicationClassArray.length + (libraryClassArray = this.mScene.getAllLibraryClasses()).length;
        if (numofBits < 0) {
            throw new RuntimeException("Number of classes in this project is larger than 2G.");
        }
        this.mClassIndexArray = new PsiCFGClass[numofBits];
        this.mClassIndexMap = Maps.newHashMapWithExpectedSize((int)numofBits);
        for (i2 = 0; i2 < applicationClassArray.length; ++i2) {
            this.mClassIndexArray[i2] = applicationClassArray[i2];
            this.mClassIndexMap.put(applicationClassArray[i2], i2);
        }
        while (i2 < numofBits) {
            this.mClassIndexArray[i2] = libraryClassArray[i2 - applicationClassArray.length];
            this.mClassIndexMap.put(libraryClassArray[i2 - applicationClassArray.length], i2);
            ++i2;
        }
    }

    public BitSet bitSetCone(PsiCFGClass clazz) {
        BitSet coneSet = new BitSet(this.mClassIndexArray.length);
        this.dfsSetConeBits(coneSet, clazz);
        return coneSet;
    }

    private void dfsSetConeBits(BitSet bitSet, PsiCFGClass clazz) {
        if (!this.mClassIndexMap.containsKey(clazz)) {
            throw new RuntimeException("class is not found in IndexMap: " + clazz.getQualifiedClassName());
        }
        int index2 = this.mClassIndexMap.get(clazz);
        bitSet.set(index2);
        Set<PsiCFGClass> subClassSet = clazz.getSubClassSet();
        for (PsiCFGClass subClazz : subClassSet) {
            this.dfsSetConeBits(bitSet, subClazz);
        }
    }
}

