/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator.actions.dialogs;

import com.android.emulator.snapshot.SnapshotOuterClass;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010#\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010%\u001a\u00020&H\u0016R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0017\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0015\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010!\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/emulator/actions/dialogs/SnapshotInfo;", "", "snapshotFolder", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "snapshot", "Lcom/android/emulator/snapshot/SnapshotOuterClass$Snapshot;", "sizeOnDisk", "", "(Ljava/nio/file/Path;Lcom/android/emulator/snapshot/SnapshotOuterClass$Snapshot;J)V", "creationTime", "getCreationTime", "()J", "description", "", "getDescription", "()Ljava/lang/String;", "displayName", "getDisplayName", "isCreated", "", "()Z", "isQuickBoot", "isValid", "setValid", "(Z)V", "screenshotFile", "getScreenshotFile", "()Ljava/nio/file/Path;", "getSizeOnDisk", "getSnapshot", "()Lcom/android/emulator/snapshot/SnapshotOuterClass$Snapshot;", "getSnapshotFolder", "snapshotId", "getSnapshotId", "equals", "other", "hashCode", "", "intellij.android.emulator"})
public final class SnapshotInfo {
    @NotNull
    private final String snapshotId;
    private final boolean isQuickBoot;
    private boolean isValid;
    @NotNull
    private final Path snapshotFolder;
    @NotNull
    private final SnapshotOuterClass.Snapshot snapshot;
    private final long sizeOnDisk;

    @NotNull
    public final String getSnapshotId() {
        return this.snapshotId;
    }

    public final boolean isQuickBoot() {
        return this.isQuickBoot;
    }

    @NotNull
    public final String getDisplayName() {
        String string;
        if (this.isQuickBoot) {
            string = "Quickboot (auto-saved)";
        } else {
            string = StringKt.nullize$default((String)this.snapshot.getLogicalName(), (boolean)false, (int)1, null);
            if (string == null) {
                string = this.snapshotId;
            }
        }
        return string;
    }

    @NotNull
    public final Path getScreenshotFile() {
        return this.snapshotFolder.resolve("screenshot.png");
    }

    public final long getCreationTime() {
        return TimeUnit.SECONDS.toMillis(this.snapshot.getCreationTime());
    }

    @NotNull
    public final String getDescription() {
        return this.snapshot.getDescription();
    }

    public final boolean isCreated() {
        return this.snapshot.getCreationTime() != 0L;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void setValid(boolean bl) {
        this.isValid = bl;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.tools.idea.emulator.actions.dialogs.SnapshotInfo");
        }
        SnapshotInfo cfr_ignored_0 = (SnapshotInfo)object2;
        return !(Intrinsics.areEqual((Object)this.snapshotFolder, (Object)((SnapshotInfo)other).snapshotFolder) ^ true);
    }

    public int hashCode() {
        return ((Object)this.snapshotFolder).hashCode();
    }

    @NotNull
    public final Path getSnapshotFolder() {
        return this.snapshotFolder;
    }

    @NotNull
    public final SnapshotOuterClass.Snapshot getSnapshot() {
        return this.snapshot;
    }

    public final long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public SnapshotInfo(@NotNull Path snapshotFolder, @NotNull SnapshotOuterClass.Snapshot snapshot, long sizeOnDisk) {
        this.snapshotFolder = snapshotFolder;
        this.snapshot = snapshot;
        this.sizeOnDisk = sizeOnDisk;
        this.snapshotId = ((Object)this.snapshotFolder.getFileName()).toString();
        this.isQuickBoot = Intrinsics.areEqual((Object)this.snapshotId, (Object)"default_boot");
        this.isValid = true;
    }

    public SnapshotInfo(@NotNull Path snapshotFolder) {
        this(snapshotFolder, SnapshotOuterClass.Snapshot.getDefaultInstance(), 0L);
    }
}

