/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.lint.checks.ApiLookup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolutionUtils {
    private static final Logger LOG = Logger.getInstance(ResolutionUtils.class);

    private ResolutionUtils() {
    }

    @NotNull
    public static String getStyleResourceUrl(@NotNull String qualifiedName) {
        return ResolutionUtils.getResourceUrlFromQualifiedName(qualifiedName, "style");
    }

    public static String getResourceUrlFromQualifiedName(@NotNull String qualifiedName, @NotNull String type) {
        String startChar = "attr".equals(type) ? "?" : "@";
        int colonIndex = qualifiedName.indexOf(58);
        if (colonIndex != -1) {
            String namespace = qualifiedName.substring(0, colonIndex + 1);
            String themeNameWithoutNamespace = StringUtil.trimStart((String)qualifiedName, (String)namespace);
            return startChar + namespace + type + "/" + themeNameWithoutNamespace;
        }
        return startChar + type + "/" + qualifiedName;
    }

    @Deprecated
    @NotNull
    public static ResourceReference getStyleReference(@NotNull String themeName) {
        if (themeName.startsWith("android:")) {
            return ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)themeName.substring("android:".length()));
        }
        assert (themeName.indexOf(58) < 0);
        return ResourceReference.style((ResourceNamespace)ResourceNamespace.TODO(), (String)themeName);
    }

    @NotNull
    public static String getQualifiedNameFromResourceUrl(@NotNull String styleResourceUrl) {
        ResourceUrl url = ResourceUrl.parse((String)styleResourceUrl);
        assert (url != null) : styleResourceUrl;
        return url.namespace != null ? url.namespace + ':' + url.name : url.name;
    }

    @NotNull
    public static String getNameFromQualifiedName(@NotNull String qualifiedName) {
        int colonIndex = qualifiedName.indexOf(58);
        return colonIndex != -1 ? qualifiedName.substring(colonIndex + 1) : qualifiedName;
    }

    @NotNull
    public static String getQualifiedStyleName(@NotNull StyleResourceValue style) {
        String name = style.getName();
        return style.isFramework() ? "android:" + name : name;
    }

    @NotNull
    public static String getQualifiedItemAttrName(@NotNull StyleItemResourceValue item) {
        ResourceReference attr = item.getAttr();
        return attr != null ? attr.getRelativeResourceUrl(ResourceNamespace.TODO()).getQualifiedName() : item.getAttrName();
    }

    @Nullable
    public static ConfiguredThemeEditorStyle getThemeEditorStyle(@NotNull Configuration configuration, @NotNull ResourceReference styleReference) {
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        StyleResourceValue style = resolver.getStyle(styleReference);
        return style == null ? null : new ConfiguredThemeEditorStyle(configuration, style);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Configuration configuration, @NotNull StyleItemResourceValue itemResValue) {
        ResourceReference attr = itemResValue.getAttr();
        return attr == null ? null : ResolutionUtils.getAttributeDefinition(configuration.getModule(), attr);
    }

    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Module module2, @NotNull ResourceReference attr) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        assert (facet2 != null) : String.format("Module %s is not an Android module", module2.getName());
        AttributeDefinitions definitions = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().getAttributeDefinitions();
        return definitions.getAttrDefinition(attr);
    }

    @Deprecated
    @Nullable
    public static AttributeDefinition getAttributeDefinition(@NotNull Module module2, @Nullable Configuration configuration, @NotNull String name) {
        AttributeDefinitions definitions;
        if (name.startsWith("android:")) {
            IAndroidTarget target;
            if (configuration == null) {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                assert (facet2 != null);
                target = ConfigurationManager.getOrCreateInstance(module2).getDefaultTarget();
            } else {
                target = configuration.getRealTarget();
            }
            assert (target != null);
            AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, module2);
            assert (androidTargetData != null);
            definitions = androidTargetData.getAllAttrDefs(module2.getProject());
        } else {
            AndroidFacet facet3 = AndroidFacet.getInstance((Module)module2);
            assert (facet3 != null) : String.format("Module %s is not an Android module", module2.getName());
            definitions = ModuleResourceManagers.getInstance(facet3).getLocalResourceManager().getAttributeDefinitions();
        }
        if (definitions == null) {
            return null;
        }
        return definitions.getAttrDefByName(ResolutionUtils.getNameFromQualifiedName(name));
    }

    public static int getOriginalApiLevel(@Nullable String name, @NotNull Project project) {
        if (name == null) {
            return -1;
        }
        ApiLookup apiLookup = LintIdeClient.getApiLookup((Project)project);
        if (apiLookup == null) {
            LOG.warn("Could not find Lint client for project " + project.getName());
            return -1;
        }
        ResourceUrl resUrl = ResourceUrl.parse((String)name);
        if (resUrl == null) {
            if (!name.startsWith("android:")) {
                return -1;
            }
            return apiLookup.getFieldVersion("android/R$attr", name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN));
        }
        if (!resUrl.isFramework()) {
            return -1;
        }
        return apiLookup.getFieldVersion("android/R$" + resUrl.type, IdeResourcesUtil.getFieldNameByResourceName(resUrl.name));
    }

    @Nullable
    public static String getParentQualifiedName(@NotNull StyleResourceValue style) {
        ResourceReference parent = style.getParentStyle();
        if (parent == null) {
            return null;
        }
        return parent.getRelativeResourceUrl(ResourceNamespace.TODO()).getQualifiedName();
    }

    @NotNull
    public static Collection<StyleItemResourceValue> getThemeAttributes(@NotNull ResourceResolver resolver, @NotNull String themeUrl) {
        StyleResourceValue theme;
        HashMap<String, StyleItemResourceValue> allItems = new HashMap<String, StyleItemResourceValue>();
        String themeName = ResolutionUtils.getQualifiedNameFromResourceUrl(themeUrl);
        while ((theme = resolver.getStyle(ResolutionUtils.getNameFromQualifiedName(themeName), themeName.startsWith("android:"))) != null) {
            Collection themeItems = theme.getDefinedItems();
            for (StyleItemResourceValue item : themeItems) {
                String itemName = ResolutionUtils.getQualifiedItemAttrName(item);
                if (allItems.containsKey(itemName)) continue;
                allItems.put(itemName, item);
            }
            themeName = ResolutionUtils.getParentQualifiedName(theme);
            if (themeName != null) continue;
        }
        return allItems.values();
    }

    @Nullable
    public static ResourceType getAttrType(@NotNull StyleItemResourceValue item, @NotNull Configuration configuration) {
        ResourceResolver resolver = configuration.getResourceResolver();
        assert (resolver != null);
        return ResolutionUtils.getAttrType(item, resolver, configuration.getModule());
    }

    @Nullable
    public static ResourceType getAttrType(@NotNull StyleItemResourceValue item, @NotNull ResourceResolver resolver, @NotNull Module module2) {
        AttributeDefinition def;
        ResourceValue resolvedValue = resolver.resolveResValue((ResourceValue)item);
        ResourceType attrType = resolvedValue.getResourceType();
        if (attrType != null) {
            return attrType;
        }
        ResourceReference attr = item.getAttr();
        AttributeDefinition attributeDefinition = def = attr == null ? null : ResolutionUtils.getAttributeDefinition(module2, attr);
        if (def != null) {
            for (AttributeFormat attrFormat : def.getFormats()) {
                attrType = AndroidDomUtil.getResourceType(attrFormat);
                if (attrType == null) continue;
                return attrType;
            }
        }
        return null;
    }

    @NotNull
    public static FolderConfiguration getFolderConfiguration(@NotNull AndroidFacet facet2, @NotNull ResourceValue resolvedValue, @NotNull FolderConfiguration configuration) {
        List configurables2;
        if (resolvedValue.isFramework()) {
            ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(facet2.getModule());
            IAndroidTarget target = configurationManager.getDefaultTarget();
            assert (target != null);
            ResourceRepository resourceRepository = configurationManager.getResolverCache().getFrameworkResources(configuration, target);
            assert (resourceRepository != null);
            configurables2 = resourceRepository.getResources(ResourceNamespace.ANDROID, resolvedValue.getResourceType(), resolvedValue.getName());
        } else {
            LocalResourceRepository LocalResourceRepository2 = ResourceRepositoryManager.getAppResources(facet2);
            configurables2 = LocalResourceRepository2.getResources(ResourceNamespace.TODO(), resolvedValue.getResourceType(), resolvedValue.getName());
        }
        Configurable configurable = configuration.findMatchingConfigurable(configurables2);
        assert (configurable != null);
        return configurable.getConfiguration();
    }
}

